/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.StackWindow;
import ij.measure.Calibration;
import ij.plugin.PlugIn;

public class Animator
implements PlugIn {
    private static double animationSpeed = Prefs.getDouble("fps", 7.0);
    private static boolean oscillate;
    private ImagePlus imp;
    private StackWindow swin;
    private int slice;
    private int nSlices;
    static /* synthetic */ Class class$ij$plugin$Animator;

    public void run(String arg) {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        this.nSlices = this.imp.getStackSize();
        if (this.nSlices < 2) {
            IJ.error("Stack required.");
            return;
        }
        ImageWindow win = this.imp.getWindow();
        if (!(win instanceof StackWindow)) {
            return;
        }
        this.swin = (StackWindow)win;
        ImageStack stack = this.imp.getStack();
        this.slice = this.imp.getCurrentSlice();
        IJ.register(class$ij$plugin$Animator == null ? (class$ij$plugin$Animator = Animator.class$("ij.plugin.Animator")) : class$ij$plugin$Animator);
        if (arg.equals("options")) {
            this.doOptions();
            return;
        }
        if (arg.equals("start")) {
            this.startAnimation();
            return;
        }
        if (this.swin.running) {
            this.stopAnimation();
        }
        if (arg.equals("stop")) {
            return;
        }
        if (arg.equals("next")) {
            if (!this.imp.lock()) {
                return;
            }
            this.slice = IJ.altKeyDown() ? (this.slice += 10) : ++this.slice;
            if (this.slice > this.nSlices) {
                this.slice = this.nSlices;
            }
            this.swin.showSlice(this.slice);
            this.imp.updateStatusbarValue();
            this.imp.unlock();
            return;
        }
        if (arg.equals("previous")) {
            if (!this.imp.lock()) {
                return;
            }
            this.slice = IJ.altKeyDown() ? (this.slice -= 10) : --this.slice;
            if (this.slice < 1) {
                this.slice = 1;
            }
            this.swin.showSlice(this.slice);
            this.imp.updateStatusbarValue();
            this.imp.unlock();
            return;
        }
    }

    void stopAnimation() {
        this.swin.running = false;
        IJ.wait(500 + (int)(1000.0 / animationSpeed));
        this.imp.unlock();
    }

    void startAnimation() {
        if (this.swin.running) {
            this.stopAnimation();
            return;
        }
        this.imp.unlock();
        this.swin.running = true;
        long nextTime = System.currentTimeMillis();
        Thread.currentThread().setPriority(1);
        int sliceIncrement = 1;
        Calibration cal = this.imp.getCalibration();
        if (cal.frameInterval != 0.0) {
            animationSpeed = 1.0 / cal.frameInterval;
        }
        while (this.swin.running) {
            long time = System.currentTimeMillis();
            if (time < nextTime) {
                IJ.wait((int)(nextTime - time));
            } else {
                Thread.yield();
            }
            nextTime += (long)(1000.0 / animationSpeed);
            this.slice += sliceIncrement;
            if (this.slice < 1) {
                this.slice = 2;
                sliceIncrement = 1;
            }
            if (this.slice > this.nSlices) {
                if (oscillate) {
                    this.slice = this.nSlices - 1;
                    sliceIncrement = -1;
                } else {
                    this.slice = 1;
                    sliceIncrement = 1;
                }
            }
            this.swin.showSlice(this.slice);
        }
    }

    void doOptions() {
        boolean start = !this.swin.running;
        boolean saveOscillate = oscillate;
        Calibration cal = this.imp.getCalibration();
        if (cal.frameInterval != 0.0) {
            animationSpeed = 1.0 / cal.frameInterval;
        }
        GenericDialog gd = new GenericDialog("Animation Options");
        gd.addNumericField("Speed (1-100 fps):", animationSpeed, 0);
        gd.addCheckbox("Loop Back and Forth", oscillate);
        gd.addCheckbox("Start Animation", start);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        double speed = gd.getNextNumber();
        oscillate = gd.getNextBoolean();
        start = gd.getNextBoolean();
        if (speed > 100.0) {
            speed = 100.0;
        }
        if (speed < 1.0) {
            speed = 1.0;
        }
        if ((animationSpeed = speed) != 0.0) {
            cal.frameInterval = 1.0 / animationSpeed;
        }
        if (start && !this.swin.running) {
            this.startAnimation();
        }
    }

    public static double getFrameRate() {
        return animationSpeed;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

