/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.process.ColorProcessor;
import java.awt.Color;

class ColorGenerator
extends ColorProcessor {
    int w;
    int h;
    int[] colors = new int[]{0xFFFFFF, 0x700000, 0xB00000, 0xFF0000, 0xFF6000, 0xFFAABB, 14381203, 16716947, 0xCD5C5C, 0x900090, 12211667, 0xEE82EE, 0xFF00FF, 4734347, 0xBB0088, 0, 112, 176, 255, 11584734, 49151, 6266528, 65535, 2142890, 6737322, 64154, 28672, 45056, 65280, 28768, 10145074, 0x808000, 0xFFFFC0, 0xFFFF00, 12433259, 15787660, 12092939, 16762880, 16768685, 16750080, 13789470, 15308410, 14729436, 16772043, 0x606000, 0x600060, 0x8080A0, 0x80A080};

    public ColorGenerator(int width, int height, int[] pixels) {
        super(width, height, pixels);
    }

    void drawColors(int colorWidth, int colorHeight, int columns, int rows) {
        this.w = colorWidth;
        this.h = colorHeight;
        this.drawRamp();
        int x = 0;
        int y = 1;
        int i = 0;
        while (i < this.colors.length) {
            this.drawColor(x, y, new Color(this.colors[i]));
            if (++x == columns) {
                x = 0;
                if (++y == rows) break;
            }
            ++i;
        }
        this.setRoi(null);
    }

    void drawColor(int x, int y, Color c2) {
        this.setRoi(x * this.w, y * this.h, this.w, this.h);
        this.setColor(c2);
        this.fill();
    }

    void drawRamp() {
        int y = 0;
        while (y < this.h) {
            int x = 0;
            while (x < 256) {
                byte b2;
                byte g = b2 = (byte)x;
                byte r = b2;
                this.pixels[y * this.width + x] = 0xFF000000 | r << 16 & 0xFF0000 | g << 8 & 0xFF00 | b2 & 0xFF;
                ++x;
            }
            ++y;
        }
    }
}

