/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.plugin.FolderOpenerDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.util.StringSorter;
import java.awt.image.ColorModel;
import java.io.File;

public class FolderOpener
implements PlugIn {
    private static boolean grayscale;
    private static boolean halfSize;
    private int n;
    private int start;
    private int increment;
    private String filter;
    static /* synthetic */ Class class$ij$plugin$FolderOpener;

    public void run(String arg) {
        OpenDialog od = new OpenDialog("Image Sequence...", arg);
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        String[] list = new File(directory).list();
        if (list == null) {
            return;
        }
        IJ.register(class$ij$plugin$FolderOpener == null ? (class$ij$plugin$FolderOpener = FolderOpener.class$("ij.plugin.FolderOpener")) : class$ij$plugin$FolderOpener);
        StringSorter.sort(list);
        if (IJ.debugMode) {
            IJ.log("FolderOpener: " + directory + " (" + list.length + " files)");
        }
        int width = 0;
        int height = 0;
        int type = 0;
        ImageStack stack = null;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        try {
            int i = 0;
            while (i < list.length) {
                ImagePlus imp;
                if (!list[i].endsWith(".txt") && (imp = new Opener().openImage(directory, list[i])) != null) {
                    width = imp.getWidth();
                    height = imp.getHeight();
                    type = imp.getType();
                    if (this.showDialog(imp, list)) break;
                    return;
                }
                ++i;
            }
            if (this.n < 1) {
                this.n = list.length;
            }
            if (this.start < 1 || this.start > list.length) {
                this.start = 1;
            }
            if (this.start + this.n - 1 > list.length) {
                this.n = list.length - this.start + 1;
            }
            int filteredImages = this.n;
            if (this.filter.equals("") || this.filter.equals("*")) {
                this.filter = null;
            }
            if (this.filter != null) {
                filteredImages = 0;
                int i2 = this.start - 1;
                while (i2 < this.start - 1 + this.n) {
                    if (list[i2].indexOf(this.filter) >= 0) {
                        ++filteredImages;
                    }
                    ++i2;
                }
                if (filteredImages == 0) {
                    IJ.error("None of the " + this.n + " files contain\n the string '" + this.filter + "' in their name.");
                    return;
                }
            }
            this.n = filteredImages;
            int count = 0;
            int counter = 0;
            int i3 = this.start - 1;
            while (i3 < list.length) {
                if (!(list[i3].endsWith(".txt") || this.filter != null && list[i3].indexOf(this.filter) < 0 || counter++ % this.increment != 0)) {
                    ImagePlus imp = new Opener().openImage(directory, list[i3]);
                    if (imp != null && stack == null) {
                        width = imp.getWidth();
                        height = imp.getHeight();
                        type = imp.getType();
                        ColorModel cm = imp.getProcessor().getColorModel();
                        stack = halfSize ? new ImageStack(width / 2, height / 2, cm) : new ImageStack(width, height, cm);
                    }
                    if (imp == null) {
                        IJ.write(list[i3] + ": unable to open");
                    } else if (imp.getWidth() != width || imp.getHeight() != height) {
                        IJ.write(list[i3] + ": wrong dimensions");
                    } else if (imp.getType() != type) {
                        IJ.write(list[i3] + ": wrong type");
                    } else {
                        count = stack.getSize() + 1;
                        IJ.showStatus(count + "/" + this.n);
                        IJ.showProgress((double)count / (double)this.n);
                        ImageProcessor ip = imp.getProcessor();
                        if (grayscale) {
                            ip = ip.convertToByte(true);
                        }
                        if (halfSize) {
                            ip = ip.resize(width / 2, height / 2);
                        }
                        if (ip.getMin() < min) {
                            min = ip.getMin();
                        }
                        if (ip.getMax() > max) {
                            max = ip.getMax();
                        }
                        stack.addSlice(imp.getTitle(), ip);
                    }
                    if (count >= this.n) break;
                }
                ++i3;
            }
        }
        catch (OutOfMemoryError e2) {
            IJ.outOfMemory("FolderOpener");
            stack.trim();
        }
        if (stack != null && stack.getSize() > 0) {
            ImagePlus imp2 = new ImagePlus("Stack", stack);
            if (imp2.getType() == 1 || imp2.getType() == 2) {
                imp2.getProcessor().setMinAndMax(min, max);
            }
            imp2.show();
        }
        IJ.showProgress(1.0);
    }

    boolean showDialog(ImagePlus imp, String[] list) {
        int fileCount = list.length;
        FolderOpenerDialog gd = new FolderOpenerDialog("Sequence Options", imp, list);
        gd.addNumericField("Number of Images: ", fileCount, 0);
        gd.addNumericField("Starting Image: ", 1.0, 0);
        gd.addNumericField("Increment: ", 1.0, 0);
        gd.addStringField("File Name Contains: ", "");
        gd.addCheckbox("Convert to 8-bits", grayscale);
        gd.addCheckbox("Open 1/2 Size", halfSize);
        gd.addMessage("10000 x 10000 x 1000 (100.3MB)");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.n = (int)gd.getNextNumber();
        this.start = (int)gd.getNextNumber();
        this.increment = (int)gd.getNextNumber();
        if (this.increment < 1) {
            this.increment = 1;
        }
        this.filter = gd.getNextString();
        grayscale = gd.getNextBoolean();
        halfSize = gd.getNextBoolean();
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

