/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.Executer;
import ij.IJ;
import ij.Menus;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.util.StringSorter;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Hotkeys
implements PlugIn {
    private static final String TITLE = "Hotkeys";
    private static String command = "";
    private static String shortcut = "";
    static /* synthetic */ Class class$ij$plugin$Hotkeys;

    public void run(String arg) {
        if (arg.equals("install")) {
            this.installHotkey();
        } else if (arg.equals("remove")) {
            this.removeHotkey();
        } else {
            Executer e2 = new Executer(arg);
            e2.run();
        }
        IJ.register(class$ij$plugin$Hotkeys == null ? (class$ij$plugin$Hotkeys = Hotkeys.class$("ij.plugin.Hotkeys")) : class$ij$plugin$Hotkeys);
    }

    void installHotkey() {
        String[] commands = this.getAllCommands();
        GenericDialog gd = new GenericDialog("Create Shortcut");
        gd.addChoice("Command:", commands, command);
        gd.addStringField("Shortcut:", shortcut, 3);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        command = gd.getNextChoice();
        shortcut = gd.getNextString();
        if (shortcut.equals("")) {
            IJ.showMessage(TITLE, "Shortcut required");
            return;
        }
        if (shortcut.length() > 1) {
            shortcut = shortcut.replace('f', 'F');
        }
        String plugin = "ij.plugin.Hotkeys(\"" + command + "\")";
        int err = Menus.installPlugin(plugin, 'h', "*" + command, shortcut, IJ.getInstance());
        switch (err) {
            case -2: {
                IJ.showMessage(TITLE, "The shortcut must be a single character or F1-F12.");
                break;
            }
            case -3: {
                IJ.showMessage("The \"" + shortcut + "\" shortcut is already being used.");
                break;
            }
            default: {
                shortcut = "";
            }
        }
    }

    void removeHotkey() {
        String[] commands = this.getInstalledCommands();
        if (commands == null) {
            IJ.showMessage("Remove...", "No installed commands found.");
            return;
        }
        GenericDialog gd = new GenericDialog("Remove");
        gd.addChoice("Command:", commands, "");
        gd.addMessage("The command is not removed\nuntil ImageJ is restarted.");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        command = gd.getNextChoice();
        int err = Menus.uninstallPlugin(command);
        boolean removed = true;
        if (err == -5) {
            removed = this.deletePlugin(command);
        }
        if (removed) {
            IJ.showStatus("\"" + command + "\" removed; ImageJ restart required");
        } else {
            IJ.showStatus("\"" + command + "\" not removed");
        }
    }

    boolean deletePlugin(String command) {
        String plugin = (String)Menus.getCommands().get(command);
        String name = plugin + ".class";
        File file = new File(Menus.getPlugInsPath(), name);
        if (file == null || !file.exists()) {
            return false;
        }
        return IJ.showMessageWithCancel("Delete Plugin?", "Permanently delete \"" + name + "\"?");
    }

    String[] getAllCommands() {
        Vector<String> v = new Vector<String>();
        Enumeration en = Menus.getCommands().keys();
        while (en.hasMoreElements()) {
            String cmd = (String)en.nextElement();
            if (cmd.startsWith("*")) continue;
            v.addElement(cmd);
        }
        Object[] list = new String[v.size()];
        v.copyInto(list);
        StringSorter.sort((String[])list);
        return list;
    }

    String[] getInstalledCommands() {
        Vector<String> v = new Vector<String>();
        Hashtable commandTable = Menus.getCommands();
        Enumeration en = commandTable.keys();
        while (en.hasMoreElements()) {
            String cmd = (String)en.nextElement();
            if (cmd.startsWith("*")) {
                v.addElement(cmd);
                continue;
            }
            String plugin = (String)commandTable.get(cmd);
            if (plugin.indexOf("_") < 0 || plugin.startsWith("ij.")) continue;
            v.addElement(cmd);
        }
        if (v.size() == 0) {
            return null;
        }
        Object[] list = new String[v.size()];
        v.copyInto(list);
        StringSorter.sort((String[])list);
        return list;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

