/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.io.JpegEncoder;
import ij.plugin.PlugIn;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class JpegWriter
implements PlugIn {
    public void run(String arg) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            return;
        }
        imp.startTiming();
        this.saveAsJpeg(imp, arg);
        IJ.showTime(imp, imp.getStartTime(), "JpegWriter: ");
    }

    void saveAsJpeg(ImagePlus imp, String path) {
        int width = imp.getWidth();
        int height = imp.getHeight();
        BufferedImage bi = new BufferedImage(width, height, 1);
        try {
            FileOutputStream f = new FileOutputStream(path);
            Graphics2D g = bi.createGraphics();
            g.drawImage(imp.getImage(), 0, 0, null);
            g.dispose();
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)f);
            JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(bi);
            param.setQuality((float)((double)JpegEncoder.getQuality() / 100.0), true);
            encoder.encode(bi, param);
            f.close();
        }
        catch (Exception e2) {
            IJ.showMessage("Jpeg Writer", "" + e2);
        }
    }
}

