/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Font;

public class MemoryMonitor
implements PlugIn {
    int width = 200;
    int height = 75;
    long fps;
    long startTime;
    long elapsedTime;
    ImageProcessor ip;
    int frames;
    ImageCanvas ic;
    int[] mem;
    int index;
    int value;
    int max = 14794752;

    void showAbout() {
        IJ.showMessage("About MemoryMonitor...", "This plugin continuously plots ImageJ's memory\nutilization. It could also be used as a starting\npoint for a video acquisition plugin. Hold down the\nalt/option key when selecting the \"Monitor Memory\"\ncommand and the plugin will use a 640x480 window\nand display the frame rate. Click on the status bar in the\nImageJ window to force the JVM to do garbage collection.");
    }

    public void run(String arg) {
        if (arg.equals("about")) {
            this.showAbout();
            return;
        }
        if (IJ.altKeyDown()) {
            this.width = 640;
            this.height = 480;
        }
        this.ip = new ByteProcessor(this.width, this.height, new byte[this.width * this.height], null);
        this.ip.setColor(Color.white);
        this.ip.fill();
        this.ip.setColor(Color.black);
        this.ip.setFont(new Font("SansSerif", 0, 12));
        this.ip.snapshot();
        ImagePlus imp = new ImagePlus("Memory", this.ip);
        ImageWindow.centerNextImage();
        imp.show();
        imp.lock();
        ImageWindow win = imp.getWindow();
        this.ic = win.getCanvas();
        this.mem = new int[this.width + 1];
        Thread.currentThread().setPriority(1);
        this.startTime = System.currentTimeMillis();
        win.running = true;
        while (win.running) {
            this.updatePixels();
            this.showValue();
            imp.updateAndDraw();
            if (this.width == 640) {
                Thread.yield();
            } else {
                IJ.wait(100);
            }
            ++this.frames;
        }
        imp.unlock();
    }

    void showValue() {
        String s = this.value / 1024 + "K";
        if (this.width == 640) {
            this.elapsedTime = System.currentTimeMillis() - this.startTime;
            if (this.elapsedTime > 0L) {
                double scale = this.ic.getMagnification();
                this.fps = (long)(this.frames * 10000) / this.elapsedTime;
                s = s + ", " + this.fps / 10L + "." + this.fps % 10L + " fps";
            }
        }
        this.ip.moveTo(2, 15);
        this.ip.drawString(s);
    }

    int memoryInUse() {
        long freeMem = Runtime.getRuntime().freeMemory();
        long totMem = Runtime.getRuntime().totalMemory();
        return (int)(totMem - freeMem);
    }

    void updatePixels() {
        int used = this.memoryInUse();
        if (this.frames % 10 == 0) {
            this.value = used;
        }
        if ((double)used > 0.9 * (double)this.max) {
            this.max *= 2;
        }
        this.mem[this.index++] = used;
        if (this.index == this.mem.length) {
            this.index = 0;
        }
        this.ip.reset();
        int index2 = this.index + 1;
        if (index2 == this.mem.length) {
            index2 = 0;
        }
        double scale = (double)this.height / (double)this.max;
        this.ip.moveTo(0, this.height - (int)((double)this.mem[index2] * scale));
        int x = 1;
        while (x < this.width) {
            if (++index2 == this.mem.length) {
                index2 = 0;
            }
            this.ip.lineTo(x, this.height - (int)((double)this.mem[index2] * scale));
            ++x;
        }
    }
}

