/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import java.awt.Color;

public class MontageMaker
implements PlugIn {
    private static int columns;
    private static int rows;
    private static int first;
    private static int last;
    private static int inc;
    private static double scale;
    private static boolean label;
    private static boolean borders;
    private static int saveID;
    static /* synthetic */ Class class$ij$plugin$MontageMaker;

    public void run(String arg) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null || imp.getStackSize() == 1) {
            IJ.error("Stack required");
            return;
        }
        this.makeMontage(imp);
        saveID = imp.getID();
        IJ.register(class$ij$plugin$MontageMaker == null ? (class$ij$plugin$MontageMaker = MontageMaker.class$("ij.plugin.MontageMaker")) : class$ij$plugin$MontageMaker);
    }

    public void makeMontage(ImagePlus imp) {
        int nSlices = imp.getStackSize();
        if (columns == 0 || imp.getID() != saveID) {
            rows = columns = (int)Math.sqrt(nSlices);
            int n = nSlices - columns * rows;
            if (n > 0) {
                columns += (int)Math.ceil((double)n / (double)rows);
            }
            scale = 1.0;
            if (imp.getWidth() * columns > 800) {
                scale = 0.5;
            }
            if (imp.getWidth() * columns > 1600) {
                scale = 0.25;
            }
            inc = 1;
            first = 1;
            last = nSlices;
        }
        GenericDialog gd = new GenericDialog("Make Montage", IJ.getInstance());
        gd.addNumericField("Columns:", columns, 0);
        gd.addNumericField("Rows:", rows, 0);
        gd.addNumericField("Scale Factor:", scale, 2);
        gd.addNumericField("First Slice:", first, 0);
        gd.addNumericField("Last Slice:", last, 0);
        gd.addNumericField("Increment:", inc, 0);
        gd.addCheckbox("Label Slices", label);
        gd.addCheckbox("Borders", borders);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        columns = (int)gd.getNextNumber();
        rows = (int)gd.getNextNumber();
        scale = gd.getNextNumber();
        first = (int)gd.getNextNumber();
        last = (int)gd.getNextNumber();
        inc = (int)gd.getNextNumber();
        if (first < 1) {
            first = 1;
        }
        if (last > nSlices) {
            last = nSlices;
        }
        if (inc < 1) {
            inc = 1;
        }
        if (gd.invalidNumber()) {
            IJ.error("Invalid number");
            return;
        }
        label = gd.getNextBoolean();
        borders = gd.getNextBoolean();
        this.makeMontage(imp, columns, rows, scale, first, last, inc, label, borders);
    }

    public void makeMontage(ImagePlus imp, int columns, int rows, double scale, int first, int last, int inc, boolean labels, boolean borders) {
        boolean blackBackground;
        int stackWidth = imp.getWidth();
        int stackHeight = imp.getHeight();
        int nSlices = imp.getStackSize();
        int width = (int)((double)stackWidth * scale);
        int height = (int)((double)stackHeight * scale);
        int montageWidth = width * columns;
        int montageHeight = height * rows;
        ImageProcessor ip = imp.getProcessor();
        ImageProcessor montage = ip.createProcessor(montageWidth, montageHeight);
        ImageStatistics is = imp.getStatistics();
        boolean bl = blackBackground = is.mode < 200;
        if (imp.isInvertedLut()) {
            boolean bl2 = blackBackground = !blackBackground;
        }
        if (ip instanceof ShortProcessor || ip instanceof FloatProcessor) {
            blackBackground = true;
        }
        if (blackBackground) {
            montage.setColor(Color.black);
            montage.fill();
            montage.setColor(Color.white);
        } else {
            montage.setColor(Color.white);
            montage.fill();
            montage.setColor(Color.black);
        }
        ImageStack stack = imp.getStack();
        int x = 0;
        int y = 0;
        int slice = first;
        while (slice <= last) {
            ImageProcessor aSlice = stack.getProcessor(slice);
            if (scale != 1.0) {
                aSlice = aSlice.resize(width, height);
            }
            montage.insert(aSlice, x, y);
            if (borders) {
                this.drawBorder(montage, x, y, width, height);
            }
            if (labels) {
                this.drawLabel(montage, slice, x, y, width, height);
            }
            if ((x += width) >= montageWidth) {
                x = 0;
                if ((y += height) >= montageHeight) break;
            }
            IJ.showProgress((double)(slice - first) / (double)(last - first));
            slice += inc;
        }
        if (borders) {
            this.drawBorder(montage, 0, 0, montageWidth - 1, montageHeight - 1);
        }
        IJ.showProgress(1.0);
        ImagePlus imp2 = new ImagePlus("Montage", montage);
        imp2.setCalibration(imp.getCalibration());
        Calibration cal = imp2.getCalibration();
        if (cal.scaled()) {
            cal.pixelWidth /= scale;
            cal.pixelHeight /= scale;
        }
        imp2.show();
    }

    void drawBorder(ImageProcessor montage, int x, int y, int width, int height) {
        montage.moveTo(x, y);
        montage.lineTo(x + width, y);
        montage.lineTo(x + width, y + height);
        montage.lineTo(x, y + height);
        montage.lineTo(x, y);
    }

    void drawLabel(ImageProcessor montage, int slice, int x, int y, int width, int height) {
        String s = "" + slice;
        int swidth = montage.getStringWidth(s);
        montage.moveTo(x += width / 2 - swidth / 2, y += height);
        montage.drawString(s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        label = false;
        borders = false;
    }
}

