/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.plugin.PlugIn;
import ij.text.TextWindow;
import java.io.CharArrayWriter;
import java.io.PrintWriter;

public class ThreadLister
implements PlugIn {
    public void run(String arg) {
        if (IJ.getApplet() != null) {
            return;
        }
        CharArrayWriter caw = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(caw);
        try {
            ThreadLister.listAllThreads(pw);
            new TextWindow("Threads", caw.toString(), 300, 300);
        }
        catch (Exception e2) {}
    }

    private static void print_thread_info(PrintWriter out, Thread t2, String indent) {
        if (t2 == null) {
            return;
        }
        out.print(indent + "Thread: " + t2.getName() + "  Priority: " + t2.getPriority() + (t2.isDaemon() ? " Daemon" : "") + (t2.isAlive() ? "" : " Not Alive") + "\n");
    }

    private static void list_group(PrintWriter out, ThreadGroup g, String indent) {
        if (g == null) {
            return;
        }
        int num_threads = g.activeCount();
        int num_groups = g.activeGroupCount();
        Thread[] threads = new Thread[num_threads];
        ThreadGroup[] groups = new ThreadGroup[num_groups];
        g.enumerate(threads, false);
        g.enumerate(groups, false);
        out.println(indent + "Thread Group: " + g.getName() + "  Max Priority: " + g.getMaxPriority() + (g.isDaemon() ? " Daemon" : "") + "\n");
        int i = 0;
        while (i < num_threads) {
            ThreadLister.print_thread_info(out, threads[i], indent + "    ");
            ++i;
        }
        int i2 = 0;
        while (i2 < num_groups) {
            ThreadLister.list_group(out, groups[i2], indent + "    ");
            ++i2;
        }
    }

    public static void listAllThreads(PrintWriter out) {
        ThreadGroup current_thread_group;
        ThreadGroup root_thread_group = current_thread_group = Thread.currentThread().getThreadGroup();
        ThreadGroup parent = root_thread_group.getParent();
        while (parent != null) {
            root_thread_group = parent;
            parent = parent.getParent();
        }
        ThreadLister.list_group(out, root_thread_group, "");
    }
}

