/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.Line;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.measure.CurveFitter;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import ij.text.TextWindow;
import java.awt.Rectangle;

public class Info
implements PlugInFilter {
    private ImagePlus imp;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 159;
    }

    public void run(ImageProcessor ip) {
        String infoProperty = (String)this.imp.getProperty("Info");
        String info = this.getInfo(ip);
        if (infoProperty != null) {
            this.showInfo(infoProperty + "\n------------------------\n" + info, 400, 500);
        } else {
            this.showInfo(info, 300, 300);
        }
    }

    String getInfo(ImageProcessor ip) {
        String s = new String("\n");
        s = s + "Title: '" + this.imp.getTitle() + "'\n";
        Calibration cal = this.imp.getCalibration();
        if (cal.scaled()) {
            String unit = cal.getUnit();
            String units = cal.getUnits();
            s = s + "Width:  " + IJ.d2s((double)this.imp.getWidth() * cal.pixelWidth, 2) + " " + units + " (" + this.imp.getWidth() + ")\n";
            s = s + "Height:  " + IJ.d2s((double)this.imp.getHeight() * cal.pixelHeight, 2) + " " + units + " (" + this.imp.getHeight() + ")\n";
            if (cal.pixelWidth == cal.pixelHeight) {
                s = s + "Resolution:  " + IJ.d2s(1.0 / cal.pixelWidth, 1) + " pixels per " + unit + "\n";
            } else {
                s = s + "X Resolution:  " + IJ.d2s(1.0 / cal.pixelWidth, 1) + " pixels per " + unit + "\n";
                s = s + "Y Resolution:  " + IJ.d2s(1.0 / cal.pixelHeight, 1) + " pixels per " + unit + "\n";
            }
        } else {
            s = s + "Width:  " + this.imp.getWidth() + " pixels\n";
            s = s + "Height:  " + this.imp.getHeight() + " pixels\n";
        }
        int type = this.imp.getType();
        switch (type) {
            case 0: {
                s = s + "Bits per pixel: 8 ";
                if (this.imp.isInvertedLut()) {
                    s = s + "(inverted LUT)\n";
                    break;
                }
                s = s + "(grayscale LUT)\n";
                break;
            }
            case 1: 
            case 2: {
                if (type == 1) {
                    ShortProcessor sp = (ShortProcessor)this.imp.getProcessor();
                    s = s + "Bits per pixel: 16 (unsigned short)\n";
                } else {
                    s = s + "Bits per pixel: 32 (float)\n";
                }
                s = s + "Display range: ";
                int places = type == 1 ? 0 : 2;
                double min = ip.getMin();
                double max = ip.getMax();
                if (cal.calibrated()) {
                    min = cal.getCValue((int)min);
                    max = cal.getCValue((int)max);
                }
                s = s + IJ.d2s(min, places) + " - " + IJ.d2s(max, places) + "\n";
                break;
            }
            case 3: {
                s = s + "Bits per pixel: 8 (color LUT)\n";
                break;
            }
            case 4: {
                s = s + "Bits per pixel: 32 (RGB)\n";
            }
        }
        int nSlices = this.imp.getStackSize();
        if (nSlices > 1) {
            double interval = cal.frameInterval;
            String label = interval > 0.0 ? "Frames: " : "Slices: ";
            s = s + label + nSlices + " (" + this.imp.getCurrentSlice() + ")\n";
            if (interval > 0.0) {
                if (interval < 1.0) {
                    double rate = 1.0 / interval;
                    String sRate = Math.abs(rate - (double)Math.round(rate)) < 1.0E-5 ? IJ.d2s(rate, 0) : IJ.d2s(rate, 5);
                    s = s + "Frame rate: " + sRate + " fps\n";
                } else {
                    s = s + "Frame interval: " + IJ.d2s(interval, 5) + " seconds\n";
                }
            }
        }
        s = ip.getMinThreshold() == -808080.0 ? s + "No Threshold\n" : s + "Threshold: " + IJ.d2s(ip.getMinThreshold(), 0) + "-" + IJ.d2s(ip.getMaxThreshold(), 0) + "\n";
        ImageCanvas ic = this.imp.getWindow().getCanvas();
        double mag = ic.getMagnification();
        if (mag != 1.0) {
            s = s + "Magnification: " + mag + "\n";
        }
        if (cal.calibrated()) {
            s = s + " \n";
            int curveFit = cal.getFunction();
            s = s + "Calibration Function: ";
            s = curveFit == 21 ? s + "Uncalibrated OD\n" : s + CurveFitter.fList[curveFit] + "\n";
            double[] c2 = cal.getCoefficients();
            if (c2 != null) {
                s = s + "  a: " + IJ.d2s(c2[0], 6) + "\n";
                s = s + "  b: " + IJ.d2s(c2[1], 6) + "\n";
                if (c2.length >= 3) {
                    s = s + "  c: " + IJ.d2s(c2[2], 6) + "\n";
                }
                if (c2.length >= 4) {
                    s = s + "  c: " + IJ.d2s(c2[3], 6) + "\n";
                }
                if (c2.length >= 5) {
                    s = s + "  c: " + IJ.d2s(c2[4], 6) + "\n";
                }
            }
            s = s + "  Unit: \"" + cal.getValueUnit() + "\"\n";
        } else {
            s = s + "Uncalibrated\n";
        }
        Roi roi = this.imp.getRoi();
        if (roi == null) {
            if (cal.calibrated()) {
                s = s + " \n";
            }
            s = s + "No ROI\n";
        } else {
            s = s + " \n";
            switch (roi.getType()) {
                case 0: {
                    s = s + "Rectangular ROI\n";
                    break;
                }
                case 1: {
                    s = s + "Oval ROI\n";
                    break;
                }
                case 2: {
                    s = s + "Polygon ROI\n";
                    break;
                }
                case 3: {
                    s = s + "Freehand ROI\n";
                    break;
                }
                case 4: {
                    s = s + "Traced ROI\n";
                    break;
                }
                case 5: {
                    s = s + "Line Selection\n";
                    break;
                }
                case 6: {
                    s = s + "Polyline Selection\n";
                    break;
                }
                case 7: {
                    s = s + "Freehand line Selection\n";
                }
            }
            Rectangle r = roi.getBoundingRect();
            if (roi instanceof Line) {
                Line line = (Line)roi;
                s = s + "  X1: " + IJ.d2s((double)line.x1 * cal.pixelWidth) + "\n";
                s = s + "  Y1: " + IJ.d2s((double)this.yy(line.y1) * cal.pixelHeight) + "\n";
                s = s + "  X2: " + IJ.d2s((double)line.x2 * cal.pixelWidth) + "\n";
                s = s + "  Y2: " + IJ.d2s((double)this.yy(line.y2) * cal.pixelHeight) + "\n";
            } else if (cal.scaled()) {
                s = s + "  X: " + IJ.d2s((double)r.x * cal.pixelWidth) + " (" + r.x + ")\n";
                s = s + "  Y: " + IJ.d2s((double)this.yy(r.y) * cal.pixelHeight) + " (" + r.y + ")\n";
                s = s + "  Width: " + IJ.d2s((double)r.width * cal.pixelWidth) + " (" + r.width + ")\n";
                s = s + "  Height: " + IJ.d2s((double)r.height * cal.pixelHeight) + " (" + r.height + ")\n";
            } else {
                s = s + "  X: " + r.x + "\n";
                s = s + "  Y: " + this.yy(r.y) + "\n";
                s = s + "  Width: " + r.width + "\n";
                s = s + "  Height: " + r.height + "\n";
            }
        }
        return s;
    }

    int yy(int y) {
        return Analyzer.updateY(y, this.imp.getHeight());
    }

    void showInfo(String info, int width, int height) {
        new TextWindow("Info for " + this.imp.getTitle(), info, width, height);
    }
}

