/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.image.ColorModel;

public class Projector
implements PlugInFilter {
    static final int xAxis = 0;
    static final int yAxis = 1;
    static final int zAxis = 2;
    static final int nearestPoint = 0;
    static final int brightestPoint = 1;
    static final int meanValue = 2;
    static final int BIGPOWEROF2 = 8192;
    String[] axisList = new String[]{"X-Axis", "Y-Axis", "Z-Axis"};
    String[] methodList = new String[]{"Nearest Point", "Brightest Point", "Mean Value"};
    private static int axisOfRotation = 0;
    private static int projectionMethod = 0;
    private static double sliceInterval = 1.0;
    private static int initAngle = 0;
    private static int totalAngle = 360;
    private static int angleInc = 10;
    private static int opacity = 0;
    private static int depthCueSurf = 0;
    private static int depthCueInt = 50;
    private static boolean debugMode;
    private int transparencyLower = 1;
    private int transparencyUpper = 255;
    ImagePlus imp;
    ImageStack stack;
    ImageStack stack2;
    int width;
    int height;
    int imageWidth;
    int left;
    int right;
    int top;
    int bottom;
    byte[] projArray;
    byte[] opaArray;
    byte[] brightCueArray;
    short[] zBuffer;
    short[] cueZBuffer;
    short[] countBuffer;
    int[] sumBuffer;
    static /* synthetic */ Class class$ij$plugin$filter$Projector;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        IJ.register(class$ij$plugin$filter$Projector == null ? (class$ij$plugin$filter$Projector = Projector.class$("ij.plugin.filter.Projector")) : class$ij$plugin$filter$Projector);
        return 2177;
    }

    public void run(ImageProcessor ip) {
        if (ip.isInvertedLut() && !IJ.showMessageWithCancel("3D Project", "Stacks with inverter LUTs may not project correctly.\nTo create a standard LUT, invert the stack (Edit/Invert)\nand invert the LUT (Image/Lookup Tables/Invert LUT).")) {
            return;
        }
        if (this.showDialog()) {
            this.doProjections(this.imp);
        }
    }

    public boolean showDialog() {
        ImageProcessor ip = this.imp.getProcessor();
        double lower = ip.getMinThreshold();
        if (lower != -808080.0) {
            this.transparencyLower = (int)lower;
            this.transparencyUpper = (int)ip.getMaxThreshold();
        }
        Calibration cal = this.imp.getCalibration();
        GenericDialog gd = new GenericDialog("3D Projection");
        gd.addChoice("Projection Method:", this.methodList, this.methodList[projectionMethod]);
        gd.addChoice("Axis of Rotation:", this.axisList, this.axisList[axisOfRotation]);
        gd.addNumericField("Slice Interval (" + cal.getUnits() + "):", cal.pixelDepth, 1);
        gd.addNumericField("Initial Angle (0-359 degrees):", initAngle, 0);
        gd.addNumericField("Total Rotation (0-359 degrees):", totalAngle, 0);
        gd.addNumericField("Rotation Angle Increment:", angleInc, 0);
        gd.addNumericField("Lower Transparency Bound:", this.transparencyLower, 0);
        gd.addNumericField("Upper Transparency Bound:", this.transparencyUpper, 0);
        gd.addNumericField("Surface Opacity (0-100%):", opacity, 0);
        gd.addNumericField("Surface Depth-Cueing (0-100%):", 100 - depthCueSurf, 0);
        gd.addNumericField("Interior Depth-Cueing (0-100%):", 100 - depthCueInt, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        projectionMethod = gd.getNextChoiceIndex();
        axisOfRotation = gd.getNextChoiceIndex();
        cal.pixelDepth = gd.getNextNumber();
        if (cal.pixelWidth == 0.0) {
            cal.pixelWidth = 1.0;
        }
        sliceInterval = cal.pixelDepth / cal.pixelWidth;
        initAngle = (int)gd.getNextNumber();
        totalAngle = (int)gd.getNextNumber();
        angleInc = (int)gd.getNextNumber();
        this.transparencyLower = (int)gd.getNextNumber();
        this.transparencyUpper = (int)gd.getNextNumber();
        opacity = (int)gd.getNextNumber();
        depthCueSurf = 100 - (int)gd.getNextNumber();
        depthCueInt = 100 - (int)gd.getNextNumber();
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public void doProjections(ImagePlus imp) {
        block48: {
            block49: {
                block50: {
                    minProjSize = true;
                    this.stack = imp.getStack();
                    if (Projector.angleInc == 0 && Projector.totalAngle != 0) {
                        Projector.angleInc = 5;
                    }
                    angle = 0;
                    nProjections = 0;
                    if (Projector.angleInc != 0) ** GOTO lbl12
                    nProjections = 1;
                    break block50;
lbl-1000:
                    // 1 sources

                    {
                        ++nProjections;
                        angle += Projector.angleInc;
lbl12:
                        // 2 sources

                        ** while (angle <= Projector.totalAngle)
                    }
                }
                if (angle > 360) {
                    --nProjections;
                }
                if (nProjections <= 0) {
                    nProjections = 1;
                }
                ip = imp.getProcessor();
                r = ip.getRoi();
                this.left = r.x;
                this.top = r.y;
                this.right = r.x + r.width;
                this.bottom = r.y + r.height;
                nSlices = imp.getStackSize();
                this.imageWidth = imp.getWidth();
                this.width = this.right - this.left;
                this.height = this.bottom - this.top;
                xcenter = (this.left + this.right) / 2;
                ycenter = (this.top + this.bottom) / 2;
                zcenter = (int)((double)nSlices * Projector.sliceInterval / 2.0 + 0.5);
                projwidth = 0;
                projheight = 0;
                if (minProjSize && Projector.axisOfRotation != 2) {
                    switch (Projector.axisOfRotation) {
                        case 0: {
                            projheight = (int)(Math.sqrt((double)nSlices * Projector.sliceInterval * (double)nSlices * Projector.sliceInterval + (double)(this.height * this.height)) + 0.5);
                            projwidth = this.width;
                            break;
                        }
                        case 1: {
                            projwidth = (int)(Math.sqrt((double)nSlices * Projector.sliceInterval * (double)nSlices * Projector.sliceInterval + (double)(this.width * this.width)) + 0.5);
                            projheight = this.height;
                        }
                    }
                } else {
                    projwidth = (int)(Math.sqrt((double)nSlices * Projector.sliceInterval * (double)nSlices * Projector.sliceInterval + (double)(this.width * this.width)) + 0.5);
                    projheight = (int)(Math.sqrt((double)nSlices * Projector.sliceInterval * (double)nSlices * Projector.sliceInterval + (double)(this.height * this.height)) + 0.5);
                }
                if (projwidth % 1 == 1) {
                    ++projwidth;
                }
                projsize = projwidth * projheight;
                try {
                    this.allocateArrays(nProjections, projwidth, projheight);
                    break block48;
                }
                catch (OutOfMemoryError e) {
                    images = this.stack2.getImageArray();
                    if (images == null) break block49;
                    i = 0;
                    ** while (i < images.length)
                }
lbl-1000:
                // 1 sources

                {
                    images[i] = null;
                    ++i;
                    continue;
                }
            }
            this.stack2 = null;
            IJ.showMessage("Projector - Out of Memory", "To use less memory, use a rectanguar\nselection,  reduce \"Total Rotation\",\nand/or increase \"Angle Increment\".");
            return;
        }
        projections = new ImagePlus("Projections of " + imp.getShortTitle(), this.stack2);
        projections.show();
        win = imp.getWindow();
        if (win != null) {
            win.running = true;
        }
        theta = Projector.initAngle;
        n = 0;
        while (n < nProjections) {
            IJ.showStatus(n + "/" + nProjections);
            IJ.showProgress((double)n / (double)nProjections);
            thetarad = (double)theta * 3.141592653589793 / 180.0;
            costheta = (int)(8192.0 * Math.cos(thetarad) + 0.5);
            sintheta = (int)(8192.0 * Math.sin(thetarad) + 0.5);
            this.projArray = (byte[])this.stack2.getPixels(n + 1);
            if (this.projArray == null) break;
            if (Projector.projectionMethod == 0 || Projector.opacity > 0) {
                i = 0;
                while (i < projsize) {
                    this.zBuffer[i] = 32767;
                    ++i;
                }
            }
            if (Projector.opacity > 0 && Projector.projectionMethod != 0) {
                i = 0;
                while (i < projsize) {
                    this.opaArray[i] = 0;
                    ++i;
                }
            }
            if (Projector.projectionMethod == 1 && Projector.depthCueInt < 100) {
                i = 0;
                while (i < projsize) {
                    this.brightCueArray[i] = 0;
                    ++i;
                }
                i = 0;
                while (i < projsize) {
                    this.cueZBuffer[i] = 0;
                    ++i;
                }
            }
            if (Projector.projectionMethod == 2) {
                i = 0;
                while (i < projsize) {
                    this.sumBuffer[i] = 0;
                    ++i;
                }
                i = 0;
                while (i < projsize) {
                    this.countBuffer[i] = 0;
                    ++i;
                }
            }
            switch (Projector.axisOfRotation) {
                case 0: {
                    this.doOneProjectionX(nSlices, ycenter, zcenter, projwidth, projheight, costheta, sintheta);
                    break;
                }
                case 1: {
                    this.doOneProjectionY(nSlices, xcenter, zcenter, projwidth, projheight, costheta, sintheta);
                    break;
                }
                case 2: {
                    this.doOneProjectionZ(nSlices, xcenter, ycenter, zcenter, projwidth, projheight, costheta, sintheta);
                }
            }
            if (Projector.projectionMethod == 2) {
                i = 0;
                while (i < projsize) {
                    count = this.countBuffer[i];
                    if (count != 0) {
                        this.projArray[i] = (byte)(this.sumBuffer[i] / count);
                    }
                    ++i;
                }
            }
            if (Projector.opacity > 0 && Projector.projectionMethod != 0) {
                i = 0;
                while (i < projsize) {
                    this.projArray[i] = (byte)((Projector.opacity * (this.opaArray[i] & 255) + (100 - Projector.opacity) * (this.projArray[i] & 255)) / 100);
                    ++i;
                }
            }
            if (Projector.axisOfRotation == 2) {
                i = projwidth;
                while (i < projsize - projwidth) {
                    curval = this.projArray[i] & 255;
                    prevval = this.projArray[i - 1] & 255;
                    nextval = this.projArray[i + 1] & 255;
                    aboveval = this.projArray[i - projwidth] & 255;
                    belowval = this.projArray[i + projwidth] & 255;
                    if (curval == 0 && prevval != 0 && nextval != 0 && aboveval != 0 && belowval != 0) {
                        this.projArray[i] = (byte)((prevval + nextval + aboveval + belowval) / 4);
                    }
                    ++i;
                }
            }
            theta = (theta + Projector.angleInc) % 360;
            if (projections.getWindow() == null) break;
            projections.setSlice(n + 1);
            if (win != null && !win.running) break;
            ++n;
        }
        IJ.showProgress(1.0);
        if (Projector.debugMode) {
            if (this.projArray != null) {
                new ImagePlus("projArray", new ByteProcessor(projwidth, projheight, this.projArray, null)).show();
            }
            if (this.opaArray != null) {
                new ImagePlus("opaArray", new ByteProcessor(projwidth, projheight, this.opaArray, null)).show();
            }
            if (this.brightCueArray != null) {
                new ImagePlus("brightCueArray", new ByteProcessor(projwidth, projheight, this.brightCueArray, null)).show();
            }
            if (this.zBuffer != null) {
                new ImagePlus("zBuffer", new ShortProcessor(projwidth, projheight, this.zBuffer, null)).show();
            }
            if (this.cueZBuffer != null) {
                new ImagePlus("cueZBuffer", new ShortProcessor(projwidth, projheight, this.cueZBuffer, null)).show();
            }
            if (this.countBuffer != null) {
                new ImagePlus("countBuffer", new ShortProcessor(projwidth, projheight, this.countBuffer, null)).show();
            }
            if (this.sumBuffer != null) {
                tmp = new float[projwidth * projheight];
                i = 0;
                while (i < projwidth * projheight) {
                    tmp[i] = this.sumBuffer[i];
                    ++i;
                }
                new ImagePlus("sumBuffer", new FloatProcessor(projwidth, projheight, tmp, null)).show();
            }
        }
    }

    void allocateArrays(int nProjections, int projwidth, int projheight) {
        int projsize = projwidth * projheight;
        ColorModel cm = this.imp.getProcessor().getColorModel();
        this.stack2 = new ImageStack(projwidth, projheight, cm);
        this.projArray = new byte[projsize];
        int i = 0;
        while (i < nProjections) {
            this.stack2.addSlice(null, new byte[projsize]);
            ++i;
        }
        if (projectionMethod == 0 || opacity > 0) {
            this.zBuffer = new short[projsize];
        }
        if (opacity > 0 && projectionMethod != 0) {
            this.opaArray = new byte[projsize];
        }
        if (projectionMethod == 1 && depthCueInt < 100) {
            this.brightCueArray = new byte[projsize];
            this.cueZBuffer = new short[projsize];
        }
        if (projectionMethod == 2) {
            this.sumBuffer = new int[projsize];
            this.countBuffer = new short[projsize];
        }
    }

    void doOneProjectionX(int nSlices, int ycenter, int zcenter, int projwidth, int projheight, int costheta, int sintheta) {
        int projsize = projwidth * projheight;
        int zmax = zcenter + projheight / 2;
        int zmin = zcenter - projheight / 2;
        int zmaxminuszmintimes100 = 100 * (zmax - zmin);
        int c100minusDepthCueInt = 100 - depthCueInt;
        int c100minusDepthCueSurf = 100 - depthCueSurf;
        boolean DepthCueIntLessThan100 = depthCueInt < 100;
        boolean DepthCueSurfLessThan100 = depthCueSurf < 100;
        boolean OpacityOrNearestPt = projectionMethod == 0 || opacity > 0;
        boolean OpacityAndNotNearestPt = opacity > 0 && projectionMethod != 0;
        boolean MeanVal = projectionMethod == 2;
        boolean BrightestPt = projectionMethod == 1;
        int ycosthetainit = (this.top - ycenter - 1) * costheta;
        int ysinthetainit = (this.top - ycenter - 1) * sintheta;
        int offsetinit = (projheight - this.bottom + this.top) / 2 * projwidth + (projwidth - this.right + this.left) / 2 - 1;
        int k = 1;
        while (k <= nSlices) {
            byte[] pixels = (byte[])this.stack.getPixels(k);
            int z = (int)((double)(k - 1) * sliceInterval + 0.5) - zcenter;
            int zcostheta = z * costheta;
            int zsintheta = z * sintheta;
            int ycostheta = ycosthetainit;
            int ysintheta = ysinthetainit;
            int j = this.top;
            while (j < this.bottom) {
                int ynew = ((ycostheta += costheta) - zsintheta) / 8192 + ycenter - this.top;
                int znew = ((ysintheta += sintheta) + zcostheta) / 8192 + zcenter;
                int offset = offsetinit + ynew * projwidth;
                int lineIndex = j * this.imageWidth;
                int i = this.left;
                while (i < this.right) {
                    int thispixel = pixels[lineIndex + i] & 0xFF;
                    if (++offset >= projsize || offset < 0) {
                        offset = 0;
                    }
                    if (thispixel <= this.transparencyUpper && thispixel >= this.transparencyLower) {
                        if (OpacityOrNearestPt && znew < this.zBuffer[offset]) {
                            this.zBuffer[offset] = (short)znew;
                            if (OpacityAndNotNearestPt) {
                                this.opaArray[offset] = DepthCueSurfLessThan100 ? (byte)(depthCueSurf * thispixel / 100 + c100minusDepthCueSurf * thispixel * (zmax - znew) / zmaxminuszmintimes100) : (byte)thispixel;
                            } else {
                                this.projArray[offset] = DepthCueSurfLessThan100 ? (byte)(depthCueSurf * thispixel / 100 + c100minusDepthCueSurf * thispixel * (zmax - znew) / zmaxminuszmintimes100) : (byte)thispixel;
                            }
                        }
                        if (MeanVal) {
                            int n = offset;
                            this.sumBuffer[n] = this.sumBuffer[n] + thispixel;
                            int n2 = offset;
                            this.countBuffer[n2] = (short)(this.countBuffer[n2] + 1);
                        } else if (BrightestPt) {
                            if (DepthCueIntLessThan100) {
                                if (thispixel > (this.brightCueArray[offset] & 0xFF) || thispixel == (this.brightCueArray[offset] & 0xFF) && znew > this.cueZBuffer[offset]) {
                                    this.brightCueArray[offset] = (byte)thispixel;
                                    this.cueZBuffer[offset] = (short)znew;
                                    this.projArray[offset] = (byte)(255 - (depthCueInt * (255 - thispixel) / 100 + c100minusDepthCueInt * (255 - thispixel) * (zmax - znew) / zmaxminuszmintimes100));
                                }
                            } else if (thispixel > (this.projArray[offset] & 0xFF)) {
                                this.projArray[offset] = (byte)thispixel;
                            }
                        }
                    }
                    ++i;
                }
                ++j;
            }
            ++k;
        }
    }

    void doOneProjectionY(int nSlices, int xcenter, int zcenter, int projwidth, int projheight, int costheta, int sintheta) {
        int projsize = projwidth * projheight;
        int zmax = zcenter + projwidth / 2;
        int zmin = zcenter - projwidth / 2;
        int zmaxminuszmintimes100 = 100 * (zmax - zmin);
        int c100minusDepthCueInt = 100 - depthCueInt;
        int c100minusDepthCueSurf = 100 - depthCueSurf;
        boolean DepthCueIntLessThan100 = depthCueInt < 100;
        boolean DepthCueSurfLessThan100 = depthCueSurf < 100;
        boolean OpacityOrNearestPt = projectionMethod == 0 || opacity > 0;
        boolean OpacityAndNotNearestPt = opacity > 0 && projectionMethod != 0;
        boolean MeanVal = projectionMethod == 2;
        boolean BrightestPt = projectionMethod == 1;
        int xcosthetainit = (this.left - xcenter - 1) * costheta;
        int xsinthetainit = (this.left - xcenter - 1) * sintheta;
        int k = 1;
        while (k <= nSlices) {
            byte[] pixels = (byte[])this.stack.getPixels(k);
            int z = (int)((double)(k - 1) * sliceInterval + 0.5) - zcenter;
            int zcostheta = z * costheta;
            int zsintheta = z * sintheta;
            int offsetinit = (projheight - this.bottom + this.top) / 2 * projwidth + (projwidth - this.right + this.left) / 2 - projwidth;
            int j = this.top;
            while (j < this.bottom) {
                int xcostheta = xcosthetainit;
                int xsintheta = xsinthetainit;
                offsetinit += projwidth;
                int lineOffset = j * this.imageWidth;
                int i = this.left;
                while (i < this.right) {
                    int thispixel = pixels[lineOffset + i] & 0xFF;
                    xcostheta += costheta;
                    xsintheta += sintheta;
                    if (thispixel <= this.transparencyUpper && thispixel >= this.transparencyLower) {
                        int xnew = (xcostheta + zsintheta) / 8192 + xcenter - this.left;
                        int znew = (zcostheta - xsintheta) / 8192 + zcenter;
                        int offset = offsetinit + xnew;
                        if (offset >= projsize || offset < 0) {
                            offset = 0;
                        }
                        if (OpacityOrNearestPt && znew < this.zBuffer[offset]) {
                            this.zBuffer[offset] = (short)znew;
                            if (OpacityAndNotNearestPt) {
                                this.opaArray[offset] = DepthCueSurfLessThan100 ? (byte)(depthCueSurf * thispixel / 100 + c100minusDepthCueSurf * thispixel * (zmax - znew) / zmaxminuszmintimes100) : (byte)thispixel;
                            } else {
                                this.projArray[offset] = DepthCueSurfLessThan100 ? (byte)(depthCueSurf * thispixel / 100 + c100minusDepthCueSurf * thispixel * (zmax - znew) / zmaxminuszmintimes100) : (byte)thispixel;
                            }
                        }
                        if (MeanVal) {
                            int n = offset;
                            this.sumBuffer[n] = this.sumBuffer[n] + thispixel;
                            int n2 = offset;
                            this.countBuffer[n2] = (short)(this.countBuffer[n2] + 1);
                        } else if (BrightestPt) {
                            if (DepthCueIntLessThan100) {
                                if (thispixel > (this.brightCueArray[offset] & 0xFF) || thispixel == (this.brightCueArray[offset] & 0xFF) && znew > this.cueZBuffer[offset]) {
                                    this.brightCueArray[offset] = (byte)thispixel;
                                    this.cueZBuffer[offset] = (short)znew;
                                    this.projArray[offset] = (byte)(depthCueInt * thispixel / 100 + c100minusDepthCueInt * thispixel * (zmax - znew) / zmaxminuszmintimes100);
                                }
                            } else if (thispixel > (this.projArray[offset] & 0xFF)) {
                                this.projArray[offset] = (byte)thispixel;
                            }
                        }
                    }
                    ++i;
                }
                ++j;
            }
            ++k;
        }
    }

    void doOneProjectionZ(int nSlices, int xcenter, int ycenter, int zcenter, int projwidth, int projheight, int costheta, int sintheta) {
        int projsize = projwidth * projheight;
        int zmax = (int)((double)(nSlices - 1) * sliceInterval + 0.5) - zcenter;
        int zmin = -zcenter;
        int zmaxminuszmintimes100 = 100 * (zmax - zmin);
        int c100minusDepthCueInt = 100 - depthCueInt;
        int c100minusDepthCueSurf = 100 - depthCueSurf;
        boolean DepthCueIntLessThan100 = depthCueInt < 100;
        boolean DepthCueSurfLessThan100 = depthCueSurf < 100;
        boolean OpacityOrNearestPt = projectionMethod == 0 || opacity > 0;
        boolean OpacityAndNotNearestPt = opacity > 0 && projectionMethod != 0;
        boolean MeanVal = projectionMethod == 2;
        boolean BrightestPt = projectionMethod == 1;
        int xcosthetainit = (this.left - xcenter - 1) * costheta;
        int xsinthetainit = (this.left - xcenter - 1) * sintheta;
        int ycosthetainit = (this.top - ycenter - 1) * costheta;
        int ysinthetainit = (this.top - ycenter - 1) * sintheta;
        int offsetinit = (projheight - this.bottom + this.top) / 2 * projwidth + (projwidth - this.right + this.left) / 2 - 1;
        int k = 1;
        while (k <= nSlices) {
            byte[] pixels = (byte[])this.stack.getPixels(k);
            int z = (int)((double)(k - 1) * sliceInterval + 0.5) - zcenter;
            int ycostheta = ycosthetainit;
            int ysintheta = ysinthetainit;
            int j = this.top;
            while (j < this.bottom) {
                ycostheta += costheta;
                ysintheta += sintheta;
                int xcostheta = xcosthetainit;
                int xsintheta = xsinthetainit;
                int lineIndex = j * this.imageWidth;
                int i = this.left;
                while (i < this.right) {
                    int thispixel = pixels[lineIndex + i] & 0xFF;
                    xcostheta += costheta;
                    xsintheta += sintheta;
                    if (thispixel <= this.transparencyUpper && thispixel >= this.transparencyLower) {
                        int ynew = (xsintheta + ycostheta) / 8192 + ycenter - this.top;
                        int xnew = (xcostheta - ysintheta) / 8192 + xcenter - this.left;
                        int offset = offsetinit + ynew * projwidth + xnew;
                        if (offset >= projsize || offset < 0) {
                            offset = 0;
                        }
                        if (OpacityOrNearestPt && z < this.zBuffer[offset]) {
                            this.zBuffer[offset] = (short)z;
                            if (OpacityAndNotNearestPt) {
                                this.opaArray[offset] = DepthCueSurfLessThan100 ? (byte)(depthCueSurf * thispixel / 100 + c100minusDepthCueSurf * thispixel * (zmax - z) / zmaxminuszmintimes100) : (byte)thispixel;
                            } else if (DepthCueSurfLessThan100) {
                                int v = depthCueSurf * thispixel / 100 + c100minusDepthCueSurf * thispixel * (zmax - z) / zmaxminuszmintimes100;
                                this.projArray[offset] = (byte)v;
                            } else {
                                this.projArray[offset] = (byte)thispixel;
                            }
                        }
                        if (MeanVal) {
                            int n = offset;
                            this.sumBuffer[n] = this.sumBuffer[n] + thispixel;
                            int n2 = offset;
                            this.countBuffer[n2] = (short)(this.countBuffer[n2] + 1);
                        } else if (BrightestPt) {
                            if (DepthCueIntLessThan100) {
                                if (thispixel > (this.brightCueArray[offset] & 0xFF) || thispixel == (this.brightCueArray[offset] & 0xFF) && z > this.cueZBuffer[offset]) {
                                    this.brightCueArray[offset] = (byte)thispixel;
                                    this.cueZBuffer[offset] = (short)z;
                                    this.projArray[offset] = (byte)(depthCueInt * thispixel / 100 + c100minusDepthCueInt * thispixel * (zmax - z) / zmaxminuszmintimes100);
                                }
                            } else if (thispixel > (this.projArray[offset] & 0xFF)) {
                                this.projArray[offset] = (byte)thispixel;
                            }
                        }
                    }
                    ++i;
                }
                ++j;
            }
            ++k;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

