/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Rectangle;

public class RankFilters
implements PlugInFilter {
    public static final int MEDIAN = 0;
    public static final int MEAN = 1;
    public static final int MIN = 2;
    public static final int MAX = 3;
    static final int BYTE = 0;
    static final int SHORT = 1;
    static final int FLOAT = 2;
    static final int RGB = 3;
    ImagePlus imp;
    int filterType = 0;
    String title;
    int kw;
    int kh;
    int slice;
    boolean canceled;
    ImageWindow win;
    private static final String[] typeStrings = new String[]{"Median", "Mean", "Minimum", "Maximum"};
    boolean isLineRoi;
    static double radius = 2.0;
    static /* synthetic */ Class class$ij$plugin$filter$RankFilters;

    public int setup(String arg, ImagePlus imp) {
        IJ.register(class$ij$plugin$filter$RankFilters == null ? (class$ij$plugin$filter$RankFilters = RankFilters.class$("ij.plugin.filter.RankFilters")) : class$ij$plugin$filter$RankFilters);
        this.imp = imp;
        if (arg.equals("min")) {
            this.filterType = 2;
        } else if (arg.equals("max")) {
            this.filterType = 3;
        } else if (arg.equals("mean")) {
            this.filterType = 1;
        }
        this.slice = 0;
        this.canceled = false;
        if (imp != null) {
            this.win = imp.getWindow();
            this.win.running = true;
            Roi roi = imp.getRoi();
            this.isLineRoi = roi != null && roi.getType() >= 5;
        }
        this.title = typeStrings[this.filterType];
        IJ.showStatus(this.title + ", radius=" + radius + " (esc to abort)");
        if (imp != null && !this.showDialog()) {
            return 4096;
        }
        return IJ.setupDialog(imp, 31);
    }

    public void run(ImageProcessor ip) {
        if (this.canceled) {
            return;
        }
        ++this.slice;
        if (!this.win.running) {
            this.canceled = true;
            IJ.beep();
            return;
        }
        if (this.isLineRoi) {
            ip.setRoi(null);
        }
        this.rank(ip, radius, this.filterType);
        if (this.slice > 1) {
            IJ.showStatus(this.title + ": " + this.slice + "/" + this.imp.getStackSize());
        }
        if (this.slice == this.imp.getStackSize()) {
            ip.resetMinAndMax();
        }
    }

    void showMasks() {
        int w = 150;
        int h = 150;
        ImageStack stack = new ImageStack(w, h);
        double r = 0.5;
        while (r < 50.0) {
            int d2 = (int)(r + 0.5) * 2 + 1;
            int[] mask = this.createCircularMask(d2, r);
            FloatProcessor ip2 = new FloatProcessor(w, h, new int[w * h]);
            ip2.insert(new FloatProcessor(d2, d2, mask), w / 2 - d2 / 2, h / 2 - d2 / 2);
            stack.addSlice("radius=" + r + ", size=" + d2, ip2);
            r += 0.5;
        }
        new ImagePlus("Masks", stack).show();
    }

    int getType(ImageProcessor ip) {
        int type = ip instanceof ByteProcessor ? 0 : (ip instanceof ShortProcessor ? 1 : (ip instanceof FloatProcessor ? 2 : 3));
        return type;
    }

    public void convertBack(ImageProcessor ip2, ImageProcessor ip, int type) {
        switch (type) {
            case 0: {
                ip2 = ip2.convertToByte(false);
                byte[] pixels = (byte[])ip.getPixels();
                byte[] pixels2 = (byte[])ip2.getPixels();
                System.arraycopy(pixels2, 0, pixels, 0, pixels.length);
                break;
            }
            case 1: {
                ip2 = ip2.convertToShort(false);
                short[] pixels16 = (short[])ip.getPixels();
                short[] pixels16b = (short[])ip2.getPixels();
                System.arraycopy(pixels16b, 0, pixels16, 0, pixels16.length);
                break;
            }
        }
    }

    boolean showDialog() {
        GenericDialog gd = new GenericDialog(this.title + "...");
        gd.addNumericField("Radius (pixels):", radius, 1);
        gd.addCheckbox("Show Circular Masks", false);
        gd.showDialog();
        if (gd.wasCanceled()) {
            this.canceled = true;
            return false;
        }
        radius = gd.getNextNumber();
        boolean showMasks = gd.getNextBoolean();
        if (showMasks) {
            this.showMasks();
            return false;
        }
        if (radius < 0.5) {
            radius = 0.5;
        }
        this.imp.startTiming();
        return true;
    }

    public void rank(ImageProcessor ip, double radius, int rankType) {
        int type = this.getType(ip);
        if (type == 3) {
            this.rankRGB(ip, radius, rankType);
            return;
        }
        ip.setCalibrationTable(null);
        ImageProcessor ip2 = ip.convertToFloat();
        ip2.setRoi(ip.getRoi());
        ip2.setMask(ip.getMask());
        this.rankFloat(ip2, radius, rankType);
        this.convertBack(ip2, ip, type);
    }

    public void rankRGB(ImageProcessor ip, double radius, int rankType) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        Rectangle roi = ip.getRoi();
        int[] mask = ip.getMask();
        int size = width * height;
        if (this.slice == 1) {
            IJ.showStatus(this.title + " (red)");
        }
        byte[] r = new byte[size];
        byte[] g = new byte[size];
        byte[] b2 = new byte[size];
        ((ColorProcessor)ip).getRGB(r, g, b2);
        ByteProcessor rip = new ByteProcessor(width, height, r, null);
        ByteProcessor gip = new ByteProcessor(width, height, g, null);
        ByteProcessor bip = new ByteProcessor(width, height, b2, null);
        ImageProcessor ip2 = rip.convertToFloat();
        ip2.setRoi(roi);
        ip2.setMask(mask);
        this.rankFloat(ip2, radius, rankType);
        if (this.canceled) {
            return;
        }
        ImageProcessor r2 = ip2.convertToByte(false);
        if (this.slice == 1) {
            IJ.showStatus(this.title + " (green)");
        }
        ip2 = gip.convertToFloat();
        ip2.setRoi(roi);
        ip2.setMask(mask);
        this.rankFloat(ip2, radius, rankType);
        if (this.canceled) {
            return;
        }
        ImageProcessor g2 = ip2.convertToByte(false);
        if (this.slice == 1) {
            IJ.showStatus(this.title + " (blue)");
        }
        ip2 = bip.convertToFloat();
        ip2.setRoi(roi);
        ip2.setMask(mask);
        this.rankFloat(ip2, radius, rankType);
        if (this.canceled) {
            return;
        }
        ImageProcessor b22 = ip2.convertToByte(false);
        ((ColorProcessor)ip).setRGB((byte[])r2.getPixels(), (byte[])g2.getPixels(), (byte[])b22.getPixels());
    }

    public void rankFloat(ImageProcessor ip, double radius, int rankType) {
        int kw;
        int width = ip.getWidth();
        int height = ip.getHeight();
        Rectangle r = ip.getRoi();
        boolean isRoi = r.width != width || r.height != height;
        boolean nonRectRoi = isRoi && ip.getMask() != null;
        int x1 = 0;
        int y1 = 0;
        int x2 = width - 1;
        int y2 = height - 1;
        if (isRoi) {
            x1 = r.x;
            y1 = r.y;
            x2 = x1 + r.width - 1;
            y2 = y1 + r.height - 1;
            if (nonRectRoi) {
                ip.snapshot();
            }
        }
        int kh = kw = (int)(radius + 0.5) * 2 + 1;
        int[] mask = this.createCircularMask(kw, radius);
        int maskSize = 0;
        int i = 0;
        while (i < kw * kw) {
            if (mask[i] != 0) {
                ++maskSize;
            }
            ++i;
        }
        float[] values = new float[maskSize];
        int uc = kw / 2;
        int vc = kh / 2;
        float[] pixels = (float[])ip.getPixels();
        float[] pixels2 = (float[])ip.getPixelsCopy();
        int progress = Math.max((y2 - y1) / 50, 1);
        int xedge = width - uc;
        int yedge = height - vc;
        int y = y1;
        while (y <= y2) {
            if (y % progress == 0) {
                IJ.showProgress((double)y / (double)height);
                boolean bl = this.canceled = this.win != null && !this.win.running;
                if (this.canceled) break;
            }
            int x = x1;
            while (x <= x2) {
                double sum = 0.0;
                int i2 = 0;
                int count = 0;
                boolean edgePixel = y < vc || y >= yedge || x < uc || x >= xedge;
                int v = -vc;
                while (v <= vc) {
                    int offset = x + (y + v) * width;
                    int u = -uc;
                    while (u <= uc) {
                        if (mask[i2++] != 0) {
                            values[count] = edgePixel ? this.getPixel(x + u, y + v, pixels2, width, height) : pixels2[offset + u];
                            ++count;
                        }
                        ++u;
                    }
                    ++v;
                }
                pixels[x + y * width] = rankType == 0 ? this.findMedian(values) : (rankType == 1 ? this.findMean(values) : (rankType == 2 ? this.findMin(values) : this.findMax(values)));
                ++x;
            }
            ++y;
        }
        if (nonRectRoi) {
            ip.reset(ip.getMask());
        }
        IJ.showProgress(1.0);
        if (this.canceled) {
            ip.insert(new FloatProcessor(width, height, pixels2, null), 0, 0);
            IJ.beep();
        }
    }

    private float getPixel(int x, int y, float[] pixels, int width, int height) {
        if (x <= 0) {
            x = 0;
        }
        if (x >= width) {
            x = width - 1;
        }
        if (y <= 0) {
            y = 0;
        }
        if (y >= height) {
            y = height - 1;
        }
        return pixels[x + y * width];
    }

    int[] createCircularMask(int width, double radius) {
        int[] mask = new int[width * width];
        int r = width / 2;
        int r2 = (int)(radius * radius) + 1;
        int x = -r;
        while (x <= r) {
            int y = -r;
            while (y <= r) {
                if (x * x + y * y <= r2) {
                    mask[r + x + (r + y) * width] = 1;
                }
                ++y;
            }
            ++x;
        }
        return mask;
    }

    private final float findMedian(float[] a2) {
        int nValues = a2.length;
        int nv1b2 = (nValues - 1) / 2;
        int l = 0;
        int m = nValues - 1;
        float med = a2[nv1b2];
        while (l < m) {
            int i = l;
            int j = m;
            while (true) {
                if (a2[i] < med) {
                    ++i;
                    continue;
                }
                while (med < a2[j]) {
                    --j;
                }
                float dum = a2[j];
                a2[j] = a2[i];
                a2[i] = dum;
                if (--j < nv1b2 || ++i > nv1b2) break;
            }
            if (j < nv1b2) {
                l = i;
            }
            if (nv1b2 < i) {
                m = j;
            }
            med = a2[nv1b2];
        }
        return med;
    }

    private final float findMin(float[] values) {
        float min = values[0];
        int i = 1;
        while (i < values.length) {
            if (values[i] < min) {
                min = values[i];
            }
            ++i;
        }
        return min;
    }

    private final float findMax(float[] values) {
        float max = values[0];
        int i = 1;
        while (i < values.length) {
            if (values[i] > max) {
                max = values[i];
            }
            ++i;
        }
        return max;
    }

    private final float findMean(float[] values) {
        float sum = values[0];
        int i = 1;
        while (i < values.length) {
            sum += values[i];
            ++i;
        }
        return sum / (float)values.length;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

