/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.io.SaveDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class XYCoordinates
implements PlugInFilter {
    ImagePlus imp;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 31;
    }

    public void run(ImageProcessor ip) {
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        float background = ip.getPixelValue(0, 0);
        this.imp.killRoi();
        boolean okay = IJ.showMessageWithCancel("XY_Coordinates", "This plugin writes to a text file the XY coordinates and\npixel value of all non-background pixels. Backround\nis assumed to be the value of the pixel in the\nupper left corner of the image.\n \n    Width: " + width + "\n" + "    Height: " + height + "\n" + "    Background value: " + background + "\n");
        if (!okay) {
            return;
        }
        SaveDialog sd = new SaveDialog("Save Coordinates as Text...", this.imp.getTitle(), ".txt");
        String name = sd.getFileName();
        if (name == null) {
            return;
        }
        String directory = sd.getDirectory();
        PrintWriter pw = null;
        try {
            FileOutputStream fos = new FileOutputStream(directory + name);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            pw = new PrintWriter(bos);
        }
        catch (IOException e2) {
            IJ.write("" + e2);
            return;
        }
        IJ.showStatus("Saving coordinates...");
        int count = 0;
        String ls = System.getProperty("line.separator");
        int type = this.imp.getType();
        int y = height - 1;
        while (y >= 0) {
            int x = 0;
            while (x < width) {
                float v = ip.getPixelValue(x, y);
                if (v != background) {
                    if (type == 2) {
                        pw.print(x + " " + (height - 1 - y) + " " + v + ls);
                    } else if (type == 4) {
                        int c2 = ip.getPixel(x, y);
                        int r = (c2 & 0xFF0000) >> 16;
                        int g = (c2 & 0xFF00) >> 8;
                        int b2 = c2 & 0xFF;
                        pw.print(x + " " + (height - 1 - y) + " " + r + " " + g + " " + b2 + ls);
                    } else {
                        pw.print(x + " " + (height - 1 - y) + " " + (int)v + ls);
                    }
                    ++count;
                }
                ++x;
            }
            if (y % 10 == 0) {
                IJ.showProgress((double)(height - y) / (double)height);
            }
            --y;
        }
        IJ.showProgress(1.0);
        pw.close();
        IJ.write(this.imp.getTitle() + ": " + count + " pixels (" + IJ.d2s((double)count * 100.0 / (double)(width * height)) + "%)\n");
    }
}

