/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class ByteStatistics
extends ImageStatistics {
    public ByteStatistics(ImageProcessor ip) {
        this(ip, 27, null);
    }

    /*
     * Unable to fully structure code
     */
    public ByteStatistics(ImageProcessor ip, int mOptions, Calibration cal) {
        super();
        bp = (ByteProcessor)ip;
        this.histogram = bp.getHistogram();
        this.setup(ip, cal);
        minT = ip.getMinThreshold();
        if ((mOptions & 256) == 0) ** GOTO lbl-1000
        if (minT == -808080.0) lbl-1000:
        // 2 sources

        {
            minThreshold = 0;
            maxThreshold = 255;
        } else {
            minThreshold = (int)minT;
            maxThreshold = (int)ip.getMaxThreshold();
        }
        v0 = cTable = cal != null ? cal.getCTable() : null;
        if (cTable != null) {
            this.getCalibratedStatistics(minThreshold, maxThreshold, cTable);
        } else {
            this.getRawStatistics(minThreshold, maxThreshold);
        }
        if ((mOptions & 16) != 0) {
            if (cTable != null) {
                this.getCalibratedMinAndMax(minThreshold, maxThreshold, cTable);
            } else {
                this.getRawMinAndMax(minThreshold, maxThreshold);
            }
        }
        if ((mOptions & 2048) != 0) {
            this.fitEllipse(ip);
        } else if ((mOptions & 32) != 0) {
            this.getCentroid(ip, minThreshold, maxThreshold);
        }
        if ((mOptions & 64) != 0) {
            this.getCenterOfMass(ip, minThreshold, maxThreshold, cTable);
        }
    }

    void getCalibratedStatistics(int minThreshold, int maxThreshold, float[] cTable) {
        double sum = 0.0;
        double sum2 = 0.0;
        int isum = 0;
        int i = minThreshold;
        while (i <= maxThreshold) {
            int count = this.histogram[i];
            this.pixelCount += count;
            double value = cTable[i];
            sum += value * (double)count;
            isum += i * count;
            sum2 += value * value * (double)count;
            if (count > this.maxCount) {
                this.maxCount = count;
                this.mode = i;
            }
            ++i;
        }
        this.area = (double)this.pixelCount * this.pw * this.ph;
        this.mean = sum / (double)this.pixelCount;
        this.umean = (double)isum / (double)this.pixelCount;
        this.dmode = cTable[this.mode];
        this.calculateStdDev(this.pixelCount, sum, sum2);
        this.histMin = 0.0;
        this.histMax = 255.0;
    }

    void getCentroid(ImageProcessor ip, int minThreshold, int maxThreshold) {
        byte[] pixels = (byte[])ip.getPixels();
        int[] mask = ip.getMask();
        boolean limit = minThreshold > 0 || maxThreshold < 255;
        int count = 0;
        int xsum = 0;
        int ysum = 0;
        int y = this.ry;
        int my = 0;
        while (y < this.ry + this.rh) {
            int i = y * this.width + this.rx;
            int mi = my * this.rw;
            int x = this.rx;
            while (x < this.rx + this.rw) {
                block9: {
                    block8: {
                        if (mask == null) break block8;
                        int n = mi++;
                        if (mask[n] != -16777216) break block9;
                    }
                    if (limit) {
                        int v = pixels[i] & 0xFF;
                        if (v >= minThreshold && v <= maxThreshold) {
                            ++count;
                            xsum += x;
                            ysum += y;
                        }
                    } else {
                        ++count;
                        xsum += x;
                        ysum += y;
                    }
                }
                ++i;
                ++x;
            }
            ++y;
            ++my;
        }
        this.xCentroid = ((double)xsum / (double)count + 0.5) * this.pw;
        this.yCentroid = ((double)ysum / (double)count + 0.5) * this.ph;
    }

    void getCenterOfMass(ImageProcessor ip, int minThreshold, int maxThreshold, float[] cTable) {
        byte[] pixels = (byte[])ip.getPixels();
        int[] mask = ip.getMask();
        double count = 0.0;
        double xsum = 0.0;
        double ysum = 0.0;
        int y = this.ry;
        int my = 0;
        while (y < this.ry + this.rh) {
            int i = y * this.width + this.rx;
            int mi = my * this.rw;
            int x = this.rx;
            while (x < this.rx + this.rw) {
                block7: {
                    int v;
                    block6: {
                        if (mask == null) break block6;
                        int n = mi++;
                        if (mask[n] != -16777216) break block7;
                    }
                    if ((v = pixels[i] & 0xFF) >= minThreshold && v <= maxThreshold) {
                        double dv = (double)(cTable != null ? cTable[v] : (float)v) + Double.MIN_VALUE;
                        count += dv;
                        xsum += (double)x * dv;
                        ysum += (double)y * dv;
                    }
                }
                ++i;
                ++x;
            }
            ++y;
            ++my;
        }
        this.xCenterOfMass = (xsum / count + 0.5) * this.pw;
        this.yCenterOfMass = (ysum / count + 0.5) * this.ph;
    }

    void getCalibratedMinAndMax(int minThreshold, int maxThreshold, float[] cTable) {
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
        double v = 0.0;
        int i = minThreshold;
        while (i <= maxThreshold) {
            if (this.histogram[i] > 0) {
                v = cTable[i];
                if (v < this.min) {
                    this.min = v;
                }
                if (v > this.max) {
                    this.max = v;
                }
            }
            ++i;
        }
    }
}

