/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.Cube;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.IndexColorModel;

public class MedianCut {
    static final int MAXCOLORS = 256;
    static final int HSIZE = 32768;
    private int[] hist;
    private int[] histPtr;
    private Cube[] list;
    private int[] pixels32;
    private int width;
    private int height;
    private IndexColorModel cm;

    public MedianCut(int[] pixels, int width, int height) {
        this.pixels32 = pixels;
        this.width = width;
        this.height = height;
        IJ.showProgress(0.3);
        IJ.showStatus("Building 32x32x32 RGB histogram");
        this.hist = new int[32768];
        int i = 0;
        while (i < width * height) {
            int color16;
            int n = color16 = this.rgb(this.pixels32[i]);
            this.hist[n] = this.hist[n] + 1;
            ++i;
        }
    }

    public MedianCut(ColorProcessor ip) {
        this((int[])ip.getPixels(), ip.getWidth(), ip.getHeight());
    }

    int getColorCount() {
        int count = 0;
        int i = 0;
        while (i < 32768) {
            if (this.hist[i] > 0) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    Color getModalColor() {
        int max = 0;
        int c2 = 0;
        int i = 0;
        while (i < 32768) {
            if (this.hist[i] > max) {
                max = this.hist[i];
                c2 = i;
            }
            ++i;
        }
        return new Color(this.red(c2), this.green(c2), this.blue(c2));
    }

    private final int rgb(int c2) {
        int r = (c2 & 0xF80000) >> 19;
        int g = (c2 & 0xF800) >> 6;
        int b2 = (c2 & 0xF8) << 7;
        return b2 | g | r;
    }

    private final int red(int x) {
        return (x & 0x1F) << 3;
    }

    private final int green(int x) {
        return x >> 2 & 0xF8;
    }

    private final int blue(int x) {
        return x >> 7 & 0xF8;
    }

    public Image convert(int maxcubes) {
        ImageProcessor ip = this.convertToByte(maxcubes);
        return ip.createImage();
    }

    public ImageProcessor convertToByte(int maxcubes) {
        int longdim = 0;
        IJ.showStatus("Median cut");
        this.list = new Cube[256];
        this.histPtr = new int[32768];
        int ncubes = 0;
        Cube cube = new Cube();
        int i = 0;
        int color = 0;
        while (i <= Short.MAX_VALUE) {
            if (this.hist[i] != 0) {
                this.histPtr[color++] = i;
                cube.count += this.hist[i];
            }
            ++i;
        }
        cube.lower = 0;
        cube.upper = color - 1;
        cube.level = 0;
        this.Shrink(cube);
        this.list[ncubes++] = cube;
        while (ncubes < maxcubes) {
            int level = 255;
            int splitpos = -1;
            int k = 0;
            while (k <= ncubes - 1) {
                if (this.list[k].lower != this.list[k].upper && this.list[k].level < level) {
                    level = this.list[k].level;
                    splitpos = k;
                }
                ++k;
            }
            if (splitpos == -1) break;
            cube = this.list[splitpos];
            int lr = cube.rmax - cube.rmin;
            int lg = cube.gmax - cube.gmin;
            int lb = cube.bmax - cube.bmin;
            if (lr >= lg && lr >= lb) {
                longdim = 0;
            }
            if (lg >= lr && lg >= lb) {
                longdim = 1;
            }
            if (lb >= lr && lb >= lg) {
                longdim = 2;
            }
            this.reorderColors(this.histPtr, cube.lower, cube.upper, longdim);
            this.quickSort(this.histPtr, cube.lower, cube.upper);
            this.restoreColorOrder(this.histPtr, cube.lower, cube.upper, longdim);
            int count = 0;
            i = cube.lower;
            while (i <= cube.upper - 1) {
                if (count >= cube.count / 2) break;
                color = this.histPtr[i];
                count += this.hist[color];
                ++i;
            }
            int median = i;
            Cube cubeA = new Cube();
            cubeA.lower = cube.lower;
            cubeA.upper = median - 1;
            cubeA.count = count;
            cubeA.level = cube.level + 1;
            this.Shrink(cubeA);
            this.list[splitpos] = cubeA;
            Cube cubeB = new Cube();
            cubeB.lower = median;
            cubeB.upper = cube.upper;
            cubeB.count = cube.count - count;
            cubeB.level = cube.level + 1;
            this.Shrink(cubeB);
            this.list[ncubes++] = cubeB;
            if (ncubes % 15 != 0) continue;
            IJ.showProgress(0.3 + 0.6 * (double)ncubes / (double)maxcubes);
        }
        IJ.showProgress(0.9);
        this.makeInverseMap(this.hist, ncubes);
        IJ.showProgress(0.95);
        return this.makeImage();
    }

    void Shrink(Cube cube) {
        int rmin = 255;
        int rmax = 0;
        int gmin = 255;
        int gmax = 0;
        int bmin = 255;
        int bmax = 0;
        int i = cube.lower;
        while (i <= cube.upper) {
            int color = this.histPtr[i];
            int r = this.red(color);
            int g = this.green(color);
            int b2 = this.blue(color);
            if (r > rmax) {
                rmax = r;
            }
            if (r < rmin) {
                rmin = r;
            }
            if (g > gmax) {
                gmax = g;
            }
            if (g < gmin) {
                gmin = g;
            }
            if (b2 > bmax) {
                bmax = b2;
            }
            if (b2 < bmin) {
                bmin = b2;
            }
            ++i;
        }
        cube.rmin = rmin;
        cube.rmax = rmax;
        cube.gmin = gmin;
        cube.gmax = gmax;
        cube.gmin = gmin;
        cube.gmax = gmax;
    }

    void makeInverseMap(int[] hist, int ncubes) {
        int color;
        Cube cube;
        byte[] rLUT = new byte[256];
        byte[] gLUT = new byte[256];
        byte[] bLUT = new byte[256];
        IJ.showStatus("Making inverse map");
        int k = 0;
        while (k <= ncubes - 1) {
            int b2;
            int g;
            int r;
            cube = this.list[k];
            float bsum = 0.0f;
            float gsum = 0.0f;
            float rsum = 0.0f;
            int i = cube.lower;
            while (i <= cube.upper) {
                color = this.histPtr[i];
                r = this.red(color);
                rsum += (float)r * (float)hist[color];
                g = this.green(color);
                gsum += (float)g * (float)hist[color];
                b2 = this.blue(color);
                bsum += (float)b2 * (float)hist[color];
                ++i;
            }
            r = (int)(rsum / (float)cube.count);
            g = (int)(gsum / (float)cube.count);
            b2 = (int)(bsum / (float)cube.count);
            if (r == 248 && g == 248 && b2 == 248) {
                b2 = 255;
                g = 255;
                r = 255;
            }
            rLUT[k] = (byte)r;
            gLUT[k] = (byte)g;
            bLUT[k] = (byte)b2;
            ++k;
        }
        this.cm = new IndexColorModel(8, ncubes, rLUT, gLUT, bLUT);
        int k2 = 0;
        while (k2 <= ncubes - 1) {
            cube = this.list[k2];
            int i = cube.lower;
            while (i <= cube.upper) {
                color = this.histPtr[i];
                hist[color] = k2;
                ++i;
            }
            ++k2;
        }
    }

    void reorderColors(int[] a2, int lo, int hi, int longDim) {
        switch (longDim) {
            case 0: {
                int i = lo;
                while (i <= hi) {
                    int c2 = a2[i];
                    int r = c2 & 0x1F;
                    a2[i] = r << 10 | c2 >> 5;
                    ++i;
                }
                break;
            }
            case 1: {
                int i = lo;
                while (i <= hi) {
                    int c2 = a2[i];
                    int r = c2 & 0x1F;
                    int g = c2 >> 5 & 0x1F;
                    int b2 = c2 >> 10;
                    a2[i] = g << 10 | b2 << 5 | r;
                    ++i;
                }
                break;
            }
        }
    }

    void restoreColorOrder(int[] a2, int lo, int hi, int longDim) {
        switch (longDim) {
            case 0: {
                int i = lo;
                while (i <= hi) {
                    int c2 = a2[i];
                    int r = c2 >> 10;
                    a2[i] = (c2 & 0x3FF) << 5 | r;
                    ++i;
                }
                break;
            }
            case 1: {
                int i = lo;
                while (i <= hi) {
                    int c2 = a2[i];
                    int r = c2 & 0x1F;
                    int g = c2 >> 10;
                    int b2 = c2 >> 5 & 0x1F;
                    a2[i] = b2 << 10 | g << 5 | r;
                    ++i;
                }
                break;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    void quickSort(int[] a, int lo0, int hi0) {
        block5: {
            lo = lo0;
            hi = hi0;
            if (hi0 <= lo0) break block5;
            mid = a[(lo0 + hi0) / 2];
            ** GOTO lbl18
            {
                ++lo;
                do {
                    if (lo < hi0 && a[lo] < mid) continue block0;
                    while (hi > lo0 && a[hi] > mid) {
                        --hi;
                    }
                    if (lo > hi) continue;
                    t = a[lo];
                    a[lo] = a[hi];
                    a[hi] = t;
                    ++lo;
                    --hi;
lbl18:
                    // 3 sources

                } while (lo <= hi);
            }
            if (lo0 < hi) {
                this.quickSort(a, lo0, hi);
            }
            if (lo < hi0) {
                this.quickSort(a, lo, hi0);
            }
        }
    }

    ImageProcessor makeImage() {
        IJ.showStatus("Creating 8-bit image");
        byte[] pixels8 = new byte[this.width * this.height];
        int i = 0;
        while (i < this.width * this.height) {
            int color16 = this.rgb(this.pixels32[i]);
            pixels8[i] = (byte)this.hist[color16];
            ++i;
        }
        ByteProcessor ip = new ByteProcessor(this.width, this.height, pixels8, this.cm);
        IJ.showProgress(1.0);
        return ip;
    }
}

