/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.IOException;
import java.util.Date;
import nom.tam.fits.Data;
import nom.tam.fits.FitsDate;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.util.BufferedDataInputStream;
import nom.tam.util.BufferedDataOutputStream;

public abstract class BasicHDU {
    public static final int BITPIX_BYTE = 8;
    public static final int BITPIX_SHORT = 16;
    public static final int BITPIX_INT = 32;
    public static final int BITPIX_LONG = 64;
    public static final int BITPIX_FLOAT = -32;
    public static final int BITPIX_DOUBLE = -64;
    Header myHeader = null;
    Data myData = null;

    public BasicHDU(Header header) {
        this.myHeader = header;
        if (this.myHeader != null) {
            this.myHeader.unsetMark();
        }
    }

    abstract Data manufactureData() throws FitsException;

    public static void skipData(BufferedDataInputStream stream, Header hdr) throws IOException {
        stream.skipBytes(hdr.paddedDataSize());
    }

    public void skipData(BufferedDataInputStream stream) throws IOException {
        BasicHDU.skipData(stream, this.myHeader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readData(BufferedDataInputStream stream) throws FitsException {
        block5: {
            this.myData = null;
            try {
                this.myData = this.manufactureData();
                Object var3_2 = null;
                if (this.myData != null) break block5;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (this.myData != null) throw throwable;
                try {
                    BasicHDU.skipData(stream, this.myHeader);
                    throw throwable;
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception e2) {}
            BasicHDU.skipData(stream, this.myHeader);
        }
        this.myData.read(stream);
    }

    public Header getHeader() {
        return this.myHeader;
    }

    public Data getData() {
        return this.myData;
    }

    public int getSize() {
        int size = 0;
        if (this.myHeader != null) {
            size += this.myHeader.headerSize();
        }
        if (this.myData != null) {
            size += this.myData.getPaddedSize();
        }
        return size;
    }

    public static boolean isHeader(Header header) {
        return false;
    }

    public abstract void info();

    boolean checkField(String name) {
        String value = this.myHeader.getStringValue(name);
        if (value == null) {
            return false;
        }
        System.out.print(" " + name + "=" + value + ";");
        return true;
    }

    public void write(BufferedDataOutputStream stream) throws FitsException {
        if (this.myHeader != null) {
            this.myHeader.write(stream);
        }
        if (this.myData != null) {
            this.myData.write(stream);
        }
        try {
            stream.flush();
        }
        catch (IOException e2) {
            throw new FitsException("Error flushing at end of HDU: " + e2.getMessage());
        }
    }

    public String getTrimmedString(String keyword) {
        String s = this.myHeader.getStringValue(keyword);
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    public int getBitPix() throws FitsException {
        int bitpix = this.myHeader.getIntValue("BITPIX", -1);
        switch (bitpix) {
            case -64: 
            case -32: 
            case 8: 
            case 16: 
            case 32: {
                break;
            }
            default: {
                throw new FitsException("Unknown BITPIX type " + bitpix);
            }
        }
        return bitpix;
    }

    public int[] getAxes() throws FitsException {
        int nAxis = this.myHeader.getIntValue("NAXIS", 0);
        if (nAxis < 0) {
            throw new FitsException("Negative NAXIS value " + nAxis);
        }
        if (nAxis > 999) {
            throw new FitsException("NAXIS value " + nAxis + " too large");
        }
        if (nAxis == 0) {
            return null;
        }
        int[] axes = new int[nAxis];
        int i = 1;
        while (i <= nAxis) {
            axes[nAxis - i] = this.myHeader.getIntValue("NAXIS" + i, 0);
            ++i;
        }
        return axes;
    }

    public int getParameterCount() {
        return this.myHeader.getIntValue("PCOUNT", 0);
    }

    public int getGroupCount() {
        return this.myHeader.getIntValue("GCOUNT", 1);
    }

    public double getBScale() {
        return this.myHeader.getDoubleValue("BSCALE", 1.0);
    }

    public double getBZero() {
        return this.myHeader.getDoubleValue("BZERO", 0.0);
    }

    public String getBUnit() {
        return this.getTrimmedString("BUNIT");
    }

    public int getBlankValue() throws FitsException {
        if (!this.myHeader.containsKey("BLANK")) {
            throw new FitsException("BLANK undefined");
        }
        return this.myHeader.getIntValue("BLANK");
    }

    public Date getCreationDate() {
        try {
            return new FitsDate(this.myHeader.getStringValue("DATE")).toDate();
        }
        catch (FitsException e2) {
            return null;
        }
    }

    public Date getObservationDate() {
        try {
            return new FitsDate(this.myHeader.getStringValue("DATE-OBS")).toDate();
        }
        catch (FitsException e2) {
            return null;
        }
    }

    public String getOrigin() {
        return this.getTrimmedString("ORIGIN");
    }

    public String getTelescope() {
        return this.getTrimmedString("TELESCOP");
    }

    public String getInstrument() {
        return this.getTrimmedString("INSTRUME");
    }

    public String getObserver() {
        return this.getTrimmedString("OBSERVER");
    }

    public String getObject() {
        return this.getTrimmedString("OBJECT");
    }

    public double getEquinox() {
        return this.myHeader.getDoubleValue("EQUINOX", -1.0);
    }

    public double getEpoch() {
        return this.myHeader.getDoubleValue("EPOCH", -1.0);
    }

    public String getAuthor() {
        return this.getTrimmedString("AUTHOR");
    }

    public String getReference() {
        return this.getTrimmedString("REFERENC");
    }

    public double getMaximumValue() {
        return this.myHeader.getDoubleValue("DATAMAX");
    }

    public double getMinimumValue() {
        return this.myHeader.getDoubleValue("DATAMIN");
    }
}

