/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.lang.reflect.Array;
import java.util.Date;

public class ArrayFuncs {
    public static int computeSize(Object o) {
        if (o == null) {
            return 0;
        }
        int size = 0;
        String classname = o.getClass().getName();
        if (classname.substring(0, 2).equals("[[") || classname.equals("[Ljava.lang.String;") || classname.equals("[Ljava.lang.Object;")) {
            int i = 0;
            while (i < ((Object[])o).length) {
                size += ArrayFuncs.computeSize(((Object[])o)[i]);
                ++i;
            }
            return size;
        }
        if (classname.charAt(0) == '[' && classname.charAt(1) != 'L') {
            switch (classname.charAt(1)) {
                case 'I': {
                    return ((int[])o).length * 4;
                }
                case 'J': {
                    return ((long[])o).length * 8;
                }
                case 'F': {
                    return ((float[])o).length * 4;
                }
                case 'D': {
                    return ((double[])o).length * 8;
                }
                case 'B': {
                    return ((byte[])o).length;
                }
                case 'C': {
                    return ((char[])o).length * 2;
                }
                case 'S': {
                    return ((short[])o).length * 2;
                }
                case 'Z': {
                    return ((boolean[])o).length;
                }
            }
            return 0;
        }
        if (classname.substring(0, 10).equals("java.lang.")) {
            if ((classname = classname.substring(10, classname.length() - 1)).equals("Int") || classname.equals("Float")) {
                return 4;
            }
            if (classname.equals("Double") || classname.equals("Long")) {
                return 8;
            }
            if (classname.equals("Short") || classname.equals("Char")) {
                return 2;
            }
            if (classname.equals("Byte") || classname.equals("Boolean")) {
                return 1;
            }
            if (classname.equals("String")) {
                return ((String)o).length();
            }
            return 0;
        }
        return 0;
    }

    public static Object deepClone(Object o) {
        Class<?> baseClass;
        if (o == null) {
            return null;
        }
        String classname = o.getClass().getName();
        if (classname.charAt(0) != '[') {
            return ArrayFuncs.genericClone(o);
        }
        if (classname.charAt(1) != '[' && classname.charAt(1) != 'L') {
            try {
                switch (classname.charAt(1)) {
                    case 'B': {
                        return ((byte[])o).clone();
                    }
                    case 'Z': {
                        return ((boolean[])o).clone();
                    }
                    case 'C': {
                        return ((char[])o).clone();
                    }
                    case 'S': {
                        return ((short[])o).clone();
                    }
                    case 'I': {
                        return ((int[])o).clone();
                    }
                    case 'J': {
                        return ((long[])o).clone();
                    }
                    case 'F': {
                        return ((float[])o).clone();
                    }
                    case 'D': {
                        return ((double[])o).clone();
                    }
                }
                System.err.println("Unknown primtive array class:" + classname);
                return null;
            }
            catch (CloneNotSupportedException e2) {
                // empty catch block
            }
        }
        int ndim = 1;
        while (classname.charAt(ndim) == '[') {
            ++ndim;
        }
        if (classname.charAt(ndim) != 'L') {
            baseClass = ArrayFuncs.getBaseClass(o);
        } else {
            try {
                baseClass = Class.forName(classname.substring(ndim + 1, classname.length() - 1));
            }
            catch (ClassNotFoundException e3) {
                System.err.println("Internal error: class definition inconsistency: " + classname);
                return null;
            }
        }
        int[] dims = new int[ndim];
        dims[0] = Array.getLength(o);
        int i = 1;
        while (i < ndim) {
            dims[i] = 0;
            ++i;
        }
        Object copy = Array.newInstance(baseClass, dims);
        int i2 = 0;
        while (i2 < dims[0]) {
            Array.set(copy, i2, ArrayFuncs.deepClone(Array.get(o, i2)));
            ++i2;
        }
        return copy;
    }

    public static Object genericClone(Object o) {
        if (!(o instanceof Cloneable)) {
            return null;
        }
        Class[] argTypes = new Class[]{};
        Object[] args = new Object[]{};
        try {
            return o.getClass().getMethod("clone", argTypes).invoke(o, args);
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static void copyArray(Object original, Object copy) {
        String cname;
        String oname = original.getClass().getName();
        if (!oname.equals(cname = copy.getClass().getName())) {
            return;
        }
        if (oname.charAt(0) != '[') {
            return;
        }
        if (oname.charAt(1) == '[') {
            Object[] x = (Object[])original;
            Object[] y = (Object[])copy;
            if (x.length != y.length) {
                return;
            }
            int i = 0;
            while (i < x.length) {
                ArrayFuncs.copyArray(x, y);
                ++i;
            }
        }
        int len = Array.getLength(original);
        System.arraycopy(original, 0, copy, 0, len);
    }

    public static int[] getDimensions(Object o) {
        if (o == null) {
            return null;
        }
        String classname = o.getClass().getName();
        int ndim = 0;
        while (classname.charAt(ndim) == '[') {
            ++ndim;
        }
        int[] dimens = new int[ndim];
        int i = 0;
        while (i < ndim) {
            dimens[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < ndim) {
            dimens[i2] = Array.getLength(o);
            if (dimens[i2] == 0) {
                return dimens;
            }
            if (i2 != ndim - 1 && (o = ((Object[])o)[0]) == null) {
                return dimens;
            }
            ++i2;
        }
        return dimens;
    }

    public static Class getBaseClass(Object o) {
        if (o == null) {
            return Void.TYPE;
        }
        String className = o.getClass().getName();
        int dims = 0;
        while (className.charAt(dims) == '[') {
            ++dims;
        }
        if (dims == 0) {
            return o.getClass();
        }
        switch (className.charAt(dims)) {
            case 'Z': {
                return Boolean.TYPE;
            }
            case 'B': {
                return Byte.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'L': {
                try {
                    return Class.forName(className.substring(dims + 1, className.length() - 1));
                }
                catch (ClassNotFoundException e2) {
                    return null;
                }
            }
        }
        return null;
    }

    public static int getBaseLength(Object o) {
        if (o == null) {
            return 0;
        }
        String className = o.getClass().getName();
        int dims = 0;
        while (className.charAt(dims) == '[') {
            ++dims;
        }
        if (dims == 0) {
            return -1;
        }
        switch (className.charAt(dims)) {
            case 'Z': {
                return 1;
            }
            case 'B': {
                return 1;
            }
            case 'S': {
                return 2;
            }
            case 'C': {
                return 2;
            }
            case 'I': {
                return 4;
            }
            case 'J': {
                return 8;
            }
            case 'F': {
                return 4;
            }
            case 'D': {
                return 8;
            }
        }
        return -1;
    }

    public static Object generateArray(Class baseType, int[] dims) {
        Object x = Array.newInstance(baseType, dims);
        ArrayFuncs.testPattern(x, (byte)0);
        return x;
    }

    public static byte testPattern(Object o, byte start) {
        block3: {
            int[] dims;
            block2: {
                dims = ArrayFuncs.getDimensions(o);
                if (dims.length <= 1) break block2;
                int i = 0;
                while (i < ((Object[])o).length) {
                    start = ArrayFuncs.testPattern(((Object[])o)[i], start);
                    ++i;
                }
                break block3;
            }
            if (dims.length != 1) break block3;
            int i = 0;
            while (i < dims[0]) {
                Array.setByte(o, i, start);
                start = (byte)(start + 1);
                ++i;
            }
        }
        return start;
    }

    public static String arrayDescription(Object o) {
        Class base = ArrayFuncs.getBaseClass(o);
        if (base == Void.TYPE) {
            return "NULL";
        }
        int[] dims = ArrayFuncs.getDimensions(o);
        StringBuffer desc = new StringBuffer();
        if (base == Float.TYPE) {
            desc.append("float");
        } else if (base == Integer.TYPE) {
            desc.append("int");
        } else if (base == Double.TYPE) {
            desc.append("double");
        } else if (base == Short.TYPE) {
            desc.append("short");
        } else if (base == Long.TYPE) {
            desc.append("long");
        } else if (base == Character.TYPE) {
            desc.append("char");
        } else if (base == Byte.TYPE) {
            desc.append("byte");
        } else if (base == Boolean.TYPE) {
            desc.append("boolean");
        } else {
            desc.append(base.getName());
        }
        if (dims != null) {
            desc.append("[");
            int i = 0;
            while (i < dims.length) {
                desc.append("" + dims[i]);
                if (i < dims.length - 1) {
                    desc.append(",");
                }
                ++i;
            }
            desc.append("]");
        }
        return new String(desc);
    }

    public static void examinePrimitiveArray(Object o) {
        String className = o.getClass().getName();
        if (className.substring(0, 2).equals("[[") || className.equals("[Ljava.lang.Object;")) {
            System.out.println("[");
            int i = 0;
            while (i < ((Object[])o).length) {
                ArrayFuncs.examinePrimitiveArray(((Object[])o)[i]);
                ++i;
            }
            System.out.print("]");
        } else if (className.charAt(0) != '[') {
            System.out.println(className);
        } else {
            System.out.println("[" + Array.getLength(o) + "]" + className.substring(1));
        }
    }

    public static Object flatten(Object input) {
        int[] dimens = ArrayFuncs.getDimensions(input);
        if (dimens.length <= 1) {
            return input;
        }
        int size = 1;
        int i = 0;
        while (i < dimens.length) {
            size *= dimens[i];
            ++i;
        }
        Object flat = Array.newInstance(ArrayFuncs.getBaseClass(input), size);
        if (size == 0) {
            return flat;
        }
        int offset = 0;
        ArrayFuncs.doFlatten(input, flat, offset);
        return flat;
    }

    protected static int doFlatten(Object input, Object output, int offset) {
        String classname = input.getClass().getName();
        if (classname.charAt(0) != '[') {
            throw new RuntimeException("Attempt to flatten non-array");
        }
        int size = Array.getLength(input);
        if (classname.charAt(1) != '[') {
            System.arraycopy(input, 0, output, offset, size);
            return size;
        }
        int total = 0;
        Object[] xx = (Object[])input;
        int i = 0;
        while (i < size) {
            int len = ArrayFuncs.doFlatten(xx[i], output, offset + total);
            total += len;
            ++i;
        }
        return total;
    }

    public static Object curl(Object input, int[] dimens) {
        String classname = input.getClass().getName();
        if (classname.charAt(0) != '[' || classname.charAt(1) == '[') {
            throw new RuntimeException("Attempt to curl non-1D array");
        }
        int size = Array.getLength(input);
        int test = 1;
        int i = 0;
        while (i < dimens.length) {
            test *= dimens[i];
            ++i;
        }
        if (test != size) {
            throw new RuntimeException("Curled array does not fit desired dimensions");
        }
        Class base = ArrayFuncs.getBaseClass(input);
        Object newArray = Array.newInstance(base, dimens);
        int offset = 0;
        ArrayFuncs.doCurl(input, newArray, dimens, offset);
        return newArray;
    }

    protected static int doCurl(Object input, Object output, int[] dimens, int offset) {
        if (dimens.length == 1) {
            System.arraycopy(input, offset, output, 0, dimens[0]);
            return dimens[0];
        }
        int total = 0;
        int[] xdimens = new int[dimens.length - 1];
        int i = 1;
        while (i < dimens.length) {
            xdimens[i - 1] = dimens[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < dimens[0]) {
            total += ArrayFuncs.doCurl(input, ((Object[])output)[i2], xdimens, offset + total);
            ++i2;
        }
        return total;
    }

    public static Object convertArray(Object array, Class newType) {
        Object converted;
        block67: {
            Class base;
            block103: {
                float[] farr;
                block109: {
                    block108: {
                        block107: {
                            block106: {
                                block105: {
                                    block104: {
                                        block96: {
                                            long[] larr;
                                            block102: {
                                                block101: {
                                                    block100: {
                                                        block99: {
                                                            block98: {
                                                                block97: {
                                                                    block89: {
                                                                        int[] iarr;
                                                                        block95: {
                                                                            block94: {
                                                                                block93: {
                                                                                    block92: {
                                                                                        block91: {
                                                                                            block90: {
                                                                                                block82: {
                                                                                                    char[] carr;
                                                                                                    block88: {
                                                                                                        block87: {
                                                                                                            block86: {
                                                                                                                block85: {
                                                                                                                    block84: {
                                                                                                                        block83: {
                                                                                                                            block75: {
                                                                                                                                short[] sarr;
                                                                                                                                block81: {
                                                                                                                                    block80: {
                                                                                                                                        block79: {
                                                                                                                                            block78: {
                                                                                                                                                block77: {
                                                                                                                                                    block76: {
                                                                                                                                                        block68: {
                                                                                                                                                            byte[] barr;
                                                                                                                                                            block74: {
                                                                                                                                                                block73: {
                                                                                                                                                                    block72: {
                                                                                                                                                                        block71: {
                                                                                                                                                                            block70: {
                                                                                                                                                                                block69: {
                                                                                                                                                                                    block66: {
                                                                                                                                                                                        String classname = array.getClass().getName();
                                                                                                                                                                                        if (classname.charAt(0) != '[') {
                                                                                                                                                                                            return null;
                                                                                                                                                                                        }
                                                                                                                                                                                        int dims = 1;
                                                                                                                                                                                        while (classname.charAt(dims) == '[') {
                                                                                                                                                                                            ++dims;
                                                                                                                                                                                        }
                                                                                                                                                                                        if (dims <= 1) break block66;
                                                                                                                                                                                        Object[] xarray = (Object[])array;
                                                                                                                                                                                        int[] dimens = new int[dims];
                                                                                                                                                                                        dimens[0] = xarray.length;
                                                                                                                                                                                        converted = Array.newInstance(newType, dimens);
                                                                                                                                                                                        int i = 0;
                                                                                                                                                                                        while (i < xarray.length) {
                                                                                                                                                                                            Object temp;
                                                                                                                                                                                            ((Object[])converted)[i] = temp = ArrayFuncs.convertArray(xarray[i], newType);
                                                                                                                                                                                            ++i;
                                                                                                                                                                                        }
                                                                                                                                                                                        break block67;
                                                                                                                                                                                    }
                                                                                                                                                                                    converted = null;
                                                                                                                                                                                    base = ArrayFuncs.getBaseClass(array);
                                                                                                                                                                                    if (base != Byte.TYPE) break block68;
                                                                                                                                                                                    barr = (byte[])array;
                                                                                                                                                                                    if (newType != Byte.TYPE) break block69;
                                                                                                                                                                                    byte[] xbarr = new byte[barr.length];
                                                                                                                                                                                    converted = xbarr;
                                                                                                                                                                                    int i = 0;
                                                                                                                                                                                    while (i < barr.length) {
                                                                                                                                                                                        xbarr[i] = barr[i];
                                                                                                                                                                                        ++i;
                                                                                                                                                                                    }
                                                                                                                                                                                    break block67;
                                                                                                                                                                                }
                                                                                                                                                                                if (newType != Short.TYPE) break block70;
                                                                                                                                                                                short[] xsarr = new short[barr.length];
                                                                                                                                                                                converted = xsarr;
                                                                                                                                                                                int i = 0;
                                                                                                                                                                                while (i < barr.length) {
                                                                                                                                                                                    xsarr[i] = barr[i];
                                                                                                                                                                                    ++i;
                                                                                                                                                                                }
                                                                                                                                                                                break block67;
                                                                                                                                                                            }
                                                                                                                                                                            if (newType != Character.TYPE) break block71;
                                                                                                                                                                            char[] xcarr = new char[barr.length];
                                                                                                                                                                            converted = xcarr;
                                                                                                                                                                            int i = 0;
                                                                                                                                                                            while (i < barr.length) {
                                                                                                                                                                                xcarr[i] = (char)barr[i];
                                                                                                                                                                                ++i;
                                                                                                                                                                            }
                                                                                                                                                                            break block67;
                                                                                                                                                                        }
                                                                                                                                                                        if (newType != Integer.TYPE) break block72;
                                                                                                                                                                        int[] xiarr = new int[barr.length];
                                                                                                                                                                        converted = xiarr;
                                                                                                                                                                        int i = 0;
                                                                                                                                                                        while (i < barr.length) {
                                                                                                                                                                            xiarr[i] = barr[i];
                                                                                                                                                                            ++i;
                                                                                                                                                                        }
                                                                                                                                                                        break block67;
                                                                                                                                                                    }
                                                                                                                                                                    if (newType != Long.TYPE) break block73;
                                                                                                                                                                    long[] xlarr = new long[barr.length];
                                                                                                                                                                    converted = xlarr;
                                                                                                                                                                    int i = 0;
                                                                                                                                                                    while (i < barr.length) {
                                                                                                                                                                        xlarr[i] = barr[i];
                                                                                                                                                                        ++i;
                                                                                                                                                                    }
                                                                                                                                                                    break block67;
                                                                                                                                                                }
                                                                                                                                                                if (newType != Float.TYPE) break block74;
                                                                                                                                                                float[] xfarr = new float[barr.length];
                                                                                                                                                                converted = xfarr;
                                                                                                                                                                int i = 0;
                                                                                                                                                                while (i < barr.length) {
                                                                                                                                                                    xfarr[i] = barr[i];
                                                                                                                                                                    ++i;
                                                                                                                                                                }
                                                                                                                                                                break block67;
                                                                                                                                                            }
                                                                                                                                                            if (newType != Double.TYPE) break block67;
                                                                                                                                                            double[] xdarr = new double[barr.length];
                                                                                                                                                            converted = xdarr;
                                                                                                                                                            int i = 0;
                                                                                                                                                            while (i < barr.length) {
                                                                                                                                                                xdarr[i] = barr[i];
                                                                                                                                                                ++i;
                                                                                                                                                            }
                                                                                                                                                            break block67;
                                                                                                                                                        }
                                                                                                                                                        if (base != Short.TYPE) break block75;
                                                                                                                                                        sarr = (short[])array;
                                                                                                                                                        if (newType != Byte.TYPE) break block76;
                                                                                                                                                        byte[] xbarr = new byte[sarr.length];
                                                                                                                                                        converted = xbarr;
                                                                                                                                                        int i = 0;
                                                                                                                                                        while (i < sarr.length) {
                                                                                                                                                            xbarr[i] = (byte)sarr[i];
                                                                                                                                                            ++i;
                                                                                                                                                        }
                                                                                                                                                        break block67;
                                                                                                                                                    }
                                                                                                                                                    if (newType != Short.TYPE) break block77;
                                                                                                                                                    short[] xsarr = new short[sarr.length];
                                                                                                                                                    converted = xsarr;
                                                                                                                                                    int i = 0;
                                                                                                                                                    while (i < sarr.length) {
                                                                                                                                                        xsarr[i] = sarr[i];
                                                                                                                                                        ++i;
                                                                                                                                                    }
                                                                                                                                                    break block67;
                                                                                                                                                }
                                                                                                                                                if (newType != Character.TYPE) break block78;
                                                                                                                                                char[] xcarr = new char[sarr.length];
                                                                                                                                                converted = xcarr;
                                                                                                                                                int i = 0;
                                                                                                                                                while (i < sarr.length) {
                                                                                                                                                    xcarr[i] = (char)sarr[i];
                                                                                                                                                    ++i;
                                                                                                                                                }
                                                                                                                                                break block67;
                                                                                                                                            }
                                                                                                                                            if (newType != Integer.TYPE) break block79;
                                                                                                                                            int[] xiarr = new int[sarr.length];
                                                                                                                                            converted = xiarr;
                                                                                                                                            int i = 0;
                                                                                                                                            while (i < sarr.length) {
                                                                                                                                                xiarr[i] = sarr[i];
                                                                                                                                                ++i;
                                                                                                                                            }
                                                                                                                                            break block67;
                                                                                                                                        }
                                                                                                                                        if (newType != Long.TYPE) break block80;
                                                                                                                                        long[] xlarr = new long[sarr.length];
                                                                                                                                        converted = xlarr;
                                                                                                                                        int i = 0;
                                                                                                                                        while (i < sarr.length) {
                                                                                                                                            xlarr[i] = sarr[i];
                                                                                                                                            ++i;
                                                                                                                                        }
                                                                                                                                        break block67;
                                                                                                                                    }
                                                                                                                                    if (newType != Float.TYPE) break block81;
                                                                                                                                    float[] xfarr = new float[sarr.length];
                                                                                                                                    converted = xfarr;
                                                                                                                                    int i = 0;
                                                                                                                                    while (i < sarr.length) {
                                                                                                                                        xfarr[i] = sarr[i];
                                                                                                                                        ++i;
                                                                                                                                    }
                                                                                                                                    break block67;
                                                                                                                                }
                                                                                                                                if (newType != Double.TYPE) break block67;
                                                                                                                                double[] xdarr = new double[sarr.length];
                                                                                                                                converted = xdarr;
                                                                                                                                int i = 0;
                                                                                                                                while (i < sarr.length) {
                                                                                                                                    xdarr[i] = sarr[i];
                                                                                                                                    ++i;
                                                                                                                                }
                                                                                                                                break block67;
                                                                                                                            }
                                                                                                                            if (base != Character.TYPE) break block82;
                                                                                                                            carr = (char[])array;
                                                                                                                            if (newType != Byte.TYPE) break block83;
                                                                                                                            byte[] xbarr = new byte[carr.length];
                                                                                                                            converted = xbarr;
                                                                                                                            int i = 0;
                                                                                                                            while (i < carr.length) {
                                                                                                                                xbarr[i] = (byte)carr[i];
                                                                                                                                ++i;
                                                                                                                            }
                                                                                                                            break block67;
                                                                                                                        }
                                                                                                                        if (newType != Short.TYPE) break block84;
                                                                                                                        short[] xsarr = new short[carr.length];
                                                                                                                        converted = xsarr;
                                                                                                                        int i = 0;
                                                                                                                        while (i < carr.length) {
                                                                                                                            xsarr[i] = (short)carr[i];
                                                                                                                            ++i;
                                                                                                                        }
                                                                                                                        break block67;
                                                                                                                    }
                                                                                                                    if (newType != Character.TYPE) break block85;
                                                                                                                    char[] xcarr = new char[carr.length];
                                                                                                                    converted = xcarr;
                                                                                                                    int i = 0;
                                                                                                                    while (i < carr.length) {
                                                                                                                        xcarr[i] = carr[i];
                                                                                                                        ++i;
                                                                                                                    }
                                                                                                                    break block67;
                                                                                                                }
                                                                                                                if (newType != Integer.TYPE) break block86;
                                                                                                                int[] xiarr = new int[carr.length];
                                                                                                                converted = xiarr;
                                                                                                                int i = 0;
                                                                                                                while (i < carr.length) {
                                                                                                                    xiarr[i] = carr[i];
                                                                                                                    ++i;
                                                                                                                }
                                                                                                                break block67;
                                                                                                            }
                                                                                                            if (newType != Long.TYPE) break block87;
                                                                                                            long[] xlarr = new long[carr.length];
                                                                                                            converted = xlarr;
                                                                                                            int i = 0;
                                                                                                            while (i < carr.length) {
                                                                                                                xlarr[i] = carr[i];
                                                                                                                ++i;
                                                                                                            }
                                                                                                            break block67;
                                                                                                        }
                                                                                                        if (newType != Float.TYPE) break block88;
                                                                                                        float[] xfarr = new float[carr.length];
                                                                                                        converted = xfarr;
                                                                                                        int i = 0;
                                                                                                        while (i < carr.length) {
                                                                                                            xfarr[i] = carr[i];
                                                                                                            ++i;
                                                                                                        }
                                                                                                        break block67;
                                                                                                    }
                                                                                                    if (newType != Double.TYPE) break block67;
                                                                                                    double[] xdarr = new double[carr.length];
                                                                                                    converted = xdarr;
                                                                                                    int i = 0;
                                                                                                    while (i < carr.length) {
                                                                                                        xdarr[i] = carr[i];
                                                                                                        ++i;
                                                                                                    }
                                                                                                    break block67;
                                                                                                }
                                                                                                if (base != Integer.TYPE) break block89;
                                                                                                iarr = (int[])array;
                                                                                                if (newType != Byte.TYPE) break block90;
                                                                                                byte[] xbarr = new byte[iarr.length];
                                                                                                converted = xbarr;
                                                                                                int i = 0;
                                                                                                while (i < iarr.length) {
                                                                                                    xbarr[i] = (byte)iarr[i];
                                                                                                    ++i;
                                                                                                }
                                                                                                break block67;
                                                                                            }
                                                                                            if (newType != Short.TYPE) break block91;
                                                                                            short[] xsarr = new short[iarr.length];
                                                                                            converted = xsarr;
                                                                                            int i = 0;
                                                                                            while (i < iarr.length) {
                                                                                                xsarr[i] = (short)iarr[i];
                                                                                                ++i;
                                                                                            }
                                                                                            break block67;
                                                                                        }
                                                                                        if (newType != Character.TYPE) break block92;
                                                                                        char[] xcarr = new char[iarr.length];
                                                                                        converted = xcarr;
                                                                                        int i = 0;
                                                                                        while (i < iarr.length) {
                                                                                            xcarr[i] = (char)iarr[i];
                                                                                            ++i;
                                                                                        }
                                                                                        break block67;
                                                                                    }
                                                                                    if (newType != Integer.TYPE) break block93;
                                                                                    int[] xiarr = new int[iarr.length];
                                                                                    converted = xiarr;
                                                                                    int i = 0;
                                                                                    while (i < iarr.length) {
                                                                                        xiarr[i] = iarr[i];
                                                                                        ++i;
                                                                                    }
                                                                                    break block67;
                                                                                }
                                                                                if (newType != Long.TYPE) break block94;
                                                                                long[] xlarr = new long[iarr.length];
                                                                                converted = xlarr;
                                                                                int i = 0;
                                                                                while (i < iarr.length) {
                                                                                    xlarr[i] = iarr[i];
                                                                                    ++i;
                                                                                }
                                                                                break block67;
                                                                            }
                                                                            if (newType != Float.TYPE) break block95;
                                                                            float[] xfarr = new float[iarr.length];
                                                                            converted = xfarr;
                                                                            int i = 0;
                                                                            while (i < iarr.length) {
                                                                                xfarr[i] = iarr[i];
                                                                                ++i;
                                                                            }
                                                                            break block67;
                                                                        }
                                                                        if (newType != Double.TYPE) break block67;
                                                                        double[] xdarr = new double[iarr.length];
                                                                        converted = xdarr;
                                                                        int i = 0;
                                                                        while (i < iarr.length) {
                                                                            xdarr[i] = iarr[i];
                                                                            ++i;
                                                                        }
                                                                        break block67;
                                                                    }
                                                                    if (base != Long.TYPE) break block96;
                                                                    larr = (long[])array;
                                                                    if (newType != Byte.TYPE) break block97;
                                                                    byte[] xbarr = new byte[larr.length];
                                                                    converted = xbarr;
                                                                    int i = 0;
                                                                    while (i < larr.length) {
                                                                        xbarr[i] = (byte)larr[i];
                                                                        ++i;
                                                                    }
                                                                    break block67;
                                                                }
                                                                if (newType != Short.TYPE) break block98;
                                                                short[] xsarr = new short[larr.length];
                                                                converted = xsarr;
                                                                int i = 0;
                                                                while (i < larr.length) {
                                                                    xsarr[i] = (short)larr[i];
                                                                    ++i;
                                                                }
                                                                break block67;
                                                            }
                                                            if (newType != Character.TYPE) break block99;
                                                            char[] xcarr = new char[larr.length];
                                                            converted = xcarr;
                                                            int i = 0;
                                                            while (i < larr.length) {
                                                                xcarr[i] = (char)larr[i];
                                                                ++i;
                                                            }
                                                            break block67;
                                                        }
                                                        if (newType != Integer.TYPE) break block100;
                                                        int[] xiarr = new int[larr.length];
                                                        converted = xiarr;
                                                        int i = 0;
                                                        while (i < larr.length) {
                                                            xiarr[i] = (int)larr[i];
                                                            ++i;
                                                        }
                                                        break block67;
                                                    }
                                                    if (newType != Long.TYPE) break block101;
                                                    long[] xlarr = new long[larr.length];
                                                    converted = xlarr;
                                                    int i = 0;
                                                    while (i < larr.length) {
                                                        xlarr[i] = larr[i];
                                                        ++i;
                                                    }
                                                    break block67;
                                                }
                                                if (newType != Float.TYPE) break block102;
                                                float[] xfarr = new float[larr.length];
                                                converted = xfarr;
                                                int i = 0;
                                                while (i < larr.length) {
                                                    xfarr[i] = larr[i];
                                                    ++i;
                                                }
                                                break block67;
                                            }
                                            if (newType != Double.TYPE) break block67;
                                            double[] xdarr = new double[larr.length];
                                            converted = xdarr;
                                            int i = 0;
                                            while (i < larr.length) {
                                                xdarr[i] = larr[i];
                                                ++i;
                                            }
                                            break block67;
                                        }
                                        if (base != Float.TYPE) break block103;
                                        farr = (float[])array;
                                        if (newType != Byte.TYPE) break block104;
                                        byte[] xbarr = new byte[farr.length];
                                        converted = xbarr;
                                        int i = 0;
                                        while (i < farr.length) {
                                            xbarr[i] = (byte)farr[i];
                                            ++i;
                                        }
                                        break block67;
                                    }
                                    if (newType != Short.TYPE) break block105;
                                    short[] xsarr = new short[farr.length];
                                    converted = xsarr;
                                    int i = 0;
                                    while (i < farr.length) {
                                        xsarr[i] = (short)farr[i];
                                        ++i;
                                    }
                                    break block67;
                                }
                                if (newType != Character.TYPE) break block106;
                                char[] xcarr = new char[farr.length];
                                converted = xcarr;
                                int i = 0;
                                while (i < farr.length) {
                                    xcarr[i] = (char)farr[i];
                                    ++i;
                                }
                                break block67;
                            }
                            if (newType != Integer.TYPE) break block107;
                            int[] xiarr = new int[farr.length];
                            converted = xiarr;
                            int i = 0;
                            while (i < farr.length) {
                                xiarr[i] = (int)farr[i];
                                ++i;
                            }
                            break block67;
                        }
                        if (newType != Long.TYPE) break block108;
                        long[] xlarr = new long[farr.length];
                        converted = xlarr;
                        int i = 0;
                        while (i < farr.length) {
                            xlarr[i] = (long)farr[i];
                            ++i;
                        }
                        break block67;
                    }
                    if (newType != Float.TYPE) break block109;
                    float[] xfarr = new float[farr.length];
                    converted = xfarr;
                    int i = 0;
                    while (i < farr.length) {
                        xfarr[i] = farr[i];
                        ++i;
                    }
                    break block67;
                }
                if (newType != Double.TYPE) break block67;
                double[] xdarr = new double[farr.length];
                converted = xdarr;
                int i = 0;
                while (i < farr.length) {
                    xdarr[i] = farr[i];
                    ++i;
                }
                break block67;
            }
            if (base == Double.TYPE) {
                double[] darr = (double[])array;
                if (newType == Byte.TYPE) {
                    byte[] xbarr = new byte[darr.length];
                    converted = xbarr;
                    int i = 0;
                    while (i < darr.length) {
                        xbarr[i] = (byte)darr[i];
                        ++i;
                    }
                } else if (newType == Short.TYPE) {
                    short[] xsarr = new short[darr.length];
                    converted = xsarr;
                    int i = 0;
                    while (i < darr.length) {
                        xsarr[i] = (short)darr[i];
                        ++i;
                    }
                } else if (newType == Character.TYPE) {
                    char[] xcarr = new char[darr.length];
                    converted = xcarr;
                    int i = 0;
                    while (i < darr.length) {
                        xcarr[i] = (char)darr[i];
                        ++i;
                    }
                } else if (newType == Integer.TYPE) {
                    int[] xiarr = new int[darr.length];
                    converted = xiarr;
                    int i = 0;
                    while (i < darr.length) {
                        xiarr[i] = (int)darr[i];
                        ++i;
                    }
                } else if (newType == Long.TYPE) {
                    long[] xlarr = new long[darr.length];
                    converted = xlarr;
                    int i = 0;
                    while (i < darr.length) {
                        xlarr[i] = (long)darr[i];
                        ++i;
                    }
                } else if (newType == Float.TYPE) {
                    float[] xfarr = new float[darr.length];
                    converted = xfarr;
                    int i = 0;
                    while (i < darr.length) {
                        xfarr[i] = (float)darr[i];
                        ++i;
                    }
                } else if (newType == Double.TYPE) {
                    double[] xdarr = new double[darr.length];
                    converted = xdarr;
                    int i = 0;
                    while (i < darr.length) {
                        xdarr[i] = darr[i];
                        ++i;
                    }
                }
            }
        }
        return converted;
    }

    public static void main(String[] args) {
        int[][][] test1 = new int[10][9][8];
        boolean[][] test2 = new boolean[][]{new boolean[5], new boolean[4], new boolean[3], new boolean[2]};
        double[][] test3 = new double[10][20];
        StringBuffer[][] test4 = new StringBuffer[3][2];
        System.out.println("getBaseClass: test1: Base type of integer array is:" + ArrayFuncs.getBaseClass(test1));
        System.out.println("getBaseLength: test1: " + ArrayFuncs.getBaseLength(test1));
        System.out.println("arrayDescription: test1: " + ArrayFuncs.arrayDescription(test1));
        System.out.println("computeSize: test1:   " + ArrayFuncs.computeSize(test1));
        System.out.println("getBaseClass: test2: Base type of boolean array is:" + ArrayFuncs.getBaseClass(test2));
        System.out.println("getBaseLength: test2: " + ArrayFuncs.getBaseLength(test2));
        System.out.println("arrayDescription: test2: " + ArrayFuncs.arrayDescription(test2));
        System.out.println("computeSize: test2:   " + ArrayFuncs.computeSize(test2));
        System.out.println("getBaseClass: test3: Base type of double array is: " + ArrayFuncs.getBaseClass(test3));
        System.out.println("getBaseLength: test3: " + ArrayFuncs.getBaseLength(test3));
        System.out.println("arrayDescription: test1: " + ArrayFuncs.arrayDescription(test3));
        System.out.println("computeSize: test3:   " + ArrayFuncs.computeSize(test3));
        System.out.println("getBaseClass: test4: Base type of StringBuffer array is: " + ArrayFuncs.getBaseClass(test4));
        System.out.println("getBaseLength: test4: " + ArrayFuncs.getBaseLength(test4));
        System.out.println("arrayDescription: test1: " + ArrayFuncs.arrayDescription(test4));
        System.out.println("computeSize: test4:   " + ArrayFuncs.computeSize(test4));
        System.out.println("");
        System.out.println("arrayDescription: test1: Print a simple description of an array:" + ArrayFuncs.arrayDescription(test1));
        System.out.println("arrayDescription: test2: doesn't handle non-rectangular arrays:" + ArrayFuncs.arrayDescription(test2));
        System.out.println("");
        System.out.println("examinePrimitiveArray: test1");
        ArrayFuncs.examinePrimitiveArray(test1);
        System.out.println("");
        System.out.println("examinePrimitiveArray: test2");
        ArrayFuncs.examinePrimitiveArray(test2);
        System.out.println("");
        System.out.println("    NOTE: this should show that test2 is not a rectangular array");
        System.out.println("");
        System.out.println("Using aggregates:");
        Object[] agg = new Object[]{test1, test2, test3, test4};
        System.out.println("getBaseClass: agg: Base class of aggregate is:" + ArrayFuncs.getBaseClass(agg));
        System.out.println("Size of aggregate is:" + ArrayFuncs.computeSize(agg));
        System.out.println("This ignores the array of StringBuffers");
        ArrayFuncs.testPattern(test1, (byte)0);
        System.out.println("testPattern:");
        int i = 0;
        while (i < test1.length) {
            int j = 0;
            while (j < test1[0].length) {
                int k = 0;
                while (k < test1[0][0].length) {
                    System.out.print(" " + test1[i][j][k]);
                    ++k;
                }
                System.out.println("");
                ++j;
            }
            System.out.println("");
            ++i;
        }
        int[][][] test5 = (int[][][])ArrayFuncs.deepClone(test1);
        System.out.println("deepClone: copied array");
        int i2 = 0;
        while (i2 < test5.length) {
            int j = 0;
            while (j < test5[0].length) {
                int k = 0;
                while (k < test5[0][0].length) {
                    System.out.print(" " + test5[i2][j][k]);
                    ++k;
                }
                System.out.println("");
                ++j;
            }
            System.out.println("");
            ++i2;
        }
        test5[2][2][2] = 99;
        System.out.println("Demonstrating that this is a deep clone:" + test5[2][2][2] + " " + test1[2][2][2]);
        System.out.println("Flatten an array:");
        int[] test6 = (int[])ArrayFuncs.flatten(test1);
        System.out.println("    arrayDescription: test6:" + ArrayFuncs.arrayDescription(test6));
        int i3 = 0;
        while (i3 < test6.length) {
            System.out.print(" " + test6[i3]);
            if (i3 > 0 && i3 % 10 == 0) {
                System.out.println("");
            }
            ++i3;
        }
        System.out.println("");
        System.out.println("Curl an array, we'll reformat test1's data");
        int[] newdims = new int[]{8, 9, 10};
        int[][][] test7 = (int[][][])ArrayFuncs.curl(test6, newdims);
        int i4 = 0;
        while (i4 < test5.length) {
            int j = 0;
            while (j < test5[0].length) {
                int k = 0;
                while (k < test5[0][0].length) {
                    System.out.print(" " + test5[i4][j][k]);
                    ++k;
                }
                System.out.println("");
                ++j;
            }
            System.out.println("");
            ++i4;
        }
        System.out.println("");
        System.out.println("Test array conversions");
        byte[][][] xtest1 = (byte[][][])ArrayFuncs.convertArray(test1, Byte.TYPE);
        System.out.println("  xtest1 is of type:" + ArrayFuncs.arrayDescription(xtest1));
        System.out.println("   test1[3][3][3]=" + test1[3][3][3] + "  xtest1=" + xtest1[3][3][3]);
        System.out.println("Converting float[700][700] to byte at:" + new Date());
        float[][] big = new float[700][700];
        byte[][] img = (byte[][])ArrayFuncs.convertArray(big, Byte.TYPE);
        System.out.println("  img=" + ArrayFuncs.arrayDescription(img) + " at " + new Date());
        System.out.println("End of tests");
    }
}

