/*
 * Decompiled with CFR 0.152.
 */
package ucar.netcdf;

import java.io.Serializable;
import java.util.Enumeration;
import ucar.netcdf.Dimension;
import ucar.netcdf.DimensionIterator;
import ucar.netcdf.DimensionSet;
import ucar.netcdf.Named;
import ucar.netcdf.NamedDictionary;
import ucar.netcdf.ProtoVariable;

class DimensionDictionary
implements DimensionSet,
Serializable {
    private final NamedDictionary dimensions;

    DimensionDictionary() {
        this.dimensions = new NamedDictionary(0);
    }

    DimensionDictionary(DimensionSet ss) {
        this.dimensions = new NamedDictionary(ss.size());
        DimensionIterator iter = ss.iterator();
        while (iter.hasNext()) {
            this.put(iter.next());
        }
    }

    DimensionDictionary(ProtoVariable[] varArray) {
        this.dimensions = new NamedDictionary(0);
        int jj = 0;
        while (jj < varArray.length) {
            varArray[jj].connectDims(this);
            ++jj;
        }
    }

    public int size() {
        return this.dimensions.size();
    }

    public DimensionIterator iterator() {
        return new DimensionIterator(){
            final Enumeration ee;
            {
                this.ee = DimensionDictionary.this.dimensions.elements();
            }

            public boolean hasNext() {
                return this.ee.hasMoreElements();
            }

            public Dimension next() {
                return (Dimension)this.ee.nextElement();
            }
        };
    }

    public synchronized Dimension[] toArray() {
        Dimension[] aa2 = new Dimension[this.size()];
        DimensionIterator ee = this.iterator();
        int ii = 0;
        while (ee.hasNext()) {
            Dimension dim = ee.next();
            aa2[ii] = (Dimension)dim.clone();
            ++ii;
        }
        return aa2;
    }

    public Dimension get(String name) {
        return (Dimension)this.dimensions.get(name);
    }

    public boolean contains(String name) {
        return this.dimensions.contains(name);
    }

    public boolean contains(Object oo) {
        return this.dimensions.contains(oo);
    }

    public void toCdl(StringBuffer buf) {
        buf.append("dimensions:\n");
        DimensionIterator iter = this.iterator();
        while (iter.hasNext()) {
            buf.append("\t");
            iter.next().toCdl(buf);
            buf.append("\n");
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.toCdl(buf);
        return buf.toString();
    }

    synchronized Dimension put(Dimension dim) {
        String dname = dim.getName();
        Dimension found = this.get(dname);
        if (found != null) {
            if (found.equals(dim)) {
                return found;
            }
            throw new IllegalArgumentException("Duplicate dimension name");
        }
        Dimension copy = (Dimension)dim.clone();
        this.dimensions.put(copy);
        return copy;
    }

    void initialPut(Dimension dim) {
        if (this.contains(dim.getName())) {
            throw new IllegalArgumentException("Duplicate dimension name \"" + dim.getName() + "\"");
        }
        this.dimensions.put(dim);
    }

    boolean remove(String name) {
        Named oo = this.dimensions.remove(name);
        return oo != null;
    }

    int indexOf(Dimension elem) {
        return this.dimensions.indexOf(elem);
    }
}

