/*
 * Decompiled with CFR 0.152.
 */
package ucar.netcdf;

import java.lang.reflect.Array;
import ucar.netcdf.AttrVal;
import ucar.netcdf.Attribute;

final class NumericAttrVal
extends AttrVal {
    private final Object data;

    NumericAttrVal(Number nn, Class componentType) {
        this.data = Array.newInstance(componentType, 1);
        Array.set(this.data, 0, nn);
    }

    NumericAttrVal(Object data) {
        this.data = data;
    }

    public int hashCode() {
        int h = 0;
        int len = this.getLength();
        int ii = 0;
        while (ii < len) {
            h = h * 13 + this.get(ii).hashCode();
            ++ii;
        }
        return h;
    }

    public boolean equals(Object oo) {
        if (oo instanceof NumericAttrVal) {
            int length;
            NumericAttrVal aa2 = (NumericAttrVal)oo;
            if (this.getComponentType() == aa2.getComponentType() && (length = this.getLength()) == aa2.getLength()) {
                int ii = 0;
                while (ii < length) {
                    if (!this.get(ii).equals(aa2.get(ii))) {
                        return false;
                    }
                    ++ii;
                }
                return true;
            }
        }
        return false;
    }

    Object getValue() {
        return Attribute.arrayClone(this.data);
    }

    Object get(int index) {
        return Array.get(this.data, index);
    }

    Number getNumericValue(int index) {
        return (Number)Array.get(this.data, index);
    }

    Number getNumericValue() {
        return this.getNumericValue(0);
    }

    Class getComponentType() {
        return this.data.getClass().getComponentType();
    }

    int getLength() {
        return Array.getLength(this.data);
    }

    void toCdl(StringBuffer buf) {
        int last = Array.getLength(this.data) - 1;
        int ii = 0;
        while (ii <= last) {
            buf.append(Array.get(this.data, ii));
            if (ii < last) {
                buf.append(", ");
            }
            ++ii;
        }
    }
}

