/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import visad.AnimationControl;
import visad.Control;
import visad.DisplayImpl;
import visad.Set;
import visad.UnimplementedException;
import visad.VisADException;

public class AnimationSetControl
extends Control {
    private Set set;
    private transient AnimationControl parent;
    private boolean isManual;

    public AnimationSetControl(DisplayImpl d2, AnimationControl p) {
        super(d2);
        this.parent = p;
        this.set = null;
        this.isManual = false;
    }

    public Set getSet() {
        return this.set;
    }

    public int clipCurrent(int current) throws VisADException {
        if (this.set == null || current >= this.set.getLength()) {
            current = 0;
        } else if (current < 0) {
            current = this.set.getLength() - 1;
        }
        return current;
    }

    public double getValue(int current) throws VisADException {
        int[] indices = new int[]{this.clipCurrent(current)};
        if (this.set == null) {
            return Double.NaN;
        }
        double[][] values = this.set.indexToDouble(indices);
        return values[0][0];
    }

    public int getIndex(double value) throws VisADException {
        if (this.set == null) {
            return 0;
        }
        double[][] values = new double[][]{{value}};
        int[] indices = this.set.doubleToIndex(values);
        return indices[0] < 0 ? 0 : indices[0];
    }

    public void setSet(Set s) throws VisADException, RemoteException {
        this.setSet(s, false);
    }

    public void setSet(Set s, boolean noChange) throws VisADException, RemoteException {
        if (this.set != null && this.set.equals(s) || this.set == null && s == null) {
            return;
        }
        if (noChange) {
            if (this.isManual) {
                return;
            }
        } else {
            this.isManual = true;
        }
        this.set = s;
        if (this.parent != null) {
            this.parent.setCurrent(this.clipCurrent(this.parent.getCurrent()));
        }
        this.changeControl(!noChange);
    }

    public String getSaveString() {
        return null;
    }

    public void setSaveString(String save) throws VisADException, RemoteException {
        throw new UnimplementedException("Cannot setSaveString on this type of control");
    }

    public void syncControl(Control rmt) throws VisADException {
        if (rmt == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(rmt instanceof AnimationSetControl)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + rmt.getClass().getName());
        }
        AnimationSetControl asc = (AnimationSetControl)rmt;
        boolean changeSet = false;
        if (this.set == null) {
            if (asc.set != null) {
                changeSet = true;
            }
        } else if (asc.set == null) {
            changeSet = true;
        } else if (!this.set.equals(asc.set)) {
            changeSet = true;
        }
        if (changeSet) {
            try {
                this.setSet(asc.set);
            }
            catch (RemoteException re) {
                throw new VisADException("Could not set Set: " + re.getMessage());
            }
        }
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        AnimationSetControl asc = (AnimationSetControl)o;
        if (this.set == null) {
            if (asc.set != null) {
                return false;
            }
        } else {
            if (asc.set == null) {
                return false;
            }
            if (!this.set.equals(asc.set)) {
                return false;
            }
        }
        return true;
    }
}

