/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import visad.CoordinateSystem;
import visad.Field;
import visad.FieldException;
import visad.FunctionType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Unit;
import visad.VisADException;

class FieldEnumerator
implements Enumeration {
    Field field;
    int[] index;
    int dimension;
    RealTupleType type;
    CoordinateSystem coordinateSystem;
    RealType[] types;
    Unit[] units;

    FieldEnumerator(Field f) throws VisADException, RemoteException {
        this.field = f;
        if (this.field.getDomainSet() == null) {
            throw new FieldException("FieldImplEnumerator: DomainSet undefined");
        }
        this.index = new int[1];
        this.index[0] = 0;
        this.dimension = this.field.getDomainSet().getDimension();
        this.type = ((FunctionType)this.field.getType()).getDomain();
        this.coordinateSystem = this.type.getCoordinateSystem();
        if (this.coordinateSystem != null) {
            this.coordinateSystem = this.field.getDomainCoordinateSystem();
        }
        this.types = new RealType[this.dimension];
        this.units = this.field.getDomainUnits();
        int j = 0;
        while (j < this.dimension) {
            this.types[j] = (RealType)this.type.getComponent(j);
            ++j;
        }
    }

    public boolean hasMoreElements() {
        try {
            return this.index[0] < this.field.getLength();
        }
        catch (RemoteException e2) {
            return false;
        }
        catch (VisADException e3) {
            return false;
        }
    }

    public Object nextElement() throws NoSuchElementException {
        try {
            if (this.index[0] < this.field.getLength()) {
                float[][] vals = this.field.getDomainSet().indexToValue(this.index);
                this.index[0] = this.index[0] + 1;
                Real[] reals = new Real[this.dimension];
                int j = 0;
                while (j < this.dimension) {
                    reals[j] = new Real(this.types[j], vals[j][0], this.units[j]);
                    ++j;
                }
                return new RealTuple(this.type, reals, this.coordinateSystem);
            }
            throw new NoSuchElementException("FieldImplEnumerator.nextElement: no more elements");
        }
        catch (VisADException e2) {
            throw new NoSuchElementException("FieldImplEnumerator.nextElement: " + e2);
        }
        catch (RemoteException e3) {
            throw new NoSuchElementException("FieldImplEnumerator.nextElement: " + e3);
        }
    }
}

