/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded1DSet;
import visad.GriddedDoubleSet;
import visad.MathType;
import visad.Set;
import visad.SetException;
import visad.Unit;
import visad.VisADException;

public class Gridded1DDoubleSet
extends Gridded1DSet
implements GriddedDoubleSet {
    double[] Low;
    double[] Hi;
    double LowX;
    double HiX;
    double[][] Samples;
    private static final WeakHashMap cache = new WeakHashMap();
    private int ig;

    public Gridded1DDoubleSet(MathType type, float[][] samples, int lengthX) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, null, null, null, true);
    }

    public Gridded1DDoubleSet(MathType type, float[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, coord_sys, units, errors, true);
    }

    public Gridded1DDoubleSet(MathType type, float[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, coord_sys, units, errors, copy);
    }

    public Gridded1DDoubleSet(MathType type, double[][] samples, int lengthX) throws VisADException {
        this(type, samples, lengthX, null, null, null, true);
    }

    public Gridded1DDoubleSet(MathType type, double[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, samples, lengthX, coord_sys, units, errors, true);
    }

    public Gridded1DDoubleSet(MathType type, double[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        block9: {
            super(type, null, lengthX, coord_sys, units, errors, copy);
            this.Low = new double[1];
            this.Hi = new double[1];
            this.ig = -1;
            if (samples == null) {
                throw new SetException("Gridded1DDoubleSet: samples are null");
            }
            this.init_doubles(samples, copy);
            this.LowX = this.Low[0];
            this.HiX = this.Hi[0];
            this.LengthX = this.Lengths[0];
            if (this.Samples == null || this.Lengths[0] <= 1) break block9;
            int i = 0;
            while (i < this.Length) {
                if (this.Samples[0][i] != this.Samples[0][i]) {
                    throw new SetException("Gridded1DDoubleSet: samples values may not be missing");
                }
                ++i;
            }
            boolean bl = this.Ascending = this.Samples[0][this.LengthX - 1] > this.Samples[0][0];
            if (this.Ascending) {
                int i2 = 1;
                while (i2 < this.LengthX) {
                    if (this.Samples[0][i2] < this.Samples[0][i2 - 1]) {
                        throw new SetException("Gridded1DDoubleSet: samples do not form a valid grid (" + i2 + ")");
                    }
                    ++i2;
                }
            } else {
                int i3 = 1;
                while (i3 < this.LengthX) {
                    if (this.Samples[0][i3] > this.Samples[0][i3 - 1]) {
                        throw new SetException("Gridded1DDoubleSet: samples do not form a valid grid (" + i3 + ")");
                    }
                    ++i3;
                }
            }
        }
    }

    public static synchronized Gridded1DDoubleSet create(MathType type, double[] samples, CoordinateSystem coordSys, Unit unit, ErrorEstimate error) throws VisADException {
        Gridded1DDoubleSet newSet = new Gridded1DDoubleSet(type, new double[][]{samples}, samples.length, coordSys, new Unit[]{unit}, new ErrorEstimate[]{error}, false);
        WeakReference ref = (WeakReference)cache.get(newSet);
        if (ref == null) {
            cache.put(newSet, new WeakReference<Gridded1DDoubleSet>(newSet));
        } else {
            Gridded1DDoubleSet oldSet = (Gridded1DDoubleSet)ref.get();
            if (oldSet == null) {
                cache.put(newSet, new WeakReference<Gridded1DDoubleSet>(newSet));
            } else {
                newSet = oldSet;
            }
        }
        return newSet;
    }

    public float[][] getSamples() throws VisADException {
        return this.getSamples(true);
    }

    public float[][] getSamples(boolean copy) throws VisADException {
        return Set.doubleToFloat(this.Samples);
    }

    public float[][] indexToValue(int[] index) throws VisADException {
        return Set.doubleToFloat(this.indexToDouble(index));
    }

    public int[] valueToIndex(float[][] value) throws VisADException {
        return this.doubleToIndex(Set.floatToDouble(value));
    }

    public float[][] gridToValue(float[][] grid) throws VisADException {
        return Set.doubleToFloat(this.gridToDouble(Set.floatToDouble(grid)));
    }

    public float[][] valueToGrid(float[][] value) throws VisADException {
        return Set.doubleToFloat(this.doubleToGrid(Set.floatToDouble(value)));
    }

    public void valueToInterp(float[][] value, int[][] indices, float[][] weights) throws VisADException {
        int len = weights.length;
        double[][] w = new double[len][];
        this.doubleToInterp(Set.floatToDouble(value), indices, w);
        int i = 0;
        while (i < len) {
            if (w[i] != null) {
                weights[i] = new float[w[i].length];
                int j = 0;
                while (j < w[i].length) {
                    weights[i][j] = (float)w[i][j];
                    ++j;
                }
            }
            ++i;
        }
    }

    public float getLowX() {
        return (float)this.LowX;
    }

    public float getHiX() {
        return (float)this.HiX;
    }

    public double[][] getDoubles() throws VisADException {
        return this.getDoubles(true);
    }

    public double[][] getDoubles(boolean copy) throws VisADException {
        return copy ? Set.copyDoubles(this.Samples) : this.Samples;
    }

    public double[][] indexToDouble(int[] index) throws VisADException {
        int length = index.length;
        if (this.Samples == null) {
            double[][] grid = new double[this.ManifoldDimension][length];
            int i = 0;
            while (i < length) {
                grid[0][i] = 0 <= index[i] && index[i] < this.Length ? (double)index[i] : -1.0;
                ++i;
            }
            return this.gridToDouble(grid);
        }
        double[][] values = new double[1][length];
        int i = 0;
        while (i < length) {
            values[0][i] = 0 <= index[i] && index[i] < this.Length ? this.Samples[0][index[i]] : Double.NaN;
            ++i;
        }
        return values;
    }

    public int[] doubleToIndex(double[][] value) throws VisADException {
        if (value.length != this.DomainDimension) {
            throw new SetException("Gridded1DDoubleSet.doubleToIndex: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int length = value[0].length;
        int[] index = new int[length];
        double[][] grid = this.doubleToGrid(value);
        double[] grid0 = grid[0];
        int i = 0;
        while (i < length) {
            double g = grid0[i];
            index[i] = Double.isNaN(g) ? -1 : (int)(g + 0.5);
            ++i;
        }
        return index;
    }

    public double[][] gridToDouble(double[][] grid) throws VisADException {
        if (grid.length < this.DomainDimension) {
            throw new SetException("Gridded1DDoubleSet.gridToDouble: grid dimension " + grid.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        if (this.Lengths[0] < 2) {
            throw new SetException("Gridded1DDoubleSet.gridToDouble: requires all grid dimensions to be > 1");
        }
        int length = grid[0].length;
        double[][] value = new double[1][length];
        int i = 0;
        while (i < length) {
            double g = grid[0][i];
            if (g < -0.5 || g > (double)this.LengthX - 0.5) {
                value[0][i] = Double.NaN;
            } else {
                int ig = g < 0.0 ? 0 : (g >= (double)(this.LengthX - 1) ? this.LengthX - 2 : (int)g);
                double A = g - (double)ig;
                value[0][i] = (1.0 - A) * this.Samples[0][ig] + A * this.Samples[0][ig + 1];
            }
            ++i;
        }
        return value;
    }

    public double[][] doubleToGrid(double[][] value) throws VisADException {
        if (value.length < this.DomainDimension) {
            throw new SetException("Gridded1DDoubleSet.doubleToGrid: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        if (this.Lengths[0] < 2) {
            throw new SetException("Gridded1DDoubleSet.doubleToGrid: requires all grid dimensions to be > 1");
        }
        double[] vals = value[0];
        int length = vals.length;
        double[] samps = this.Samples[0];
        double[][] grid = new double[1][length];
        if (this.ig < 0 || this.ig >= this.LengthX) {
            this.ig = (this.LengthX - 1) / 2;
        }
        int i = 0;
        while (i < length) {
            if (Double.isNaN(vals[i])) {
                grid[0][i] = Double.NaN;
            } else {
                double solv;
                int lower = 0;
                int upper = this.LengthX - 1;
                while (lower < upper) {
                    if ((vals[i] - samps[this.ig]) * (vals[i] - samps[this.ig + 1]) <= 0.0) break;
                    if (this.Ascending ? samps[this.ig + 1] < vals[i] : samps[this.ig + 1] > vals[i]) {
                        lower = this.ig + 1;
                    } else if (this.Ascending ? samps[this.ig] > vals[i] : samps[this.ig] < vals[i]) {
                        upper = this.ig;
                    }
                    if (lower >= upper) continue;
                    this.ig = (lower + upper) / 2;
                }
                if ((solv = (double)this.ig + (vals[i] - samps[this.ig]) / (samps[this.ig + 1] - samps[this.ig])) > -0.5 && solv < (double)this.LengthX - 0.5) {
                    grid[0][i] = solv;
                } else {
                    grid[0][i] = Double.NaN;
                    this.ig = (this.LengthX - 1) / 2;
                }
            }
            ++i;
        }
        return grid;
    }

    public void doubleToInterp(double[][] value, int[][] indices, double[][] weights) throws VisADException {
        if (value.length != this.DomainDimension) {
            throw new SetException("Gridded1DDoubleSet.doubleToInterp: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int length = value[0].length;
        if (indices.length != length) {
            throw new SetException("Gridded1DDoubleinearLatLonSet.doubleToInterp: indices length " + indices.length + " doesn't match value[0] length " + value[0].length);
        }
        if (weights.length != length) {
            throw new SetException("Gridded1DDoubleSet.doubleToInterp: weights length " + weights.length + " doesn't match value[0] length " + value[0].length);
        }
        double[][] grid = this.doubleToGrid(value);
        int[] l = new int[this.ManifoldDimension];
        double[] c2 = new double[this.ManifoldDimension];
        int[] off = new int[this.ManifoldDimension];
        off[0] = 1;
        int j = 1;
        while (j < this.ManifoldDimension) {
            off[j] = off[j - 1] * this.Lengths[j - 1];
            ++j;
        }
        int i = 0;
        while (i < length) {
            double[] cs;
            int[] is;
            int base;
            int length_is = 1;
            if (Double.isNaN(grid[this.ManifoldDimension - 1][i])) {
                base = -1;
            } else {
                l[this.ManifoldDimension - 1] = (int)(grid[this.ManifoldDimension - 1][i] + 0.5);
                if (l[this.ManifoldDimension - 1] == this.Lengths[this.ManifoldDimension - 1]) {
                    int n = this.ManifoldDimension - 1;
                    l[n] = l[n] - 1;
                }
                c2[this.ManifoldDimension - 1] = grid[this.ManifoldDimension - 1][i] - (double)l[this.ManifoldDimension - 1];
                if (!(l[this.ManifoldDimension - 1] == 0 && c2[this.ManifoldDimension - 1] <= 0.0 || l[this.ManifoldDimension - 1] == this.Lengths[this.ManifoldDimension - 1] - 1 && c2[this.ManifoldDimension - 1] >= 0.0)) {
                    length_is *= 2;
                }
                base = l[this.ManifoldDimension - 1];
            }
            j = this.ManifoldDimension - 2;
            while (j >= 0 && base >= 0) {
                if (Double.isNaN(grid[j][i])) {
                    base = -1;
                } else {
                    l[j] = (int)(grid[j][i] + 0.5);
                    if (l[j] == this.Lengths[j]) {
                        int n = j;
                        l[n] = l[n] - 1;
                    }
                    c2[j] = grid[j][i] - (double)l[j];
                    if (!(l[j] == 0 && c2[j] <= 0.0 || l[j] == this.Lengths[j] - 1 && c2[j] >= 0.0)) {
                        length_is *= 2;
                    }
                    base = l[j] + this.Lengths[j] * base;
                }
                --j;
            }
            if (base < 0) {
                is = null;
                cs = null;
            } else {
                is = new int[length_is];
                cs = new double[length_is];
                is[0] = base;
                cs[0] = 1.0;
                int lis = 1;
                j = 0;
                while (j < this.ManifoldDimension) {
                    if (!(l[j] == 0 && c2[j] <= 0.0 || l[j] == this.Lengths[j] - 1 && c2[j] >= 0.0)) {
                        double b2;
                        double a2;
                        int isoff;
                        if (c2[j] >= 0.0) {
                            isoff = off[j];
                            a2 = 1.0 - c2[j];
                            b2 = c2[j];
                        } else {
                            isoff = -off[j];
                            a2 = 1.0 + c2[j];
                            b2 = -c2[j];
                        }
                        int k = 0;
                        while (k < lis) {
                            is[k + lis] = is[k] + isoff;
                            cs[k + lis] = cs[k] * b2;
                            int n = k++;
                            cs[n] = cs[n] * a2;
                        }
                        lis *= 2;
                    }
                    ++j;
                }
            }
            indices[i] = is;
            weights[i] = cs;
            ++i;
        }
    }

    public double getDoubleLowX() {
        return this.LowX;
    }

    public double getDoubleHiX() {
        return this.HiX;
    }

    void init_doubles(double[][] samples, boolean copy) throws VisADException {
        if (samples.length != this.DomainDimension) {
            throw new SetException("Gridded1DDoubleSet.init_doubles: samples dimension " + samples.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        if (this.Length == 0) {
            this.Length = samples[0].length;
        } else if (this.Length != samples[0].length) {
            throw new SetException("Gridded1DDoubleSet.init_doubles: samples[0] length " + samples[0].length + " doesn't match expected length " + this.Length);
        }
        this.Samples = copy ? new double[this.DomainDimension][this.Length] : samples;
        int j = 0;
        while (j < this.DomainDimension) {
            if (samples[j].length != this.Length) {
                throw new SetException("Gridded1DDoubleSet.init_doubles: samples[" + j + "] length " + samples[0].length + " doesn't match expected length " + this.Length);
            }
            double[] samplesJ = samples[j];
            double[] SamplesJ = this.Samples[j];
            if (copy) {
                System.arraycopy(samplesJ, 0, SamplesJ, 0, this.Length);
            }
            this.Low[j] = Double.POSITIVE_INFINITY;
            this.Hi[j] = Double.NEGATIVE_INFINITY;
            double sum = 0.0;
            int i = 0;
            while (i < this.Length) {
                if (SamplesJ[i] == SamplesJ[i] && !Double.isInfinite(SamplesJ[i])) {
                    if (SamplesJ[i] < this.Low[j]) {
                        this.Low[j] = SamplesJ[i];
                    }
                    if (SamplesJ[i] > this.Hi[j]) {
                        this.Hi[j] = SamplesJ[i];
                    }
                } else {
                    SamplesJ[i] = Double.NaN;
                }
                sum += SamplesJ[i];
                ++i;
            }
            if (this.SetErrors[j] != null) {
                this.SetErrors[j] = new ErrorEstimate(this.SetErrors[j].getErrorValue(), sum / (double)this.Length, this.Length, this.SetErrors[j].getUnit());
            }
            ((Gridded1DSet)this).Low[j] = (float)this.Low[j];
            ((Gridded1DSet)this).Hi[j] = (float)this.Hi[j];
            ++j;
        }
    }

    public void cram_missing(boolean[] range_select) {
        int n = Math.min(range_select.length, this.Samples[0].length);
        int i = 0;
        while (i < n) {
            if (!range_select[i]) {
                this.Samples[0][i] = Double.NaN;
            }
            ++i;
        }
    }

    public boolean isMissing() {
        return this.Samples == null;
    }

    public boolean equals(Object set) {
        if (!(set instanceof Gridded1DDoubleSet) || set == null) {
            return false;
        }
        if (this == set) {
            return true;
        }
        if (this.testNotEqualsCache((Set)set)) {
            return false;
        }
        if (this.testEqualsCache((Set)set)) {
            return true;
        }
        if (!this.equalUnitAndCS((Set)set)) {
            return false;
        }
        try {
            if (this.DomainDimension != ((Gridded1DDoubleSet)set).getDimension() || this.ManifoldDimension != ((Gridded1DDoubleSet)set).getManifoldDimension() || this.Length != ((Gridded1DDoubleSet)set).getLength()) {
                return false;
            }
            int j = 0;
            while (j < this.ManifoldDimension) {
                if (this.Lengths[j] != ((Gridded1DDoubleSet)set).getLength(j)) {
                    return false;
                }
                ++j;
            }
            double[][] samples = ((Gridded1DDoubleSet)set).getDoubles(false);
            if (this.Samples != null && samples != null) {
                j = 0;
                while (j < this.DomainDimension) {
                    int i = 0;
                    while (i < this.Length) {
                        if (this.Samples[j][i] != samples[j][i]) {
                            this.addNotEqualsCache((Set)set);
                            return false;
                        }
                        ++i;
                    }
                    ++j;
                }
            } else {
                double[][] this_samples = this.getDoubles(false);
                if (this_samples == null) {
                    if (samples != null) {
                        return false;
                    }
                } else {
                    if (samples == null) {
                        return false;
                    }
                    j = 0;
                    while (j < this.DomainDimension) {
                        int i = 0;
                        while (i < this.Length) {
                            if (this_samples[j][i] != samples[j][i]) {
                                this.addNotEqualsCache((Set)set);
                                return false;
                            }
                            ++i;
                        }
                        ++j;
                    }
                }
            }
            this.addEqualsCache((Set)set);
            return true;
        }
        catch (VisADException e2) {
            return false;
        }
    }

    public int hashCode() {
        if (!this.hashCodeSet) {
            this.hashCode = this.unitAndCSHashCode();
            this.hashCode ^= this.DomainDimension ^ this.ManifoldDimension ^ this.Length;
            int j = 0;
            while (j < this.ManifoldDimension) {
                this.hashCode ^= this.Lengths[j];
                ++j;
            }
            if (this.Samples != null) {
                int j2 = 0;
                while (j2 < this.DomainDimension) {
                    int i = 0;
                    while (i < this.Length) {
                        this.hashCode ^= new Double(this.Samples[j2][i]).hashCode();
                        ++i;
                    }
                    ++j2;
                }
            }
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }

    public Object clone() {
        Gridded1DDoubleSet clone = (Gridded1DDoubleSet)super.clone();
        if (this.Samples != null) {
            clone.Samples = (double[][])this.Samples.clone();
            int i = 0;
            while (i < this.Samples.length) {
                clone.Samples[i] = (double[])this.Samples[i].clone();
                ++i;
            }
        }
        return clone;
    }

    public Object cloneButType(MathType type) throws VisADException {
        return new Gridded1DDoubleSet(type, this.Samples, this.Length, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }
}

