/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded2DSet;
import visad.Linear1DSet;
import visad.LinearNDSet;
import visad.LinearSet;
import visad.MathType;
import visad.RealTupleType;
import visad.Set;
import visad.SetException;
import visad.Unit;
import visad.VisADException;

public class Linear2DSet
extends Gridded2DSet
implements LinearSet {
    Linear1DSet X;
    Linear1DSet Y;
    private boolean cacheSamples;

    public Linear2DSet(Linear1DSet[] sets) throws VisADException {
        this((MathType)RealTupleType.Generic2D, sets, null, null, null);
    }

    public Linear2DSet(MathType type, Linear1DSet[] sets) throws VisADException {
        this(type, sets, null, null, null);
    }

    public Linear2DSet(double first1, double last1, int length1, double first2, double last2, int length2) throws VisADException {
        this((MathType)RealTupleType.Generic2D, LinearNDSet.get_linear1d_array(RealTupleType.Generic2D, first1, last1, length1, first2, last2, length2, null), null, null, null);
    }

    public Linear2DSet(MathType type, double first1, double last1, int length1, double first2, double last2, int length2) throws VisADException {
        this(type, LinearNDSet.get_linear1d_array(type, first1, last1, length1, first2, last2, length2, null), null, null, null);
    }

    public Linear2DSet(MathType type, double first1, double last1, int length1, double first2, double last2, int length2, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, first1, last1, length1, first2, last2, length2, coord_sys, units, errors, false);
    }

    public Linear2DSet(MathType type, double first1, double last1, int length1, double first2, double last2, int length2, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean cache) throws VisADException {
        this(type, LinearNDSet.get_linear1d_array(type, first1, last1, length1, first2, last2, length2, units), coord_sys, units, errors, cache);
    }

    public Linear2DSet(MathType type, Linear1DSet[] sets, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, sets, coord_sys, units, errors, false);
    }

    public Linear2DSet(MathType type, Linear1DSet[] sets, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean cache) throws VisADException {
        super(type, (float[][])null, sets[0].getLength(), sets[1].getLength(), coord_sys, LinearNDSet.units_array_linear1d(sets, units), errors);
        if (this.DomainDimension != 2) {
            throw new SetException("Linear2DSet: DomainDimension must be 2, not " + this.DomainDimension);
        }
        if (sets.length != 2) {
            throw new SetException("Linear2DSet: ManifoldDimension must be 2, not " + sets.length);
        }
        Linear1DSet[] ss = LinearNDSet.linear1d_array_units(sets, units);
        this.X = ss[0];
        this.Y = ss[1];
        this.LengthX = this.X.getLength();
        this.LengthY = this.Y.getLength();
        this.Length = this.LengthX * this.LengthY;
        this.Low[0] = this.X.getLowX();
        this.Hi[0] = this.X.getHiX();
        this.Low[1] = this.Y.getLowX();
        this.Hi[1] = this.Y.getHiX();
        if (this.SetErrors[0] != null) {
            this.SetErrors[0] = new ErrorEstimate(this.SetErrors[0].getErrorValue(), (double)(this.Low[0] + this.Hi[0]) / 2.0, this.Length, this.SetErrors[0].getUnit());
        }
        if (this.SetErrors[1] != null) {
            this.SetErrors[1] = new ErrorEstimate(this.SetErrors[1].getErrorValue(), (double)(this.Low[1] + this.Hi[1]) / 2.0, this.Length, this.SetErrors[1].getUnit());
        }
        this.cacheSamples = cache;
    }

    public float[][] indexToValue(int[] index) throws VisADException {
        int length = index.length;
        int[] indexX = new int[length];
        int[] indexY = new int[length];
        float[][] values = new float[2][];
        int i = 0;
        while (i < length) {
            if (0 <= index[i] && index[i] < this.Length) {
                indexX[i] = index[i] % this.LengthX;
                indexY[i] = index[i] / this.LengthX;
            } else {
                indexX[i] = -1;
                indexY[i] = -1;
            }
            ++i;
        }
        float[][] valuesX = this.X.indexToValue(indexX);
        float[][] valuesY = this.Y.indexToValue(indexY);
        values[0] = valuesX[0];
        values[1] = valuesY[0];
        return values;
    }

    public float[][] gridToValue(float[][] grid) throws VisADException {
        if (grid.length != this.ManifoldDimension) {
            throw new SetException("Linear2DSet.gridToValue: grid dimension " + grid.length + " not equal to Manifold dimension " + this.ManifoldDimension);
        }
        if (this.ManifoldDimension != 2) {
            throw new SetException("Linear2DSet.gridToValue: Manifold dimension must be 2, not " + this.ManifoldDimension);
        }
        if (this.Lengths[0] < 2 || this.Lengths[1] < 2) {
            throw new SetException("Linear2DSet.gridToValue: requires all grid dimensions to be > 1");
        }
        int length = grid[0].length;
        float[][] gridX = new float[][]{grid[0]};
        float[][] gridY = new float[][]{grid[1]};
        float[][] valueX = this.X.gridToValue(gridX);
        float[][] valueY = this.Y.gridToValue(gridY);
        float[][] value = new float[][]{valueX[0], valueY[0]};
        return value;
    }

    public float[][] valueToGrid(float[][] value) throws VisADException {
        if (value.length != 2) {
            throw new SetException("Linear2DSet.valueToGrid: value dimension must be 2, not " + value.length);
        }
        if (this.Lengths[0] < 2 || this.Lengths[1] < 2) {
            throw new SetException("Linear2DSet.valueToGrid: requires all grid dimensions to be > 1");
        }
        int length = value[0].length;
        float[][] valueX = new float[][]{value[0]};
        float[][] valueY = new float[][]{value[1]};
        float[][] gridX = this.X.valueToGrid(valueX);
        float[][] gridY = this.Y.valueToGrid(valueY);
        float[][] grid = new float[][]{gridX[0], gridY[0]};
        return grid;
    }

    public Linear1DSet getX() {
        return this.X;
    }

    public Linear1DSet getY() {
        return this.Y;
    }

    public boolean isMissing() {
        return false;
    }

    public float[][] getSamples(boolean copy) throws VisADException {
        if (this.Samples != null) {
            return copy ? Set.copyFloats(this.Samples) : this.Samples;
        }
        float[][] samples = this.makeSamples();
        if (this.cacheSamples) {
            this.Samples = samples;
            return copy ? Set.copyFloats(this.Samples) : this.Samples;
        }
        return samples;
    }

    private float[][] makeSamples() throws VisADException {
        float[][] xVals = this.X.getSamples(false);
        float[][] yVals = this.Y.getSamples(false);
        float[][] samples = new float[2][this.getLength()];
        int idx = 0;
        int j = 0;
        while (j < yVals[0].length) {
            int i = 0;
            while (i < xVals[0].length) {
                samples[0][idx] = xVals[0][i];
                samples[1][idx] = yVals[0][j];
                ++idx;
                ++i;
            }
            ++j;
        }
        return samples;
    }

    public boolean equals(Object set) {
        if (!(set instanceof Linear2DSet) || set == null) {
            return false;
        }
        if (this == set) {
            return true;
        }
        if (!this.equalUnitAndCS((Set)set)) {
            return false;
        }
        return this.X.equals(((Linear2DSet)set).getX()) && this.Y.equals(((Linear2DSet)set).getY());
    }

    public int hashCode() {
        if (!this.hashCodeSet) {
            this.hashCode = this.unitAndCSHashCode() ^ this.X.hashCode() ^ this.Y.hashCode();
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }

    public Linear1DSet getLinear1DComponent(int i) {
        if (i == 0) {
            return this.getX();
        }
        if (i == 1) {
            return this.getY();
        }
        if (i < 0) {
            throw new ArrayIndexOutOfBoundsException("Negative component index " + i);
        }
        throw new ArrayIndexOutOfBoundsException("Component index " + i + " must be less than 2");
    }

    public Object cloneButType(MathType type) throws VisADException {
        Linear1DSet[] sets = new Linear1DSet[]{(Linear1DSet)this.X.clone(), (Linear1DSet)this.Y.clone()};
        return new Linear2DSet(type, sets, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors, this.cacheSamples);
    }

    public String longString(String pre) throws VisADException {
        String s = pre + "Linear2DSet: Length = " + this.Length + "\n";
        s = s + pre + "  Dimension 1: Length = " + this.X.getLength() + " Range = " + this.X.getFirst() + " to " + this.X.getLast() + "\n";
        s = s + pre + "  Dimension 2: Length = " + this.Y.getLength() + " Range = " + this.Y.getFirst() + " to " + this.Y.getLast() + "\n";
        return s;
    }
}

