/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.MathType;
import visad.Set;
import visad.SetException;
import visad.SimpleSet;
import visad.UnimplementedException;
import visad.Unit;
import visad.VisADException;

public class List1DSet
extends SimpleSet {
    float[] data;

    public List1DSet(float[] d2, MathType type, CoordinateSystem coord_sys, Unit[] units) throws VisADException {
        super(type, coord_sys, units, null);
        if (this.DomainDimension != 1) {
            throw new SetException("List1DSet: type must be 1-D");
        }
        this.data = d2;
        this.Length = d2.length;
    }

    public boolean isMissing() {
        return this.data == null;
    }

    public float[][] indexToValue(int[] index) throws VisADException {
        int length = index.length;
        float[][] value = new float[1][length];
        int i = 0;
        while (i < length) {
            if (index[i] < 0 || index[i] >= this.Length) {
                int k = 0;
                while (k < this.DomainDimension) {
                    value[k][i] = Float.NaN;
                    ++k;
                }
            } else {
                value[0][i] = this.data[index[i]];
            }
            ++i;
        }
        return value;
    }

    public int[] valueToIndex(float[][] value) throws VisADException {
        throw new UnimplementedException("List1DSet.valueToIndex");
    }

    public void valueToInterp(float[][] value, int[][] indices, float[][] weights) throws VisADException {
        throw new UnimplementedException("List1DSet.valueToInterpx");
    }

    public boolean equals(Object set) {
        if (!(set instanceof List1DSet) || set == null) {
            return false;
        }
        if (this == set) {
            return true;
        }
        if (!this.equalUnitAndCS((Set)set)) {
            return false;
        }
        if (this.Length != ((Set)set).Length) {
            return false;
        }
        int i = 0;
        while (i < this.Length) {
            if (Float.floatToIntBits(this.data[i]) != Float.floatToIntBits(((List1DSet)set).data[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        if (!this.hashCodeSet) {
            this.hashCode = this.unitAndCSHashCode() ^ this.Length;
            int i = 0;
            while (i < this.Length) {
                this.hashCode ^= Float.floatToIntBits(this.data[i]);
                ++i;
            }
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }

    public Object cloneButType(MathType type) throws VisADException {
        return new List1DSet(this.data, type, this.DomainCoordinateSystem, this.SetUnits);
    }

    public String longString(String pre) throws VisADException {
        return pre + "List1DSet";
    }
}

