/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded2DSet;
import visad.GriddedSet;
import visad.Irregular1DSet;
import visad.Irregular3DSet;
import visad.IrregularSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.UnimplementedException;
import visad.UnionSet;
import visad.Unit;
import visad.VisADException;

public class ProductSet
extends SampledSet {
    SampledSet[] Sets;

    public ProductSet(SampledSet[] sets) throws VisADException {
        this(ProductSet.makeType(sets), sets, null, null, null, true);
    }

    public ProductSet(MathType type, SampledSet[] sets) throws VisADException {
        this(type, sets, null, null, null, true);
    }

    public ProductSet(MathType type, SampledSet[] sets, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, sets, coord_sys, units, errors, true);
    }

    ProductSet(MathType type, SampledSet[] sets, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        super(type, ProductSet.find_manifold_dim(sets, units), coord_sys, units, errors);
        int i;
        int dim = 0;
        int i2 = 0;
        while (i2 < sets.length) {
            dim += sets[i2].DomainDimension;
            ++i2;
        }
        if (dim != this.DomainDimension) {
            throw new SetException("ProductSet: DomainDimension does not match");
        }
        if (copy) {
            this.Sets = new SampledSet[sets.length];
            i = 0;
            while (i < sets.length) {
                this.Sets[i] = (SampledSet)sets[i].clone();
                ++i;
            }
        } else {
            this.Sets = sets;
        }
        this.Length = 1;
        i = 0;
        while (i < sets.length) {
            this.Length *= sets[i].Length;
            ++i;
        }
        this.Low = new float[this.DomainDimension];
        this.Hi = new float[this.DomainDimension];
        int base = 0;
        int i3 = 0;
        while (i3 < sets.length) {
            float[] low = sets[i3].getLow();
            float[] hi = sets[i3].getHi();
            int set_dim = sets[i3].getDimension();
            int j = 0;
            while (j < set_dim) {
                this.Low[base + j] = low[j];
                this.Hi[base + j] = hi[j];
                ++j;
            }
            base += set_dim;
            ++i3;
        }
    }

    public SampledSet[] getSets() {
        return (SampledSet[])this.Sets.clone();
    }

    private static int find_manifold_dim(SampledSet[] sets, Unit[] units) throws VisADException {
        if (sets == null || sets[0] == null) {
            throw new SetException("ProductSet: Sets cannot be missing");
        }
        if (sets.length < 2) {
            throw new SetException("ProductSet: must be at least 2 sets");
        }
        int manifold_dim = 0;
        int dim = 0;
        int i = 0;
        while (i < sets.length) {
            if (units != null) {
                int n = sets[i].getDimension();
                if (dim + n > units.length) {
                    throw new SetException("ProductSet: Sets exceed ManifoldDimension " + units.length);
                }
                Unit[] su = sets[i].getSetUnits();
                if (su == null) {
                    throw new SetException("ProductSet: Set#" + i + " is null");
                }
                int j = 0;
                while (j < n) {
                    if (!(units[dim + j] == null && su[j] == null || units[dim + j] != null && su[j] != null && units[dim + j].equals(su[j]))) {
                        throw new SetException("ProductSet: Expected set " + i + ", element " + j + " units to be " + units[dim + j] + " not " + su[j]);
                    }
                    ++j;
                }
            }
            dim += sets[i].getDimension();
            manifold_dim += sets[i].getManifoldDimension();
            ++i;
        }
        return manifold_dim;
    }

    static MathType makeType(SampledSet[] sets) throws VisADException {
        int n = sets.length;
        RealTupleType[] types = new RealTupleType[n];
        int count = 0;
        int i = 0;
        while (i < n) {
            types[i] = ((SetType)sets[i].getType()).getDomain();
            count += types[i].getDimension();
            ++i;
        }
        RealType[] reals = new RealType[count];
        int k = 0;
        int i2 = 0;
        while (i2 < n) {
            int j = 0;
            while (j < types[i2].getDimension()) {
                reals[k++] = (RealType)types[i2].getComponent(j);
                ++j;
            }
            ++i2;
        }
        return new SetType(new RealTupleType(reals));
    }

    public SampledSet product() throws VisADException {
        int n = this.Sets.length;
        SampledSet[] sets = new SampledSet[n];
        int i = 0;
        while (i < n) {
            if (this.Sets[i] instanceof GriddedSet || this.Sets[i] instanceof IrregularSet) {
                sets[i] = this.Sets[i];
            } else if (this.Sets[i] instanceof ProductSet) {
                sets[i] = ((ProductSet)this.Sets[i]).product();
            } else if (this.Sets[i] instanceof UnionSet) {
                sets[i] = ((UnionSet)this.Sets[i]).product();
            } else {
                throw new UnimplementedException("ProductSet.product: " + this.Sets[i].getClass());
            }
            ++i;
        }
        SampledSet prod = sets[0];
        int i2 = 1;
        while (i2 < n) {
            prod = prod instanceof ProductSet ? ((ProductSet)prod).product(sets[i2]) : (prod instanceof UnionSet ? ((UnionSet)prod).product(sets[i2]) : (sets[i2] instanceof ProductSet ? ((ProductSet)sets[i2]).inverseProduct(prod) : (sets[i2] instanceof UnionSet ? ((UnionSet)sets[i2]).inverseProduct(prod) : new ProductSet(new SampledSet[]{prod, sets[i2]}))));
            ++i2;
        }
        return prod;
    }

    public SampledSet product(SampledSet set) throws VisADException {
        int n = this.Sets.length;
        if (set instanceof ProductSet) {
            int m = ((ProductSet)set).Sets.length;
            SampledSet[] sets = new SampledSet[n + m];
            int i = 0;
            while (i < n) {
                sets[i] = this.Sets[i];
                ++i;
            }
            int j = 0;
            while (j < m) {
                sets[n + j] = ((ProductSet)set).Sets[j];
                ++j;
            }
            return new ProductSet(sets);
        }
        if (set instanceof UnionSet) {
            int m = ((UnionSet)set).Sets.length;
            SampledSet[] sets = new SampledSet[m];
            int j = 0;
            while (j < m) {
                sets[j] = this.product(((UnionSet)set).Sets[j]);
                ++j;
            }
            return new UnionSet(sets);
        }
        SampledSet[] sets = new SampledSet[n + 1];
        int i = 0;
        while (i < n) {
            sets[i] = this.Sets[i];
            ++i;
        }
        sets[n] = set;
        return new ProductSet(sets);
    }

    public SampledSet inverseProduct(SampledSet set) throws VisADException {
        int n = this.Sets.length;
        if (set instanceof ProductSet) {
            int m = ((ProductSet)set).Sets.length;
            SampledSet[] sets = new SampledSet[n + m];
            int j = 0;
            while (j < m) {
                sets[j] = ((ProductSet)set).Sets[j];
                ++j;
            }
            int i = 0;
            while (i < n) {
                sets[m + i] = this.Sets[i];
                ++i;
            }
            return new ProductSet(sets);
        }
        if (set instanceof UnionSet) {
            int m = ((UnionSet)set).Sets.length;
            SampledSet[] sets = new SampledSet[m];
            int j = 0;
            while (j < m) {
                sets[j] = this.inverseProduct(((UnionSet)set).Sets[j]);
                ++j;
            }
            return new UnionSet(sets);
        }
        SampledSet[] sets = new SampledSet[n + 1];
        sets[0] = set;
        int i = 0;
        while (i < n) {
            sets[i + 1] = this.Sets[i];
            ++i;
        }
        return new ProductSet(sets);
    }

    public Set makeSpatial(SetType type, float[][] samples) throws VisADException {
        int n = this.Sets.length;
        int dim = samples.length;
        if (dim != this.DomainDimension || dim != 3) {
            throw new SetException("ProductSet.makeSpatial: samples bad dimension");
        }
        try {
            boolean any_product_or_union = false;
            int i = 0;
            while (i < n) {
                if (this.Sets[i] instanceof ProductSet || this.Sets[i] instanceof UnionSet) {
                    any_product_or_union = true;
                }
                ++i;
            }
            if (any_product_or_union) {
                return this.product().makeSpatial(type, samples);
            }
            boolean all_gridded = true;
            int[] lengths = new int[this.ManifoldDimension];
            int k = 0;
            int i2 = 0;
            while (i2 < n) {
                if (!(this.Sets[i2] instanceof GriddedSet)) {
                    all_gridded = false;
                    break;
                }
                int[] ls = ((GriddedSet)this.Sets[i2]).getLengths();
                int j = 0;
                while (j < ls.length) {
                    lengths[k++] = ls[j];
                    ++j;
                }
                ++i2;
            }
            if (all_gridded) {
                return GriddedSet.create(type, samples, lengths);
            }
            throw new UnimplementedException("ProductSet.makeSpatial");
        }
        catch (VisADException e2) {
            return new Irregular3DSet((MathType)type, samples, null, null, null, null, false);
        }
    }

    public float[][] getSamples(boolean copy) throws VisADException {
        int n = this.getLength();
        int[] indices = new int[n];
        int i = 0;
        while (i < n) {
            indices[i] = i;
            ++i;
        }
        return this.indexToValue(indices);
    }

    public float[][] indexToValue(int[] index) throws VisADException {
        int i;
        int nsets = this.Sets.length;
        int npts = index.length;
        int[][] indices = new int[nsets][npts];
        float[][] value = new float[this.DomainDimension][];
        int j = 0;
        while (j < npts) {
            int num = index[j];
            i = 0;
            while (i < nsets) {
                indices[i][j] = num % this.Sets[i].Length;
                num /= this.Sets[i].Length;
                ++i;
            }
            ++j;
        }
        int curdim = 0;
        i = 0;
        while (i < nsets) {
            float[][] temp_vals = this.Sets[i].indexToValue(indices[i]);
            int k = 0;
            while (k < temp_vals.length) {
                value[curdim++] = temp_vals[k];
                ++k;
            }
            ++i;
        }
        return value;
    }

    public int[] valueToIndex(float[][] value) throws VisADException {
        int nsets = this.Sets.length;
        int npts = value[0].length;
        int[] index = new int[npts];
        float[][][] vals = new float[nsets][][];
        int curdim = 0;
        int[][] temp_inds = new int[nsets][];
        int i = 0;
        while (i < nsets) {
            vals[i] = new float[this.Sets[i].DomainDimension][];
            int k = 0;
            while (k < this.Sets[i].DomainDimension) {
                vals[i][k] = value[curdim++];
                ++k;
            }
            temp_inds[i] = this.Sets[i].valueToIndex(vals[i]);
            ++i;
        }
        int j = 0;
        while (j < npts) {
            int ind_j = 0;
            int num = 1;
            int i2 = 0;
            while (i2 < nsets) {
                ind_j += temp_inds[i2][j] * num;
                num *= this.Sets[i2].Length;
                ++i2;
            }
            index[j] = ind_j;
            ++j;
        }
        return index;
    }

    public void valueToInterp(float[][] value, int[][] indices, float[][] weights) throws VisADException {
        int nsets = this.Sets.length;
        int npts = value[0].length;
        float[][][] vals = new float[nsets][][];
        int curdim = 0;
        int[][][] temp_inds = new int[nsets][npts][];
        float[][][] temp_wgts = new float[nsets][npts][];
        int i = 0;
        while (i < nsets) {
            vals[i] = new float[this.Sets[i].DomainDimension][];
            int k = 0;
            while (k < this.Sets[i].DomainDimension) {
                vals[i][k] = value[curdim++];
                ++k;
            }
            this.Sets[i].valueToInterp(vals[i], temp_inds[i], temp_wgts[i]);
            ++i;
        }
        int j = 0;
        while (j < npts) {
            int[] ptr = new int[nsets];
            int num_inds = 1;
            int i2 = 0;
            while (i2 < nsets) {
                ptr[i2] = 0;
                num_inds *= temp_inds[i2][j].length;
                ++i2;
            }
            indices[j] = new int[num_inds];
            weights[j] = new float[num_inds];
            int ind_num = 0;
            while (ptr[0] < temp_inds[0][j].length) {
                int ind_j = 0;
                float wgt_j = 1.0f;
                int num = 1;
                int i3 = 0;
                while (i3 < nsets) {
                    ind_j += temp_inds[i3][j][ptr[i3]] * num;
                    wgt_j *= temp_wgts[i3][j][ptr[i3]];
                    num *= this.Sets[i3].Length;
                    ++i3;
                }
                indices[j][ind_num] = ind_j;
                weights[j][ind_num] = wgt_j;
                ++ind_num;
                int n = nsets - 1;
                ptr[n] = ptr[n] + 1;
                int i4 = nsets - 2;
                while (i4 >= 0) {
                    if (ptr[i4 + 1] >= temp_inds[i4 + 1][j].length) {
                        ptr[i4 + 1] = 0;
                        int n2 = i4;
                        ptr[n2] = ptr[n2] + 1;
                    } else {
                        i4 = 0;
                    }
                    --i4;
                }
            }
            ++j;
        }
    }

    public Object clone() {
        ProductSet clone = (ProductSet)super.clone();
        if (this.Sets != null) {
            clone.Sets = new SampledSet[this.Sets.length];
            int i = 0;
            while (i < this.Sets.length) {
                clone.Sets[i] = (SampledSet)this.Sets[i].clone();
                ++i;
            }
        }
        return clone;
    }

    public Object cloneButType(MathType type) throws VisADException {
        return new ProductSet(type, this.Sets, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }

    public boolean equals(Object set) {
        if (!(set instanceof ProductSet) || set == null) {
            return false;
        }
        if (this == set) {
            return true;
        }
        ProductSet pset = (ProductSet)set;
        if (pset.DomainDimension != this.DomainDimension || pset.ManifoldDimension != this.ManifoldDimension) {
            return false;
        }
        int i = 0;
        while (i < this.Sets.length) {
            if (!this.Sets[i].equals(pset.Sets[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        if (!this.hashCodeSet) {
            int i = 0;
            while (i < this.Sets.length) {
                this.hashCode ^= this.Sets[i].hashCode();
                ++i;
            }
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }

    public boolean isMissing() {
        int i = 0;
        while (i < this.Sets.length) {
            if (this.Sets[i].isMissing()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String longString(String pre) throws VisADException {
        return pre + "ProductSet: Dimension = " + this.DomainDimension + "\n";
    }

    public static void main(String[] argv) throws VisADException {
        RealType vis_xcoord = RealType.getRealType("x");
        RealType vis_ycoord = RealType.getRealType("y");
        RealType[] vis_arrayG = new RealType[]{vis_xcoord, vis_ycoord};
        RealTupleType vis_tupleG = new RealTupleType(vis_arrayG);
        float[][] sampG = new float[][]{{12.5f, 26.5f, 29.74f, 36.78f, 52.12f, 67.8f, 87.8f, 97.2f}, {34.2f, 36.2f, 37.2f, 32.6f, 70.87f, 73.49f, 80.32f, 77.24f}};
        Gridded2DSet gSet = new Gridded2DSet((MathType)vis_tupleG, sampG, 4, 2);
        RealType[] vis_arrayI = new RealType[]{vis_xcoord};
        RealTupleType vis_tupleI = new RealTupleType(vis_arrayI);
        float[][] sampI = new float[][]{{-874.0f, 345.0f, -102.0f, 902.0f, -769.0f, 96.0f}};
        Irregular1DSet iSet = new Irregular1DSet((MathType)vis_tupleI, sampI);
        RealType[] vis_arrayP = new RealType[]{vis_xcoord, vis_ycoord, vis_xcoord};
        RealTupleType vis_tupleP = new RealTupleType(vis_arrayP);
        SampledSet[] sets = new SampledSet[]{gSet, iSet};
        ProductSet pSet = new ProductSet((MathType)vis_tupleP, sets);
        System.out.println("ProductSet created.");
        System.out.println("ManifoldDimension = " + pSet.getManifoldDimension());
        System.out.println("-----------------");
        System.out.println("indexToValue test:");
        int[] index1 = new int[]{0, 3, 6, 9, 12, 15, 18, 21};
        float[][] value1 = pSet.indexToValue(index1);
        int i = 0;
        while (i < index1.length) {
            System.out.print("index " + index1[i] + " \t==> (" + value1[0][i]);
            int j = 1;
            while (j < value1.length) {
                System.out.print(", " + value1[j][i]);
                ++j;
            }
            System.out.println(")");
            ++i;
        }
        System.out.println("-----------------");
        System.out.println("valueToIndex test:");
        float[][] value2 = new float[][]{{10.0f, 40.0f, 90.0f, 25.0f, 50.0f, 100.0f, 30.0f, 70.0f}, {35.0f, 30.0f, 80.0f, 35.0f, 70.0f, 75.0f, 36.0f, 75.0f}, {-880.0f, -890.0f, -870.0f, 350.0f, 340.0f, 360.0f, -100.0f, -110.0f}};
        int[] index2 = pSet.valueToIndex(value2);
        int i2 = 0;
        while (i2 < index2.length) {
            System.out.print("(" + value2[0][i2]);
            int j = 1;
            while (j < value2.length) {
                System.out.print(", " + value2[j][i2]);
                ++j;
            }
            System.out.println(")\t==> index " + index2[i2]);
            ++i2;
        }
        System.out.println("------------------");
        System.out.println("valueToInterp test:");
        float[][] value3 = new float[][]{{15.0f, 50.0f, 80.0f, 25.0f, 50.0f, 100.0f, 30.0f, 70.0f}, {45.0f, 40.0f, 70.0f, 35.0f, 70.0f, 75.0f, 36.0f, 65.0f}, {-800.0f, -750.0f, -810.0f, 300.0f, 245.0f, 200.0f, -150.0f, -120.0f}};
        int[][] indexI = new int[value3[0].length][];
        float[][] weightI = new float[value3[0].length][];
        pSet.valueToInterp(value3, indexI, weightI);
        int l = 0;
        while (l < value3[0].length) {
            System.out.print("(" + value3[0][l]);
            int k = 1;
            while (k < value3.length) {
                System.out.print(", " + value3[k][l]);
                ++k;
            }
            System.out.print(")\t==> indices [" + indexI[l][0]);
            int k2 = 1;
            while (k2 < indexI[l].length) {
                System.out.print(", " + indexI[l][k2]);
                ++k2;
            }
            System.out.print("], ");
            System.out.print(" weight total = ");
            float wtotal = 0.0f;
            int k3 = 0;
            while (k3 < weightI[l].length) {
                wtotal += weightI[l][k3];
                ++k3;
            }
            System.out.println(wtotal);
            ++l;
        }
        System.out.println();
    }
}

