/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Vector;
import visad.ConstantMap;
import visad.DataDisplayLink;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.RemoteDataReference;
import visad.RemoteDataReferenceImpl;
import visad.RemoteReferenceLink;
import visad.VisADException;

public class RemoteReferenceLinkImpl
extends UnicastRemoteObject
implements RemoteReferenceLink {
    DataDisplayLink link;

    public RemoteReferenceLinkImpl(DataDisplayLink ddl) throws RemoteException {
        if (ddl == null) {
            throw new RemoteException("Cannot link to null link");
        }
        DataReference ref = ddl.getDataReference();
        if (!(ref instanceof DataReferenceImpl)) {
            throw new RemoteException("Cannot link to non-DataReferenceImpl (" + ref.getClass().getName() + ")");
        }
        this.link = ddl;
    }

    public String getRendererClassName() throws VisADException, RemoteException {
        if (this.link == null) {
            return null;
        }
        DataRenderer rend = this.link.getRenderer();
        if (rend == null) {
            return null;
        }
        return rend.getClass().getName();
    }

    public RemoteDataReference getReference() throws VisADException, RemoteException {
        DataReferenceImpl di = (DataReferenceImpl)this.link.getDataReference();
        return new RemoteDataReferenceImpl(di);
    }

    public Vector getConstantMapVector() throws VisADException, RemoteException {
        return this.link.getConstantMaps();
    }

    public boolean equals(Object o) {
        boolean result;
        if (!(o instanceof RemoteReferenceLink)) {
            return false;
        }
        if (o instanceof RemoteReferenceLinkImpl) {
            RemoteReferenceLinkImpl rrli = (RemoteReferenceLinkImpl)o;
            result = this.link.equals(rrli.link);
        } else {
            RemoteReferenceLink rrl = (RemoteReferenceLink)o;
            try {
                result = this.getReference().equals(rrl.getReference());
            }
            catch (Exception e2) {
                result = false;
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer buf;
        block9: {
            buf = new StringBuffer();
            try {
                if (this.link == null) {
                    buf.append("<null>");
                } else {
                    buf.append(this.link.getDataReference().getName());
                }
                buf.append(" -> ");
                buf.append(this.getRendererClassName());
            }
            catch (RemoteException e2) {
                return null;
            }
            catch (VisADException e3) {
                return null;
            }
            try {
                Vector v = this.getConstantMapVector();
                Enumeration e4 = v.elements();
                if (!e4.hasMoreElements()) break block9;
                buf.append(':');
                while (e4.hasMoreElements()) {
                    ConstantMap cm = (ConstantMap)e4.nextElement();
                    buf.append(" [");
                    buf.append(cm.getConstant());
                    buf.append(" -> ");
                    buf.append(cm.getDisplayScalar());
                    buf.append(']');
                }
            }
            catch (RemoteException e5) {
            }
            catch (VisADException e6) {}
        }
        return buf.toString();
    }
}

