/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.MediaTracker;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import visad.Display;
import visad.DisplayEvent;
import visad.DisplayListener;
import visad.RemoteDisplay;
import visad.RemoteSlaveDisplay;
import visad.VisADException;
import visad.browser.Convert;

public class RemoteSlaveDisplayImpl
extends UnicastRemoteObject
implements RemoteSlaveDisplay,
MouseListener,
MouseMotionListener {
    private RemoteDisplay display;
    private BufferedImage image;
    private JComponent component;
    private Vector listen = new Vector();

    public RemoteSlaveDisplayImpl(RemoteDisplay d2) throws VisADException, RemoteException {
        this.display = d2;
        if (this.display != null) {
            this.display.addSlave(this);
        }
        this.component = new JComponent(){

            public void paint(Graphics g) {
                if (RemoteSlaveDisplayImpl.this.image != null) {
                    g.drawImage(RemoteSlaveDisplayImpl.this.image, 0, 0, this);
                }
            }

            public Dimension getPreferredSize() {
                if (RemoteSlaveDisplayImpl.this.image == null) {
                    return new Dimension(256, 256);
                }
                return new Dimension(RemoteSlaveDisplayImpl.this.image.getWidth(), RemoteSlaveDisplayImpl.this.image.getHeight());
            }
        };
        this.component.addMouseListener(this);
        this.component.addMouseMotionListener(this);
    }

    public void unlink() throws VisADException, RemoteException {
        this.display.removeSlave(this);
    }

    public JComponent getComponent() {
        return this.component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDisplayListener(DisplayListener l) {
        Vector vector = this.listen;
        synchronized (vector) {
            this.listen.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDisplayListener(DisplayListener l) {
        Vector vector = this.listen;
        synchronized (vector) {
            this.listen.remove(l);
        }
    }

    public BufferedImage getImage() {
        return this.image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendImage(int[] pixels, int width, int height, int type) throws RemoteException {
        int[] decoded = Convert.decodeRLE(pixels);
        BufferedImage img = new BufferedImage(width, height, type);
        img.setRGB(0, 0, width, height, decoded, 0, width);
        MediaTracker mt = new MediaTracker(this.component);
        mt.addImage(this.image, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException exc) {
            // empty catch block
        }
        this.image = img;
        this.component.repaint();
        DisplayEvent e2 = new DisplayEvent(this.display, 3);
        Vector vector = this.listen;
        synchronized (vector) {
            int i = 0;
            while (i < this.listen.size()) {
                DisplayListener l = (DisplayListener)this.listen.elementAt(i);
                try {
                    l.displayChanged(e2);
                }
                catch (VisADException exc) {
                    exc.printStackTrace();
                }
                ++i;
            }
        }
    }

    public void sendMessage(String message) throws RemoteException {
        StringTokenizer st = new StringTokenizer(message, "\n");
        Class<?> c2 = null;
        try {
            c2 = Class.forName(st.nextToken());
        }
        catch (ClassNotFoundException exc) {
            // empty catch block
        }
        int index = Convert.getInt(st.nextToken());
        String save = st.nextToken();
    }

    public void mouseClicked(MouseEvent e2) {
    }

    public void mouseEntered(MouseEvent e2) {
        this.sendMouseEvent(e2);
    }

    public void mouseExited(MouseEvent e2) {
        this.sendMouseEvent(e2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mousePressed(MouseEvent e2) {
        this.sendMouseEvent(e2);
        DisplayEvent de1 = new DisplayEvent((Display)this.display, 1, e2);
        DisplayEvent de2 = null;
        if (SwingUtilities.isLeftMouseButton(e2)) {
            de2 = new DisplayEvent((Display)this.display, 5, e2);
        } else if (SwingUtilities.isMiddleMouseButton(e2)) {
            de2 = new DisplayEvent((Display)this.display, 4, e2);
        } else if (SwingUtilities.isRightMouseButton(e2)) {
            de2 = new DisplayEvent((Display)this.display, 6, e2);
        }
        Vector vector = this.listen;
        synchronized (vector) {
            int i = 0;
            while (i < this.listen.size()) {
                DisplayListener l = (DisplayListener)this.listen.elementAt(i);
                try {
                    l.displayChanged(de1);
                    if (de2 != null) {
                        l.displayChanged(de2);
                    }
                }
                catch (VisADException exc) {
                    exc.printStackTrace();
                }
                catch (RemoteException exc) {
                    exc.printStackTrace();
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent e2) {
        this.sendMouseEvent(e2);
        DisplayEvent de1 = new DisplayEvent((Display)this.display, 7, e2);
        DisplayEvent de2 = null;
        if (SwingUtilities.isLeftMouseButton(e2)) {
            de2 = new DisplayEvent((Display)this.display, 9, e2);
        } else if (SwingUtilities.isMiddleMouseButton(e2)) {
            de2 = new DisplayEvent((Display)this.display, 8, e2);
        } else if (SwingUtilities.isRightMouseButton(e2)) {
            de2 = new DisplayEvent((Display)this.display, 10, e2);
        }
        Vector vector = this.listen;
        synchronized (vector) {
            int i = 0;
            while (i < this.listen.size()) {
                DisplayListener l = (DisplayListener)this.listen.elementAt(i);
                try {
                    l.displayChanged(de1);
                    if (de2 != null) {
                        l.displayChanged(de2);
                    }
                }
                catch (VisADException exc) {
                    exc.printStackTrace();
                }
                catch (RemoteException exc) {
                    exc.printStackTrace();
                }
                ++i;
            }
        }
    }

    public void mouseDragged(MouseEvent e2) {
        this.sendMouseEvent(e2);
    }

    public void mouseMoved(MouseEvent e2) {
    }

    private void sendMouseEvent(MouseEvent e2) {
        try {
            this.display.sendMouseEvent(e2);
        }
        catch (VisADException exc) {
        }
        catch (RemoteException exc) {}
    }
}

