/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.Color;
import java.rmi.RemoteException;
import java.util.Enumeration;
import visad.Control;
import visad.DisplayImpl;
import visad.ScalarMap;
import visad.UnimplementedException;
import visad.VisADException;
import visad.util.Util;

public class RendererControl
extends Control {
    private float[] backgroundColor = new float[]{0.0f, 0.0f, 0.0f};
    private float[] boxColor = new float[]{1.0f, 1.0f, 1.0f};
    private float[] cursorColor = new float[]{1.0f, 1.0f, 1.0f};
    private float[] foregroundColor = new float[]{1.0f, 1.0f, 1.0f};
    private boolean boxOn = false;

    public RendererControl(DisplayImpl dpy) {
        super(dpy);
    }

    public float[] getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) throws RemoteException, VisADException {
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b2 = (float)color.getBlue() / 255.0f;
        this.setBackgroundColor(r, g, b2);
    }

    public void setBackgroundColor(float r, float g, float b2) throws RemoteException, VisADException {
        this.backgroundColor[0] = r;
        this.backgroundColor[1] = g;
        this.backgroundColor[2] = b2;
        this.changeControl(true);
    }

    public float[] getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color color) throws RemoteException, VisADException {
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b2 = (float)color.getBlue() / 255.0f;
        this.setForegroundColor(r, g, b2);
    }

    public void setForegroundColor(float r, float g, float b2) throws RemoteException, VisADException {
        DisplayImpl dpy;
        this.setCursorColor(r, g, b2);
        this.setBoxColor(r, g, b2);
        this.foregroundColor[0] = r;
        this.foregroundColor[1] = g;
        this.foregroundColor[2] = b2;
        if (this.getDisplayRenderer() != null && (dpy = this.getDisplayRenderer().getDisplay()) != null) {
            Enumeration e2 = this.display.getMapVector().elements();
            while (e2.hasMoreElements()) {
                ScalarMap map = (ScalarMap)e2.nextElement();
                if (map.getAxisScale() == null) continue;
                map.setScaleColor(this.foregroundColor);
            }
        }
    }

    public float[] getBoxColor() {
        return this.boxColor;
    }

    public boolean getBoxOn() {
        return this.boxOn;
    }

    public void setBoxColor(Color color) throws RemoteException, VisADException {
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b2 = (float)color.getBlue() / 255.0f;
        this.setBoxColor(r, g, b2);
    }

    public void setBoxColor(float r, float g, float b2) throws RemoteException, VisADException {
        this.boxColor[0] = r;
        this.boxColor[1] = g;
        this.boxColor[2] = b2;
        this.changeControl(true);
    }

    public void setBoxOn(boolean on) throws RemoteException, VisADException {
        this.boxOn = on;
        this.changeControl(true);
    }

    public float[] getCursorColor() {
        return this.cursorColor;
    }

    public void setCursorColor(Color color) throws RemoteException, VisADException {
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b2 = (float)color.getBlue() / 255.0f;
        this.setCursorColor(r, g, b2);
    }

    public void setCursorColor(float r, float g, float b2) throws RemoteException, VisADException {
        this.cursorColor[0] = r;
        this.cursorColor[1] = g;
        this.cursorColor[2] = b2;
        this.changeControl(true);
    }

    private static boolean floatArrayEquals(float[] one, float[] two) {
        if (one == null) {
            if (two != null) {
                return false;
            }
        } else {
            if (two == null) {
                return false;
            }
            if (one.length != two.length) {
                return false;
            }
            int i = 0;
            while (i < one.length) {
                if (!Util.isApproximatelyEqual(one[i], two[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public String getSaveString() {
        return null;
    }

    public void setSaveString(String save) throws VisADException, RemoteException {
        throw new UnimplementedException("Cannot setSaveString on this type of control");
    }

    public void syncControl(Control ctl) throws VisADException {
        if (ctl == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(ctl instanceof RendererControl)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + ctl.getClass().getName());
        }
        RendererControl rc = (RendererControl)ctl;
        boolean changed = false;
        if (!RendererControl.floatArrayEquals(this.backgroundColor, rc.backgroundColor)) {
            changed = true;
            this.backgroundColor = rc.backgroundColor;
        }
        if (!RendererControl.floatArrayEquals(this.foregroundColor, rc.foregroundColor)) {
            changed = true;
            this.foregroundColor = rc.foregroundColor;
        }
        if (!RendererControl.floatArrayEquals(this.boxColor, rc.boxColor)) {
            changed = true;
            this.boxColor = rc.boxColor;
        }
        if (!RendererControl.floatArrayEquals(this.cursorColor, rc.cursorColor)) {
            changed = true;
            this.cursorColor = rc.cursorColor;
        }
        if (this.boxOn != rc.boxOn) {
            changed = true;
            this.boxOn = rc.boxOn;
        }
        if (changed) {
            try {
                this.changeControl(true);
            }
            catch (RemoteException re) {
                throw new VisADException("Could not indicate that control changed: " + re.getMessage());
            }
        }
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        RendererControl rc = (RendererControl)o;
        if (!RendererControl.floatArrayEquals(this.backgroundColor, rc.backgroundColor)) {
            return false;
        }
        if (!RendererControl.floatArrayEquals(this.foregroundColor, rc.foregroundColor)) {
            return false;
        }
        if (!RendererControl.floatArrayEquals(this.boxColor, rc.boxColor)) {
            return false;
        }
        if (!RendererControl.floatArrayEquals(this.cursorColor, rc.cursorColor)) {
            return false;
        }
        return this.boxOn == rc.boxOn;
    }

    public Object clone() {
        RendererControl rc = (RendererControl)super.clone();
        if (this.backgroundColor != null) {
            rc.backgroundColor = (float[])this.backgroundColor.clone();
        }
        if (this.foregroundColor != null) {
            rc.foregroundColor = (float[])this.foregroundColor.clone();
        }
        if (this.boxColor != null) {
            rc.boxColor = (float[])this.boxColor.clone();
        }
        if (this.cursorColor != null) {
            rc.cursorColor = (float[])this.cursorColor.clone();
        }
        return rc;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("RendererControl[");
        buf.append("bg=");
        buf.append(this.backgroundColor[0]);
        buf.append('/');
        buf.append(this.backgroundColor[1]);
        buf.append('/');
        buf.append(this.backgroundColor[2]);
        buf.append(",fg=");
        buf.append(this.foregroundColor[0]);
        buf.append('/');
        buf.append(this.foregroundColor[1]);
        buf.append('/');
        buf.append(this.foregroundColor[2]);
        buf.append(",cursor=");
        buf.append(this.cursorColor[0]);
        buf.append('/');
        buf.append(this.cursorColor[1]);
        buf.append('/');
        buf.append(this.cursorColor[2]);
        buf.append(",box=");
        buf.append(this.boxColor[0]);
        buf.append('/');
        buf.append(this.boxColor[1]);
        buf.append('/');
        buf.append(this.boxColor[2]);
        buf.append(',');
        if (!this.boxOn) {
            buf.append('!');
        }
        buf.append("boxOn");
        buf.append(']');
        return buf.toString();
    }
}

