/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import visad.ReferenceException;
import visad.RemoteThing;
import visad.RemoteThingReference;
import visad.RemoteVisADException;
import visad.Thing;
import visad.ThingReference;
import visad.ThingReferenceImpl;
import visad.VisADException;

public class ThingImpl
implements Thing,
Cloneable,
Serializable {
    private transient Vector references;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReference(ThingReference r) throws RemoteVisADException {
        if (!(r instanceof ThingReferenceImpl)) {
            throw new RemoteVisADException("ThingImpl.addReference: must use ThingReferenceImpl");
        }
        ThingImpl thingImpl = this;
        synchronized (thingImpl) {
            if (this.references == null) {
                this.references = new Vector();
            }
        }
        this.references.addElement(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void adaptedAddReference(RemoteThingReference r, RemoteThing t2) throws VisADException {
        RemotePair p;
        try {
            p = new RemotePair(r, t2);
        }
        catch (ReferenceException e2) {
            throw new ReferenceException("ThingImpl.adaptedAddReference: " + e2.getMessage());
        }
        ThingImpl thingImpl = this;
        synchronized (thingImpl) {
            if (this.references == null) {
                this.references = new Vector();
            }
        }
        this.references.addElement(p);
    }

    public void removeReference(ThingReference r) throws VisADException {
        if (this.references == null) {
            throw new ReferenceException("ThingImpl.removeReference: already clear");
        }
        if (!(r instanceof ThingReferenceImpl)) {
            throw new RemoteVisADException("ThingImpl.removeReference: must use RemoteThing for RemoteThingReference");
        }
        if (!this.references.removeElement(r)) {
            throw new ReferenceException("ThingImpl.removeReference: not found");
        }
    }

    void adaptedRemoveReference(RemoteThingReference r, RemoteThing t2) throws VisADException {
        RemotePair p;
        if (this.references == null) {
            throw new ReferenceException("ThingImpl.removeReference: already clear");
        }
        try {
            p = new RemotePair(r, t2);
        }
        catch (ReferenceException e2) {
            throw new ReferenceException("ThingImpl.adaptedRemoveReference: " + e2.getMessage());
        }
        if (!this.references.removeElement(p)) {
            throw new ReferenceException("ThingImpl.adaptedRemoveReference:  not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyReferences() throws VisADException, RemoteException {
        if (this.references != null) {
            Vector vector = this.references;
            synchronized (vector) {
                Enumeration refs = this.references.elements();
                while (refs.hasMoreElements()) {
                    Object r = refs.nextElement();
                    if (r instanceof ThingReferenceImpl) {
                        ((ThingReferenceImpl)r).incTick();
                        continue;
                    }
                    RemoteThing d2 = ((RemotePair)r).data;
                    d2.incTick();
                }
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ThingImpl clone;
        try {
            clone = (ThingImpl)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new Error("Assertion failure");
        }
        clone.references = new Vector();
        return clone;
    }

    class RemotePair {
        RemoteThingReference ref;
        RemoteThing data;

        RemotePair(RemoteThingReference r, RemoteThing d2) throws ReferenceException {
            if (r == null) {
                throw new ReferenceException("Cannot create RemotePair from null RemoteThingReference");
            }
            if (d2 == null) {
                throw new ReferenceException("Cannot create RemotePair from null RemoteThing");
            }
            this.ref = r;
            this.data = d2;
        }

        public boolean equals(Object pair) {
            if (!(pair instanceof RemotePair)) {
                return false;
            }
            RemotePair rp = (RemotePair)pair;
            return this.ref.equals(((RemotePair)pair).ref) && this.data.equals(((RemotePair)pair).data);
        }
    }
}

