/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Vector;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataImpl;
import visad.FunctionType;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ShadowType;
import visad.Tuple;
import visad.TypeException;
import visad.VisADException;

public class TupleType
extends MathType {
    private MathType[] tupleComponents;
    private boolean Flat;
    private final RealType[] realComponents;
    private int[] lows;
    private int[] his;

    public TupleType(MathType[] types) throws VisADException {
        boolean allReal = true;
        this.Flat = true;
        int n = types.length;
        int nFlat = 0;
        this.tupleComponents = new MathType[n];
        if (n < 1) {
            throw new TypeException("TupleType: # components must be > 0");
        }
        int i = 0;
        while (i < n) {
            if (types[i] == null) {
                throw new TypeException("TupleType: components must be non-null");
            }
            this.tupleComponents[i] = types[i];
            if (!(types[i] instanceof RealType)) {
                allReal = false;
            }
            if (types[i] instanceof RealType) {
                ++nFlat;
            } else if (types[i] instanceof RealTupleType) {
                nFlat += ((RealTupleType)types[i]).getDimension();
            } else {
                this.Flat = false;
            }
            ++i;
        }
        if (allReal && !(this instanceof RealTupleType)) {
            throw new TypeException("TupleType: all components are RealType, must use RealTupleType");
        }
        this.realComponents = new RealType[nFlat];
        this.lows = new int[n];
        this.his = new int[n];
        int j = 0;
        int i2 = 0;
        while (i2 < n) {
            this.lows[i2] = j;
            if (types[i2] instanceof RealType) {
                this.realComponents[j] = (RealType)types[i2];
            } else if (types[i2] instanceof RealTupleType) {
                int m = ((RealTupleType)types[i2]).getDimension();
                int k = 0;
                while (k < m) {
                    this.realComponents[j] = (RealType)((RealTupleType)types[i2]).getComponent(k);
                    ++j;
                    ++k;
                }
            }
            this.his[i2] = ++j;
            ++i2;
        }
    }

    TupleType(RealType[] types, boolean b2) {
        super(b2);
        boolean allReal = true;
        this.Flat = true;
        int n = types.length;
        int nFlat = 0;
        this.tupleComponents = new MathType[n];
        int i = 0;
        while (i < n) {
            this.tupleComponents[i] = types[i];
            ++nFlat;
            ++i;
        }
        this.realComponents = new RealType[nFlat];
        this.lows = new int[n];
        this.his = new int[n];
        int j = 0;
        int i2 = 0;
        while (i2 < n) {
            this.lows[i2] = j;
            if (types[i2] instanceof RealType) {
                this.realComponents[j] = types[i2];
            }
            this.his[i2] = ++j;
            ++i2;
        }
    }

    public int getDimension() {
        return this.tupleComponents.length;
    }

    public MathType[] getComponents() {
        return this.tupleComponents;
    }

    public RealType[] getRealComponents() {
        return this.realComponents;
    }

    public int getNumberOfRealComponents() {
        return this.realComponents.length;
    }

    public MathType __getitem__(int index) throws VisADException {
        return this.getComponent(index);
    }

    public int __len__() {
        return this.tupleComponents.length;
    }

    public MathType getComponent(int i) throws VisADException {
        if (0 <= i && i < this.tupleComponents.length) {
            return this.tupleComponents[i];
        }
        throw new TypeException("TupleType: component index out of range");
    }

    public int getIndex(String name) {
        return this.getIndex(RealType.getRealTypeByName(name));
    }

    public int getIndex(MathType type) {
        int i = 0;
        while (i < this.tupleComponents.length) {
            if (this.tupleComponents[i].equals(type)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean equals(Object type) {
        if (!(type instanceof TupleType)) {
            return false;
        }
        try {
            int n = this.tupleComponents.length;
            if (n != ((TupleType)type).getDimension()) {
                return false;
            }
            int i = 0;
            while (i < n) {
                if (!this.tupleComponents[i].equals(((TupleType)type).getComponent(i))) {
                    return false;
                }
                ++i;
            }
        }
        catch (VisADException e2) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Arrays.asList(this.tupleComponents).hashCode();
    }

    public boolean equalsExceptName(MathType type) {
        if (!(type instanceof TupleType)) {
            return false;
        }
        try {
            int n = this.tupleComponents.length;
            if (n != ((TupleType)type).getDimension()) {
                return false;
            }
            boolean flag = true;
            int i = 0;
            while (i < n) {
                flag = flag && this.tupleComponents[i].equalsExceptName(((TupleType)type).getComponent(i));
                ++i;
            }
            return flag;
        }
        catch (VisADException e2) {
            return false;
        }
    }

    public boolean equalsExceptNameButUnits(MathType type) {
        if (!(type instanceof TupleType)) {
            return false;
        }
        try {
            int n = this.tupleComponents.length;
            if (n != ((TupleType)type).getDimension()) {
                return false;
            }
            boolean flag = true;
            int i = 0;
            while (i < n) {
                flag = flag && this.tupleComponents[i].equalsExceptNameButUnits(((TupleType)type).getComponent(i));
                ++i;
            }
            return flag;
        }
        catch (VisADException e2) {
            return false;
        }
    }

    public MathType cloneDerivative(RealType d_partial) throws VisADException {
        int n_comps = this.tupleComponents.length;
        MathType[] new_types = new MathType[n_comps];
        boolean allReal = true;
        int ii = 0;
        while (ii < n_comps) {
            new_types[ii] = this.getComponent(ii).cloneDerivative(d_partial);
            if (!(new_types[ii] instanceof RealType)) {
                allReal = false;
            }
            ++ii;
        }
        if (allReal) {
            RealType[] r_types = new RealType[n_comps];
            int ii2 = 0;
            while (ii2 < n_comps) {
                r_types[ii2] = (RealType)new_types[ii2];
                ++ii2;
            }
            return new RealTupleType(r_types);
        }
        return new TupleType(new_types);
    }

    public MathType binary(MathType type, int op, Vector names) throws VisADException {
        if (type == null) {
            throw new TypeException("TupleType.binary: type may not be null");
        }
        if (type instanceof RealTupleType) {
            throw new TypeException("TupleType.binary: types don't match");
        }
        if (type instanceof TupleType) {
            int n_comps = this.tupleComponents.length;
            MathType[] new_types = new MathType[n_comps];
            int ii = 0;
            while (ii < n_comps) {
                MathType type_component = ((TupleType)type).getComponent(ii);
                new_types[ii] = this.getComponent(ii).binary(type_component, op, names);
                ++ii;
            }
            return new TupleType(new_types);
        }
        if (type instanceof RealType) {
            int n_comps = this.tupleComponents.length;
            MathType[] new_types = new MathType[n_comps];
            int ii = 0;
            while (ii < n_comps) {
                new_types[ii] = this.getComponent(ii).binary(type, op, names);
                ++ii;
            }
            return new TupleType(new_types);
        }
        if (type instanceof FunctionType && ((FunctionType)type).getRange().equalsExceptName(this)) {
            return new FunctionType(((FunctionType)type).getDomain(), ((FunctionType)type).getRange().binary(this, DataImpl.invertOp(op), names));
        }
        throw new TypeException("TupleType.binary: types don't match");
    }

    public MathType unary(int op, Vector names) throws VisADException {
        int n_comps = this.tupleComponents.length;
        MathType[] new_types = new MathType[n_comps];
        int ii = 0;
        while (ii < n_comps) {
            new_types[ii] = this.getComponent(ii).unary(op, names);
            ++ii;
        }
        return new TupleType(new_types);
    }

    public boolean getFlat() {
        return this.Flat;
    }

    public String prettyString(int indent) {
        int n = this.tupleComponents.length;
        String[] cs = new String[n];
        int[] lens = new int[n];
        int maxlen = 0;
        int sumlen = 0;
        int i = 0;
        while (i < n) {
            cs[i] = this.tupleComponents[i].prettyString(indent + 1);
            lens[i] = cs[i].length();
            if (lens[i] > maxlen) {
                maxlen = lens[i];
            }
            sumlen += lens[i];
            ++i;
        }
        if (sumlen + indent <= 72) {
            String s = "(" + cs[0];
            int i2 = 1;
            while (i2 < n) {
                s = s + ", " + cs[i2];
                ++i2;
            }
            return s + ")";
        }
        String blanks = "";
        int j = 0;
        while (j < indent + 1) {
            blanks = blanks + " ";
            ++j;
        }
        String s = "(" + cs[0];
        if (1 < n) {
            s = s + ",";
        }
        int i3 = 1;
        while (i3 < n) {
            s = s + "\n" + blanks + cs[i3];
            if (i3 + 1 < n) {
                s = s + ",";
            }
            ++i3;
        }
        return s + ")";
    }

    public Data missingData() {
        return new Tuple(this);
    }

    public ShadowType buildShadowType(DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return link.getRenderer().makeShadowTupleType(this, link, parent);
    }
}

