/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import visad.AnimationControl;
import visad.CellImpl;
import visad.CommonUnit;
import visad.Data;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.DateTime;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.EarthVectorType;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.GriddedSet;
import visad.Integer2DSet;
import visad.Irregular2DSet;
import visad.Linear1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ReferenceException;
import visad.ScalarMap;
import visad.ScalarType;
import visad.Set;
import visad.VisADException;
import visad.bom.PickCell;
import visad.bom.PickManipulationRendererJ3D;
import visad.bom.RubberBandLineRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.util.AnimationWidget;
import visad.util.ContourWidget;
import visad.util.LabeledColorWidget;

public class GridEdit
implements ActionListener {
    private boolean debug = true;
    private Field grids = null;
    private DisplayImpl display = null;
    private Object lock = new Object();
    private RealType t = null;
    private RealType x = null;
    private RealType y = null;
    private RealTupleType xy = null;
    private MathType range = null;
    private int rangedim = 0;
    private int nts = 0;
    Set tset = null;
    GriddedSet xyset = null;
    FunctionType grid_type;
    FlatField replacedff = null;
    FlatField savedff = null;
    AnimationControl acontrol = null;
    ScalarMap tmap = null;
    ScalarMap xmap = null;
    ScalarMap ymap = null;
    DisplayTupleType xtuple = null;
    DisplayTupleType ytuple = null;
    private CellImpl cell_rbl = null;
    private DataReferenceImpl ref_rbl = null;
    private RubberBandLineRendererJ3D rblr = null;
    private static final int NPICKS = 50;
    private int npicks = 0;
    private PickCell[] cell_picks = null;
    private DataReferenceImpl[] ref_picks = null;
    private PickManipulationRendererJ3D[] rend_picks = null;
    private float[][] delta_picks = null;
    private GridEdit thiscp = null;
    private int renderer_mask;
    private int dialog_mask;
    private static final int NX = 64;
    private static final int NY = 64;
    private static final int NTIMES = 4;

    public GridEdit(Field gs, DisplayImplJ3D d2) throws VisADException, RemoteException {
        this.grids = gs;
        this.display = d2;
        this.renderer_mask = 2;
        this.dialog_mask = 1;
        this.thiscp = this;
        FunctionType gstype = (FunctionType)gs.getType();
        RealTupleType domain = gstype.getDomain();
        int domdim = domain.getDimension();
        if (domdim == 1) {
            this.t = (RealType)domain.getComponent(0);
            this.tset = gs.getDomainSet();
            this.grid_type = (FunctionType)gstype.getRange();
            this.xy = this.grid_type.getDomain();
            int dim = this.xy.getDimension();
            if (dim != 2) {
                throw new VisADException("bad grid Field domain dimension: " + dim);
            }
            this.range = this.grid_type.getRange();
            this.nts = this.tset.getLength();
            int i = 0;
            while (i < this.nts) {
                FlatField ff = (FlatField)gs.getSample(i);
                Set s = ff.getDomainSet();
                if (!(s instanceof GriddedSet)) {
                    throw new VisADException("grid set must be GriddedSet");
                }
                if (this.xyset == null) {
                    this.xyset = (GriddedSet)s;
                } else if (!this.xyset.equals(s)) {
                    throw new VisADException("grid sets must match in animation");
                }
                ++i;
            }
        } else if (domdim == 2) {
            this.t = null;
            this.tset = null;
            this.xy = domain;
            this.grid_type = gstype;
            this.range = gstype.getRange();
            Set s = gs.getDomainSet();
            if (!(s instanceof GriddedSet)) {
                throw new VisADException("grid set must be GriddedSet");
            }
            this.xyset = (GriddedSet)s;
        } else {
            throw new VisADException("bad grid Field domain dimension: " + domdim);
        }
        this.x = (RealType)this.xy.getComponent(0);
        this.y = (RealType)this.xy.getComponent(1);
        if (this.range instanceof RealType) {
            this.rangedim = 1;
        } else if (this.range instanceof RealTupleType) {
            this.rangedim = ((RealTupleType)this.range).getDimension();
        } else {
            throw new VisADException("bad grid Field range type: " + this.range);
        }
        Vector scalar_map_vector = this.display.getMapVector();
        Enumeration enumeration = scalar_map_vector.elements();
        while (enumeration.hasMoreElements()) {
            ScalarMap map = (ScalarMap)enumeration.nextElement();
            ScalarType scalar = map.getScalar();
            DisplayRealType dreal = map.getDisplayScalar();
            DisplayTupleType tuple = dreal.getTuple();
            if (scalar.equals(this.t)) {
                if (!Display.Animation.equals(dreal)) continue;
                this.tmap = map;
                this.acontrol = (AnimationControl)((Object)this.tmap.getControl());
                continue;
            }
            if (tuple == null || !tuple.equals(Display.DisplaySpatialCartesianTuple) && (tuple.getCoordinateSystem() == null || !tuple.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple))) continue;
            if (scalar.equals(this.x)) {
                this.xmap = map;
                this.xtuple = tuple;
                continue;
            }
            if (!scalar.equals(this.y)) continue;
            this.ymap = map;
            this.ytuple = tuple;
        }
        if (this.xmap == null || this.ymap == null || this.xtuple != this.ytuple) {
            throw new VisADException("grid domain RealTypes must be mapped to spatial DisplayRealTypes from the same DisplayTupleType");
        }
        if (this.t != null && this.tmap == null) {
            throw new VisADException("grid sequence must be mapped to Animation");
        }
        this.makePicks(50);
        this.ref_rbl = new DataReferenceImpl("rbl");
        this.rblr = new RubberBandLineRendererJ3D(this.x, this.y, this.renderer_mask, 0);
        this.display.addReferences((DataRenderer)this.rblr, this.ref_rbl);
        this.rblr.suppressExceptions(true);
        this.rblr.toggle(false);
        this.cell_rbl = new CellImpl(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doAction() throws VisADException, RemoteException {
                Object object = GridEdit.this.lock;
                synchronized (object) {
                    int modifiers;
                    Set set = (Set)GridEdit.this.ref_rbl.getData();
                    if (set == null) {
                        return;
                    }
                    float[][] samples = set.getSamples();
                    if (samples == null) {
                        return;
                    }
                    int[] indices = GridEdit.this.xyset.valueToIndex(samples);
                    if (indices[0] < 0 || indices[1] < 0) {
                        return;
                    }
                    int index = -1;
                    int i = 0;
                    while (i < GridEdit.this.npicks) {
                        if (GridEdit.this.ref_picks[i].getData() == null) {
                            index = i;
                            GridEdit.this.cell_picks[index].setSkip();
                            GridEdit.this.ref_picks[index].setData(set);
                            GridEdit.this.rend_picks[index].toggle(true);
                            break;
                        }
                        ++i;
                    }
                    if (index < 0) {
                        index = GridEdit.this.npicks;
                        GridEdit.this.makePicks(GridEdit.this.npicks + 50);
                        GridEdit.this.cell_picks[index].setSkip();
                        GridEdit.this.ref_picks[index].setData(set);
                        GridEdit.this.rend_picks[index].toggle(true);
                    }
                    if (((modifiers = GridEdit.this.rblr.getLastMouseModifiers()) & GridEdit.this.dialog_mask) != 0) {
                        FlatField ff = null;
                        if (GridEdit.this.t != null) {
                            int tindex = GridEdit.this.getAnimationIndex();
                            if (tindex < 0 || tindex >= GridEdit.this.nts) {
                                return;
                            }
                            ff = (FlatField)GridEdit.this.grids.getSample(tindex);
                        } else {
                            ff = (FlatField)GridEdit.this.grids;
                        }
                        Data range = ff.getSample(indices[0]);
                        if (range instanceof Real) {
                            float value = (float)((Real)range).getValue();
                            String name = ((RealType)range.getType()).getName();
                            String question = "increment " + name + " (current: " + value + ")";
                            String newvs = JOptionPane.showInputDialog(null, (Object)question);
                            float newvalue = 0.0f;
                            try {
                                newvalue = Float.parseFloat(newvs);
                            }
                            catch (NumberFormatException e2) {
                                // empty catch block
                            }
                            ((GridEdit)GridEdit.this).delta_picks[0][index] = newvalue;
                        } else if (range instanceof RealTuple) {
                            int j = 0;
                            while (j < GridEdit.this.rangedim) {
                                Real real = (Real)((RealTuple)range).getComponent(j);
                                float value = (float)real.getValue();
                                String name = ((RealType)real.getType()).getName();
                                String question = "increment " + name + " (default: " + value + ")";
                                String newvs = JOptionPane.showInputDialog(null, (Object)question);
                                float newvalue = 0.0f;
                                try {
                                    newvalue = Float.parseFloat(newvs);
                                }
                                catch (NumberFormatException e3) {
                                    // empty catch block
                                }
                                ((GridEdit)GridEdit.this).delta_picks[j][index] = newvalue;
                                ++j;
                            }
                        }
                    }
                }
            }
        };
    }

    private void makePicks(int n) throws VisADException, RemoteException {
        if (n <= this.npicks) {
            return;
        }
        PickCell[] tcell = null;
        DataReferenceImpl[] tref = null;
        PickManipulationRendererJ3D[] trend = null;
        float[][] tdelta = null;
        if (this.npicks > 0) {
            tcell = this.cell_picks;
            tref = this.ref_picks;
            trend = this.rend_picks;
            tdelta = this.delta_picks;
        }
        this.cell_picks = new PickCell[n];
        this.ref_picks = new DataReferenceImpl[n];
        this.rend_picks = new PickManipulationRendererJ3D[n];
        this.delta_picks = new float[this.rangedim][n];
        if (this.npicks > 0) {
            System.arraycopy(tcell, 0, this.cell_picks, 0, this.npicks);
            System.arraycopy(tref, 0, this.ref_picks, 0, this.npicks);
            System.arraycopy(trend, 0, this.rend_picks, 0, this.npicks);
            int j = 0;
            while (j < this.rangedim) {
                System.arraycopy(tdelta[j], 0, this.delta_picks[j], 0, this.npicks);
                ++j;
            }
        }
        this.display.disableAction();
        int i = this.npicks;
        while (i < n) {
            this.makePick(i);
            ++i;
        }
        this.display.enableAction();
        this.npicks = n;
    }

    private void makePick(int i) throws VisADException, RemoteException {
        this.ref_picks[i] = new DataReferenceImpl("pick" + i);
        this.rend_picks[i] = new PickManipulationRendererJ3D(this.renderer_mask, this.renderer_mask);
        this.rend_picks[i].suppressExceptions(true);
        this.rend_picks[i].toggle(false);
        this.cell_picks[i] = new PickCell(this.ref_picks[i], this.rend_picks[i]);
        this.cell_picks[i].setSkip();
        this.cell_picks[i].addReference(this.ref_picks[i]);
        this.display.addReferences((DataRenderer)this.rend_picks[i], this.ref_picks[i]);
        int j = 0;
        while (j < this.rangedim) {
            this.delta_picks[j][i] = 0.0f;
            ++j;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws VisADException, RemoteException {
        Object object = this.lock;
        synchronized (object) {
            this.cell_rbl.addReference(this.ref_rbl);
            Gridded2DSet dummy_set = new Gridded2DSet((MathType)this.xy, null, 1);
            this.ref_rbl.setData(dummy_set);
            this.rblr.toggle(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws VisADException, RemoteException {
        Object object = this.lock;
        synchronized (object) {
            int np = 0;
            int i = 0;
            while (i < this.npicks) {
                if (this.ref_picks[i].getData() != null) {
                    ++np;
                }
                ++i;
            }
            if (np != 0) {
                FlatField ff = null;
                if (this.t != null) {
                    int index = this.getAnimationIndex();
                    if (index < 0 || index >= this.nts) {
                        return;
                    }
                    ff = (FlatField)this.grids.getSample(index);
                } else {
                    ff = (FlatField)this.grids;
                }
                this.savedff = new FlatField(this.grid_type, this.xyset);
                this.savedff.setSamples(ff.getFloats(false), false);
                float[][][] set_samples = new float[np][][];
                float[][] deltas = new float[this.rangedim][np];
                int k = 0;
                int i2 = 0;
                while (i2 < this.npicks) {
                    if (this.ref_picks[i2].getData() != null) {
                        int j = 0;
                        while (j < this.rangedim) {
                            deltas[j][k] = this.delta_picks[j][i2];
                            ++j;
                        }
                        set_samples[k++] = ((Set)this.ref_picks[i2].getData()).getSamples(false);
                    }
                    ++i2;
                }
                FlatField newff = GridEdit.warpGrid(ff, set_samples, deltas);
                ff.setSamples(newff.getFloats(false), false);
                this.replacedff = ff;
            }
            this.display.disableAction();
            this.rblr.toggle(false);
            int i3 = 0;
            while (i3 < this.npicks) {
                this.cell_picks[i3].setSkip();
                this.ref_picks[i3].setData(null);
                this.rend_picks[i3].toggle(true);
                ++i3;
            }
            int j = 0;
            while (j < this.rangedim) {
                int i4 = 0;
                while (i4 < this.npicks) {
                    this.delta_picks[j][i4] = 0.0f;
                    ++i4;
                }
                ++j;
            }
            this.display.enableAction();
            try {
                this.cell_rbl.removeReference(this.ref_rbl);
            }
            catch (ReferenceException e2) {
                // empty catch block
            }
        }
    }

    public static FlatField warpGrid(FlatField ff, float[][][] set_samples, float[][] deltas) throws VisADException, RemoteException {
        if (ff == null || set_samples == null || set_samples.length == 0) {
            throw new VisADException("null parameter");
        }
        FunctionType fft = (FunctionType)ff.getType();
        RealTupleType xy = fft.getDomain();
        GriddedSet xyset = (GriddedSet)ff.getDomainSet();
        MathType range = fft.getRange();
        int range_dim = -1;
        int np = set_samples.length;
        if (range instanceof RealType) {
            range_dim = 1;
        } else if (range instanceof RealTupleType) {
            range_dim = ((RealTupleType)range).getDimension();
        }
        if (deltas != null) {
            if (deltas.length != range_dim) {
                throw new VisADException("deltas bad length");
            }
            int j = 0;
            while (j < range_dim) {
                if (deltas[j] == null || deltas[j].length != np) {
                    throw new VisADException("deltas bad length");
                }
                ++j;
            }
        }
        int nx = xyset.getLength(0);
        int ny = xyset.getLength(1);
        int NB = 32;
        int nxb = nx > NB ? NB : nx;
        int nyb = ny > NB ? NB : ny;
        float xb = (float)nx / (float)nxb;
        float yb = (float)ny / (float)nyb;
        int nb = 2 * (nxb + nyb) - 4;
        int[] indicesb = new int[nb];
        int k = 0;
        int i = 0;
        while (i < nxb) {
            int ii = Math.round((float)i * xb);
            if (ii < 0) {
                ii = 0;
            }
            if (ii > nx - 1) {
                ii = nx - 1;
            }
            indicesb[k++] = ii;
            ++i;
        }
        int i2 = 1;
        while (i2 < nyb - 1) {
            int ii = Math.round((float)i2 * yb);
            if (ii < 1) {
                ii = 1;
            }
            if (ii > ny - 2) {
                ii = ny - 2;
            }
            indicesb[k++] = (ii + 1) * nx - 1;
            ++i2;
        }
        int i3 = nxb - 1;
        while (i3 >= 0) {
            int ii = Math.round((float)i3 * xb);
            if (ii < 0) {
                ii = 0;
            }
            if (ii > nx - 1) {
                ii = nx - 1;
            }
            indicesb[k++] = (ny - 1) * nx + ii;
            --i3;
        }
        int i4 = nyb - 2;
        while (i4 >= 1) {
            int ii = Math.round((float)i4 * yb);
            if (ii < 1) {
                ii = 1;
            }
            if (ii > ny - 2) {
                ii = ny - 2;
            }
            indicesb[k++] = ii * nx;
            --i4;
        }
        float[][] samplesb = xyset.indexToValue(indicesb);
        float[][] set_locs = new float[2][np];
        int i5 = 0;
        while (i5 < np) {
            set_locs[0][i5] = set_samples[i5][0][1];
            set_locs[1][i5] = set_samples[i5][1][1];
            ++i5;
        }
        float[][] set_grid = xyset.valueToGrid(set_locs);
        float nx2 = ((float)nx - 1.0f) / 2.0f;
        float ny2 = ((float)ny - 1.0f) / 2.0f;
        float nm2 = Math.min(nx2, ny2);
        float nm22 = nm2 * nm2;
        float nx22 = nx2 * nx2;
        float ny22 = ny2 * ny2;
        boolean all_in = true;
        int i6 = 0;
        while (i6 < np) {
            float d2 = (set_grid[0][i6] - nx2) * (set_grid[0][i6] - nx2) / nm22 + (set_grid[1][i6] - ny2) * (set_grid[1][i6] - ny2) / nm22;
            if ((double)d2 > 0.64) {
                all_in = false;
                break;
            }
            ++i6;
        }
        if (all_in) {
            int ne = 32;
            int new_nb = nb + ne;
            float[][] new_samplesb = new float[2][new_nb];
            System.arraycopy(samplesb[0], 0, new_samplesb[0], 0, nb);
            System.arraycopy(samplesb[1], 0, new_samplesb[1], 0, nb);
            float[][] circle_grid = new float[2][ne];
            int i7 = 0;
            while (i7 < ne) {
                double ang = Math.PI * 2 * (double)i7 / (double)ne;
                circle_grid[0][i7] = nx2 + nm2 * 0.9f * (float)Math.sin(ang);
                circle_grid[1][i7] = ny2 + nm2 * 0.9f * (float)Math.cos(ang);
                ++i7;
            }
            float[][] circle_locs = xyset.gridToValue(circle_grid);
            System.arraycopy(circle_locs[0], 0, new_samplesb[0], nb, ne);
            System.arraycopy(circle_locs[1], 0, new_samplesb[1], nb, ne);
            samplesb = new_samplesb;
            nb = new_nb;
        }
        RealType xmove = RealType.getRealType("xmove");
        RealType ymove = RealType.getRealType("ymove");
        RealTupleType xymove = new RealTupleType(xmove, ymove);
        FunctionType move_type = new FunctionType(xy, xymove);
        int ns = nb + np;
        float[][] mover = new float[2][ns];
        float[][] moved = new float[2][ns];
        int i8 = 0;
        while (i8 < nb) {
            moved[0][i8] = samplesb[0][i8];
            moved[1][i8] = samplesb[1][i8];
            mover[0][i8] = 0.0f;
            mover[1][i8] = 0.0f;
            ++i8;
        }
        int i9 = 0;
        while (i9 < np) {
            int ip = nb + i9;
            float[][] samples = set_samples[i9];
            moved[0][ip] = samples[0][1];
            moved[1][ip] = samples[1][1];
            mover[0][ip] = samples[0][0] - samples[0][1];
            mover[1][ip] = samples[1][0] - samples[1][1];
            ++i9;
        }
        Irregular2DSet iset = new Irregular2DSet((MathType)xy, moved);
        FlatField moveff = new FlatField(move_type, iset);
        moveff.setSamples(mover);
        FlatField move_interp = (FlatField)moveff.resample(xyset);
        float[][] bases = xyset.getSamples(true);
        float[][] offsets = move_interp.getFloats(false);
        int i10 = 0;
        while (i10 < nx * ny) {
            float[] fArray = bases[0];
            int n = i10;
            fArray[n] = fArray[n] + offsets[0][i10];
            float[] fArray2 = bases[1];
            int n2 = i10;
            fArray2[n2] = fArray2[n2] + offsets[1][i10];
            ++i10;
        }
        Gridded2DSet warpset = new Gridded2DSet(xy, bases, nx, ny, null, null, null, false, false);
        FlatField warpff = (FlatField)ff.resample(warpset);
        FlatField newff = new FlatField(fft, xyset);
        newff.setSamples(warpff.getFloats(false), false);
        if (deltas != null) {
            FlatField deltaff = new FlatField(fft, iset);
            float[][] ds = new float[range_dim][ns];
            int j = 0;
            while (j < range_dim) {
                int i11 = 0;
                while (i11 < nb) {
                    ds[j][i11] = 0.0f;
                    ++i11;
                }
                System.arraycopy(deltas[j], 0, ds[j], nb, np);
                ++j;
            }
            deltaff.setSamples(ds, false);
            newff = (FlatField)newff.add(deltaff, 101, 202);
        }
        float[][] ff_values = ff.getFloats(false);
        float[][] newff_values = newff.getFloats(false);
        boolean any_missing = false;
        int nff = ff_values[0].length;
        int j = 0;
        while (j < range_dim) {
            int i12 = 0;
            while (i12 < nff) {
                if (newff_values[j][i12] != newff_values[j][i12]) {
                    newff_values[j][i12] = ff_values[j][i12];
                    any_missing = true;
                }
                ++i12;
            }
            ++j;
        }
        if (any_missing) {
            newff.setSamples(newff_values);
        }
        return newff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo() throws VisADException, RemoteException {
        Object object = this.lock;
        synchronized (object) {
            if (this.replacedff != null) {
                float[][] samples = this.savedff.getFloats(false);
                this.replacedff.setSamples(samples, false);
            }
            this.replacedff = null;
        }
        this.stop();
    }

    private int getAnimationIndex() throws VisADException {
        int[] indices = new int[]{this.acontrol.getCurrent()};
        Set aset = this.acontrol.getSet();
        double[][] values = aset.indexToDouble(indices);
        int[] tindices = this.tset.doubleToIndex(values);
        return tindices[0];
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        RealType x = RealType.getRealType("x");
        RealType y = RealType.getRealType("y");
        RealType lat = RealType.Latitude;
        RealType lon = RealType.Longitude;
        RealTupleType xy = new RealTupleType(x, y);
        RealType windx = RealType.getRealType("windx", CommonUnit.meterPerSecond);
        RealType windy = RealType.getRealType("windy", CommonUnit.meterPerSecond);
        RealType red = RealType.getRealType("red");
        RealType green = RealType.getRealType("green");
        EarthVectorType windxy = new EarthVectorType(windx, windy);
        RealType time = RealType.Time;
        double startt = new DateTime(1999, 122, 57060.0).getValue();
        Linear1DSet time_set = new Linear1DSet((MathType)time, startt, startt + 2700.0, 4);
        Integer2DSet grid_set = new Integer2DSet((MathType)xy, 64, 64);
        RealTupleType tuple_type = new RealTupleType(new RealType[]{lon, lat, windx, windy, red, green});
        FunctionType field_type = new FunctionType(xy, tuple_type);
        FunctionType seq_type = new FunctionType(time, field_type);
        DisplayImplJ3D display1 = new DisplayImplJ3D("display1", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        double NM = Math.max(64, 64);
        ScalarMap ymap = new ScalarMap(y, Display.YAxis);
        display1.addMap(ymap);
        ScalarMap xmap = new ScalarMap(x, Display.XAxis);
        display1.addMap(xmap);
        ymap.setRange(0.0, NM);
        xmap.setRange(0.0, NM);
        ScalarMap cmap = null;
        cmap = args.length > 0 ? new ScalarMap(windy, Display.RGB) : new ScalarMap(windy, Display.IsoContour);
        display1.addMap(cmap);
        ScalarMap amap = new ScalarMap(time, Display.Animation);
        display1.addMap(amap);
        AnimationControl acontrol = (AnimationControl)((Object)amap.getControl());
        acontrol.setStep(500);
        FieldImpl field = new FieldImpl(seq_type, time_set);
        double[][] values = new double[6][4096];
        int k = 0;
        while (k < 4) {
            FlatField ff = new FlatField(field_type, grid_set);
            int m = 0;
            double NX2 = 32.0;
            double NY2 = 32.0;
            int j = 0;
            while (j < 64) {
                int i = 0;
                while (i < 64) {
                    double u = 2.0 * ((double)i - NX2) / (NM - 1.0);
                    double v = 2.0 * ((double)j - NY2) / (NM - 1.0);
                    values[0][m] = 10.0 * u;
                    values[1][m] = 10.0 * v - 40.0;
                    double fx = (double)k + 30.0 * u;
                    double fy = 30.0 * v;
                    double fd = 57.29577951308232 * Math.atan2(-fx, -fy) + (double)k * 15.0;
                    double fs = Math.sqrt(fx * fx + fy * fy);
                    values[2][m] = fd;
                    values[3][m] = fs;
                    values[4][m] = u;
                    values[5][m] = v;
                    ++m;
                    ++i;
                }
                ++j;
            }
            ff.setSamples(values);
            field.setSample(k, (Data)ff);
            ++k;
        }
        DataReferenceImpl seq_ref = new DataReferenceImpl("seq");
        seq_ref.setData(field);
        display1.addReference(seq_ref);
        GridEdit cp = new GridEdit(field, display1);
        JFrame frame = new JFrame("test CollectiveBarbManipulation");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e2) {
                System.exit(0);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 1));
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 1));
        panel1.add(display1.getComponent());
        panel1.setMaximumSize(new Dimension(400, 600));
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BoxLayout(panel3, 0));
        JButton start = new JButton("start");
        start.addActionListener(cp);
        start.setActionCommand("start");
        JButton stop = new JButton("stop");
        stop.addActionListener(cp);
        stop.setActionCommand("stop");
        JButton undo = new JButton("undo");
        undo.addActionListener(cp);
        undo.setActionCommand("undo");
        panel3.add(start);
        panel3.add(stop);
        panel3.add(undo);
        panel2.add(new AnimationWidget(amap));
        panel2.add(new JLabel(" "));
        if (args.length > 0) {
            LabeledColorWidget lcw = new LabeledColorWidget(cmap);
            lcw.setMaximumSize(new Dimension(400, 200));
            panel2.add(lcw);
        } else {
            ContourWidget cw = new ContourWidget(cmap);
            cw.setMaximumSize(new Dimension(400, 200));
            panel2.add(cw);
        }
        panel2.add(new JLabel(" "));
        panel2.add(panel3);
        panel2.setMaximumSize(new Dimension(400, 600));
        panel.add(panel1);
        panel.add(panel2);
        frame.getContentPane().add(panel);
        frame.setSize(800, 600);
        frame.setVisible(true);
    }

    public void actionPerformed(ActionEvent e2) {
        block10: {
            String cmd;
            block11: {
                block9: {
                    cmd = e2.getActionCommand();
                    if (!cmd.equals("start")) break block9;
                    try {
                        this.start();
                    }
                    catch (VisADException ex) {
                        ex.printStackTrace();
                    }
                    catch (RemoteException ex) {
                        ex.printStackTrace();
                    }
                    break block10;
                }
                if (!cmd.equals("stop")) break block11;
                try {
                    this.stop();
                }
                catch (VisADException ex) {
                    ex.printStackTrace();
                }
                catch (RemoteException ex) {
                    ex.printStackTrace();
                }
                break block10;
            }
            if (!cmd.equals("undo")) break block10;
            try {
                this.undo();
            }
            catch (VisADException ex) {
                ex.printStackTrace();
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
        }
    }
}

