/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.Vector;
import visad.DateTime;
import visad.VisADException;

public class RadarFile {
    public DateTime dtTime;
    public double dRadarTime;
    public float rngres = 250.0f;
    public float startrng = 4000.0f;
    public float azimuthres = 1.0f;
    public float elev = 0.0f;
    private boolean fileok;
    private BufferedReader rf;
    private int size;
    private int az;
    public byte[][] radial;
    static final char decimal = '.';
    static final char percent = '%';
    static final char[] A2NXlat = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', ' ', '!', '\"', '#', '$', '%', '&', '0', '1', '2', '3', '4', '5', '6', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', '`', 'a', 'b', 'c', 'd', 'e', 'f'};
    static final int maxSize = 250;
    public byte[] bdata;
    public Vector pbvector = new Vector();
    public PolarByteData pbdata;
    public PolarByteData[] pbdataArray;

    public RadarFile(String radarSource) throws IOException {
        this.rf = new BufferedReader(new FileReader(radarSource));
        this.fileok = true;
        this.size = 0;
        this.az = 0;
        boolean iradial = false;
        while (this.rf != null) {
            this.readRadial();
            this.pbdata = new PolarByteData(this.az, this.bdata);
            System.arraycopy(this.bdata, 0, this.pbdata.bdata, 0, this.bdata.length);
            if (this.rf == null) continue;
            this.pbvector.addElement(this.pbdata);
        }
        this.pbdataArray = new PolarByteData[this.pbvector.size()];
        this.pbvector.copyInto(this.pbdataArray);
    }

    public double getTime() {
        return this.dRadarTime;
    }

    public void setTime(String radarTime) {
        try {
            this.dRadarTime = Double.valueOf(radarTime);
        }
        catch (NumberFormatException e2) {
            System.out.println("Exception converting Radar Time in module visad.bom.RadarFile.getTime() " + e2);
            this.dRadarTime = 0.0;
        }
    }

    public DateTime getRadarTime() {
        return this.dtTime;
    }

    public void setRadarTime(String timeStamp) throws VisADException {
        String[] ids = TimeZone.getAvailableIDs(0);
        SimpleTimeZone timeZone = new SimpleTimeZone(0, ids[0]);
        GregorianCalendar cal = new GregorianCalendar(timeZone);
        int year = Integer.valueOf(timeStamp.substring(0, 4));
        int month = Integer.valueOf(timeStamp.substring(4, 6));
        int day = Integer.valueOf(timeStamp.substring(6, 8));
        int hours = Integer.valueOf(timeStamp.substring(8, 10));
        int mins = Integer.valueOf(timeStamp.substring(10, 12));
        int secs = Integer.valueOf(timeStamp.substring(12, 14));
        System.out.println("timeStamp: " + timeStamp);
        System.out.println("year,month,day,hour,mins,secs: " + year + " " + month + " " + day + " " + hours + " " + mins + " " + secs);
        cal.clear();
        cal.set(year, month - 1, day, hours, mins, secs);
        System.out.println("Initialized with date: " + cal.getTime().toString());
        this.dtTime = new DateTime(cal.getTime());
        System.out.println("Initialized with date: " + this.dtTime);
    }

    public void readHeader(char[] cbuff) {
        String thisLine = new String(cbuff);
        if (thisLine.startsWith("COUNTRY:")) {
            System.out.println("line = " + thisLine);
        } else if (thisLine.startsWith("NAME:")) {
            System.out.println("line = " + thisLine);
        } else if (thisLine.startsWith("STNID:")) {
            System.out.println("line = " + thisLine);
        } else if (thisLine.startsWith("DATE:")) {
            System.out.println("line = " + thisLine);
        } else if (thisLine.startsWith("TIME:")) {
            String radarTime = new String(thisLine.substring(6));
            System.out.println("radarTime = " + radarTime);
        } else if (thisLine.startsWith("TIMESTAMP:")) {
            try {
                this.setRadarTime(thisLine.substring(11));
            }
            catch (VisADException e2) {
                System.out.println("error setting radar time " + e2);
            }
        } else if (thisLine.startsWith("VERS:")) {
            System.out.println("line = " + thisLine);
        } else if (thisLine.startsWith("RNGRES:")) {
            this.rngres = Float.valueOf(thisLine.substring(8)).floatValue();
            System.out.println("rngres = " + this.rngres);
        } else if (thisLine.startsWith("ANGRES:")) {
            System.out.println("line = " + thisLine);
        } else if (thisLine.startsWith("VIDRES:")) {
            System.out.println("line = " + thisLine);
        } else if (thisLine.startsWith("STARTRNG:")) {
            this.startrng = Float.valueOf(thisLine.substring(10)).floatValue();
            System.out.println("startrng = " + this.startrng);
        } else if (thisLine.startsWith("ENDRNG:")) {
            System.out.println("line = " + thisLine);
        } else if (thisLine.startsWith("PRODUCT:")) {
            System.out.println("line = " + thisLine);
        } else if (thisLine.startsWith("IMGFMT:")) {
            System.out.println("line = " + thisLine);
        } else if (thisLine.startsWith("ELEV:")) {
            this.elev = Float.valueOf(thisLine.substring(6)).floatValue();
            System.out.println("elev = " + this.elev);
        } else if (thisLine.startsWith("DBZLVL:")) {
            System.out.println("line = " + thisLine);
        } else if (thisLine.startsWith("CLEARAIR:")) {
            System.out.println("line = " + thisLine);
        } else if (thisLine.startsWith("DBZCALDLVL:")) {
            System.out.println("line = " + thisLine);
        } else if (thisLine.startsWith("DIGCALDLVL:")) {
            System.out.println("line = " + thisLine);
        } else if (thisLine.startsWith("BEAMWIDTH:")) {
            System.out.println("line = " + thisLine);
        } else if (thisLine.startsWith("PULSELENGTH:")) {
            System.out.println("line = " + thisLine);
        } else if (thisLine.startsWith("STCRANGE:")) {
            System.out.println("line = " + thisLine);
        } else if (thisLine.startsWith("TXFREQUENCY:")) {
            System.out.println("line = " + thisLine);
        } else if (thisLine.startsWith("TXPEAKPWR:")) {
            System.out.println("line = " + thisLine);
        } else if (thisLine.startsWith("ANTGAIN:")) {
            System.out.println("line = " + thisLine);
        } else if (thisLine.startsWith("NOISETHRESH:")) {
            System.out.println("line = " + thisLine);
        }
    }

    public void readRadial() throws IOException {
        int pos = 0;
        boolean done = false;
        double dval = 0.0;
        StringBuffer sbuff = new StringBuffer();
        this.bdata = new byte[250];
        String ipString = this.rf.readLine();
        if (ipString == null) {
            this.rf = null;
            return;
        }
        char[] cbuff = ipString.toCharArray();
        int sizeBuff = cbuff.length;
        if (sizeBuff == 0) {
            return;
        }
        int thisChar = cbuff[pos];
        if (37 != thisChar) {
            this.readHeader(cbuff);
        }
        int n = ++pos;
        ++pos;
        thisChar = cbuff[n];
        while (Character.isDigit((char)thisChar) || thisChar == 46) {
            sbuff.append((char)thisChar);
            thisChar = cbuff[pos++];
        }
        try {
            if (sbuff.length() != 0) {
                this.az = Math.round(Float.valueOf(sbuff.toString()).floatValue());
            }
        }
        catch (NumberFormatException e2) {
            System.out.println("error converting radial " + e2);
        }
        --pos;
        while (!done) {
            thisChar = cbuff[pos];
            ++pos;
            if ((thisChar = thisChar >= 65 && thisChar <= 89 ? (int)((char)(thisChar - 65)) : (thisChar >= 97 && thisChar <= 120 ? (int)((char)(thisChar - 72)) : 255)) != 255) {
                thisChar = A2NXlat[thisChar];
                int rptCount = 0;
                if (pos < cbuff.length) {
                    while (Character.isDigit(cbuff[pos])) {
                        rptCount = rptCount * 10 + (cbuff[pos] - 48);
                        if (++pos < cbuff.length) continue;
                        done = true;
                        break;
                    }
                } else {
                    done = true;
                }
                if (sizeBuff + ++rptCount * 2 > 250) {
                    rptCount = (250 - sizeBuff) / 2;
                    done = true;
                }
                while (rptCount-- > 0) {
                    this.bdata[sizeBuff] = (byte)(thisChar & 0xF);
                    this.bdata[sizeBuff + 1] = (byte)(thisChar >> 4);
                    sizeBuff += 2;
                }
                continue;
            }
            done = true;
            ++pos;
        }
    }

    public class PolarByteData {
        public double azimuth;
        public byte[] bdata;

        public PolarByteData() {
            this.azimuth = 0.0;
            this.bdata = new byte[250];
        }

        public PolarByteData(double az, byte[] bdata) {
            this.azimuth = az;
            this.bdata = new byte[bdata.length];
            System.arraycopy(bdata, 0, this.bdata, 0, bdata.length);
        }
    }
}

