/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.BadDirectManipulationException;
import visad.CellImpl;
import visad.CoordinateSystem;
import visad.DataDisplayLink;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded2DSet;
import visad.Integer2DSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarType;
import visad.Set;
import visad.ShadowType;
import visad.Unit;
import visad.VisADException;
import visad.VisADLineStripArray;
import visad.VisADRay;
import visad.java3d.DirectManipulationRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.ShadowTypeJ3D;

public class RubberBandBoxRendererJ3D
extends DirectManipulationRendererJ3D {
    private RealType x = null;
    private RealType y = null;
    private RealTupleType xy = null;
    private int mouseModifiersMask = 0;
    private int mouseModifiersValue = 0;
    private BranchGroup branch = null;
    private BranchGroup group = null;
    private transient DataDisplayLink link = null;
    private transient DataReference ref = null;
    private transient ScalarMap xmap = null;
    private transient ScalarMap ymap = null;
    float[] default_values;
    private float[] f = new float[1];
    private float[] d = new float[1];
    private float[] value = new float[2];
    private String whyNotDirect = null;
    private int directManifoldDimension = 2;
    private DisplayTupleType tuple;
    private CoordinateSystem tuplecs;
    private int xindex = -1;
    private int yindex = -1;
    private int otherindex = -1;
    private float othervalue;
    private byte red;
    private byte green;
    private byte blue;
    private float[][] first_x;
    private float[][] last_x;
    private float[][] clast_x;
    private float cum_lon;
    private static final String xandyNotMatch = "x and y spatial domains don't match";
    private static final String xandyNotSpatial = "x and y must be mapped to spatial";
    private boolean stop = false;
    private static final int EDGE = 20;
    private static final float EPS = 0.005f;
    private static final int N = 64;

    public RubberBandBoxRendererJ3D(RealType xarg, RealType yarg) {
        this(xarg, yarg, 0, 0);
    }

    public RubberBandBoxRendererJ3D(RealType xarg, RealType yarg, int mmm, int mmv) {
        this.x = xarg;
        this.y = yarg;
        this.mouseModifiersMask = mmm;
        this.mouseModifiersValue = mmv;
    }

    public synchronized BranchGroup doTransform() throws VisADException, RemoteException {
        this.branch = new BranchGroup();
        this.branch.setCapability(17);
        this.branch.setCapability(12);
        this.branch.setCapability(13);
        this.branch.setCapability(14);
        if (!this.getIsDirectManipulation()) {
            throw new BadDirectManipulationException(this.getWhyNotDirect() + ": DirectManipulationRendererJ3D.doTransform");
        }
        this.setBranch(this.branch);
        return this.branch;
    }

    public void checkDirect() throws VisADException, RemoteException {
        this.setIsDirectManipulation(false);
        DisplayImpl display = this.getDisplay();
        DataDisplayLink[] Links = this.getLinks();
        if (Links == null || Links.length == 0) {
            this.link = null;
            return;
        }
        this.link = Links[0];
        this.ref = this.link.getDataReference();
        this.default_values = this.link.getDefaultValues();
        this.xmap = null;
        this.ymap = null;
        Vector scalar_map_vector = display.getMapVector();
        Enumeration enumeration = scalar_map_vector.elements();
        while (enumeration.hasMoreElements()) {
            DisplayRealType dreal;
            DisplayTupleType t2;
            ScalarMap map = (ScalarMap)enumeration.nextElement();
            ScalarType real = map.getScalar();
            if (real.equals(this.x) && (t2 = (dreal = map.getDisplayScalar()).getTuple()) != null && (t2.equals(Display.DisplaySpatialCartesianTuple) || t2.getCoordinateSystem() != null && t2.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple))) {
                this.xmap = map;
                this.xindex = dreal.getTupleIndex();
                if (this.tuple == null) {
                    this.tuple = t2;
                } else if (!t2.equals(this.tuple)) {
                    this.whyNotDirect = xandyNotMatch;
                    return;
                }
            }
            if (!real.equals(this.y) || (t2 = (dreal = map.getDisplayScalar()).getTuple()) == null || !t2.equals(Display.DisplaySpatialCartesianTuple) && (t2.getCoordinateSystem() == null || !t2.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple))) continue;
            this.ymap = map;
            this.yindex = dreal.getTupleIndex();
            if (this.tuple == null) {
                this.tuple = t2;
                continue;
            }
            if (t2.equals(this.tuple)) continue;
            this.whyNotDirect = xandyNotMatch;
            return;
        }
        if (this.xmap == null || this.ymap == null) {
            this.whyNotDirect = xandyNotSpatial;
            return;
        }
        this.xy = new RealTupleType(this.x, this.y);
        this.otherindex = 3 - (this.xindex + this.yindex);
        DisplayRealType dreal = (DisplayRealType)this.tuple.getComponent(this.otherindex);
        int index = this.getDisplay().getDisplayScalarIndex(dreal);
        this.othervalue = index > 0 ? this.default_values[index] : (float)dreal.getDefaultValue();
        index = this.getDisplay().getDisplayScalarIndex(Display.Red);
        float v = index > 0 ? this.default_values[index] : (float)Display.Red.getDefaultValue();
        this.red = ShadowType.floatToByte(v);
        index = this.getDisplay().getDisplayScalarIndex(Display.Green);
        v = index > 0 ? this.default_values[index] : (float)Display.Green.getDefaultValue();
        this.green = ShadowType.floatToByte(v);
        index = this.getDisplay().getDisplayScalarIndex(Display.Blue);
        v = index > 0 ? this.default_values[index] : (float)Display.Blue.getDefaultValue();
        this.blue = ShadowType.floatToByte(v);
        if (Display.DisplaySpatialCartesianTuple.equals(this.tuple)) {
            this.tuple = null;
            this.tuplecs = null;
        } else {
            this.tuplecs = this.tuple.getCoordinateSystem();
        }
        this.directManifoldDimension = 2;
        this.setIsDirectManipulation(true);
    }

    private int getDirectManifoldDimension() {
        return this.directManifoldDimension;
    }

    public String getWhyNotDirect() {
        return this.whyNotDirect;
    }

    public void addPoint(float[] x) throws VisADException {
    }

    public CoordinateSystem getDisplayCoordinateSystem() {
        return this.tuplecs;
    }

    public synchronized void setSpatialValues(float[][] spatial_values) {
    }

    public synchronized float checkClose(double[] origin, double[] direction) {
        int mouseModifiers = this.getLastMouseModifiers();
        if ((mouseModifiers & this.mouseModifiersMask) != this.mouseModifiersValue) {
            return Float.MAX_VALUE;
        }
        try {
            float r = this.findRayManifoldIntersection(true, origin, direction, this.tuple, this.otherindex, this.othervalue);
            if (r == r) {
                return 0.0f;
            }
            return Float.MAX_VALUE;
        }
        catch (VisADException ex) {
            return Float.MAX_VALUE;
        }
    }

    public synchronized void release_direct() {
        if (this.group != null) {
            this.group.detach();
        }
        this.group = null;
        try {
            float[][] samples = new float[2][2];
            this.f[0] = this.first_x[this.xindex][0];
            this.d = this.xmap.inverseScaleValues(this.f);
            samples[0][0] = this.d[0];
            this.f[0] = this.first_x[this.yindex][0];
            this.d = this.ymap.inverseScaleValues(this.f);
            samples[1][0] = this.d[0];
            this.f[0] = this.last_x[this.xindex][0];
            this.d = this.xmap.inverseScaleValues(this.f);
            samples[0][1] = this.d[0];
            this.f[0] = this.last_x[this.yindex][0];
            this.d = this.ymap.inverseScaleValues(this.f);
            samples[1][1] = this.d[0];
            Gridded2DSet set = new Gridded2DSet((MathType)this.xy, samples, 2);
            this.ref.setData(set);
            this.link.clearData();
        }
        catch (VisADException e2) {
            System.out.println("release_direct " + e2);
            e2.printStackTrace();
        }
        catch (RemoteException e3) {
            System.out.println("release_direct " + e3);
            e3.printStackTrace();
        }
    }

    public void stop_direct() {
        this.stop = true;
    }

    public synchronized void drag_direct(VisADRay ray, boolean first, int mouseModifiers) {
        if (this.ref == null) {
            return;
        }
        if (first) {
            this.stop = false;
        } else if (this.stop) {
            return;
        }
        double[] origin = ray.position;
        double[] direction = ray.vector;
        try {
            float r = this.findRayManifoldIntersection(true, origin, direction, this.tuple, this.otherindex, this.othervalue);
            if (r != r) {
                if (this.group != null) {
                    this.group.detach();
                }
                return;
            }
            Object xx = new float[][]{{(float)(origin[0] + (double)r * direction[0])}, {(float)(origin[1] + (double)r * direction[1])}, {(float)(origin[2] + (double)r * direction[2])}};
            if (this.tuple != null) {
                xx = this.tuplecs.fromReference((float[][])xx);
            }
            if (first) {
                this.first_x = xx;
                this.cum_lon = 0.0f;
            } else if (Display.DisplaySpatialSphericalTuple.equals(this.tuple)) {
                float diff = xx[1][0] - this.clast_x[1][0];
                if (diff > 180.0f) {
                    diff -= 360.0f;
                } else if (diff < -180.0f) {
                    diff += 360.0f;
                }
                this.cum_lon += diff;
                if (this.cum_lon > 360.0f) {
                    this.cum_lon -= 360.0f;
                } else if (this.cum_lon < -360.0f) {
                    this.cum_lon += 360.0f;
                }
            }
            this.clast_x = xx;
            Vector<String> vect = new Vector<String>();
            this.f[0] = xx[this.xindex][0];
            this.d = this.xmap.inverseScaleValues(this.f);
            Real rr = new Real(this.x, (double)this.d[0]);
            Unit overrideUnit = this.xmap.getOverrideUnit();
            Unit rtunit = this.x.getDefaultUnit();
            if (overrideUnit != null && !overrideUnit.equals(rtunit) && !RealType.Time.equals(this.x)) {
                double dval = overrideUnit.toThis(this.d[0], rtunit);
                rr = new Real(this.x, dval, overrideUnit);
            }
            String valueString = rr.toValueString();
            vect.addElement(this.x.getName() + " = " + valueString);
            this.f[0] = xx[this.yindex][0];
            this.d = this.ymap.inverseScaleValues(this.f);
            rr = new Real(this.y, (double)this.d[0]);
            overrideUnit = this.ymap.getOverrideUnit();
            rtunit = this.y.getDefaultUnit();
            if (overrideUnit != null && !overrideUnit.equals(rtunit) && !RealType.Time.equals(this.y)) {
                double dval = overrideUnit.toThis(this.d[0], rtunit);
                rr = new Real(this.y, dval, overrideUnit);
            }
            valueString = rr.toValueString();
            valueString = new Real(this.y, (double)this.d[0]).toValueString();
            vect.addElement(this.y.getName() + " = " + valueString);
            this.getDisplayRenderer().setCursorStringVector(vect);
            Object xxp = new float[][]{{xx[0][0]}, {xx[1][0]}, {xx[2][0]}};
            float[] fArray = xxp[this.otherindex];
            fArray[0] = fArray[0] + 0.005f;
            if (this.tuplecs != null) {
                xxp = this.tuplecs.toReference((float[][])xxp);
            }
            Object xxm = new float[][]{{xx[0][0]}, {xx[1][0]}, {xx[2][0]}};
            float[] fArray2 = xxm[this.otherindex];
            fArray2[0] = fArray2[0] - 0.005f;
            if (this.tuplecs != null) {
                xxm = this.tuplecs.toReference((float[][])xxm);
            }
            double dot = (double)(xxp[0][0] - xxm[0][0]) * direction[0] + (double)(xxp[1][0] - xxm[1][0]) * direction[1] + (double)(xxp[2][0] - xxm[2][0]) * direction[2];
            float abs = (float)Math.sqrt((xxp[0][0] - xxm[0][0]) * (xxp[0][0] - xxm[0][0]) + (xxp[1][0] - xxm[1][0]) * (xxp[1][0] - xxm[1][0]) + (xxp[2][0] - xxm[2][0]) * (xxp[2][0] - xxm[2][0]));
            float other_offset = 0.005f * (0.01f / abs);
            if (dot >= 0.0) {
                other_offset = -other_offset;
            }
            this.last_x = new float[][]{{this.clast_x[0][0]}, {this.clast_x[1][0]}, {this.clast_x[2][0]}};
            if (Display.DisplaySpatialSphericalTuple.equals(this.tuple) && this.otherindex != 1) {
                if (this.last_x[1][0] < this.first_x[1][0] && this.cum_lon > 0.0f) {
                    float[] fArray3 = this.last_x[1];
                    fArray3[0] = (float)((double)fArray3[0] + 360.0);
                } else if (this.last_x[1][0] > this.first_x[1][0] && this.cum_lon < 0.0f) {
                    float[] fArray4 = this.last_x[1];
                    fArray4[0] = (float)((double)fArray4[0] - 360.0);
                }
            }
            int npoints = 81;
            float[][] c2 = new float[3][npoints];
            int i = 0;
            while (i < 20) {
                float a2 = (float)i / 20.0f;
                float b2 = 1.0f - a2;
                c2[this.xindex][i] = b2 * this.first_x[this.xindex][0] + a2 * this.last_x[this.xindex][0];
                c2[this.yindex][i] = this.first_x[this.yindex][0];
                c2[this.otherindex][i] = this.first_x[this.otherindex][0] + other_offset;
                c2[this.xindex][20 + i] = this.last_x[this.xindex][0];
                c2[this.yindex][20 + i] = b2 * this.first_x[this.yindex][0] + a2 * this.last_x[this.yindex][0];
                c2[this.otherindex][20 + i] = this.first_x[this.otherindex][0] + other_offset;
                c2[this.xindex][40 + i] = b2 * this.last_x[this.xindex][0] + a2 * this.first_x[this.xindex][0];
                c2[this.yindex][40 + i] = this.last_x[this.yindex][0];
                c2[this.otherindex][40 + i] = this.first_x[this.otherindex][0] + other_offset;
                c2[this.xindex][60 + i] = this.first_x[this.xindex][0];
                c2[this.yindex][60 + i] = b2 * this.last_x[this.yindex][0] + a2 * this.first_x[this.yindex][0];
                c2[this.otherindex][60 + i] = this.first_x[this.otherindex][0] + other_offset;
                ++i;
            }
            c2[0][npoints - 1] = c2[0][0];
            c2[1][npoints - 1] = c2[1][0];
            c2[2][npoints - 1] = c2[2][0];
            if (this.tuple != null) {
                c2 = this.tuplecs.toReference(c2);
            }
            float[] coordinates = new float[3 * npoints];
            int i2 = 0;
            while (i2 < npoints) {
                int i3 = 3 * i2;
                coordinates[i3] = c2[0][i2];
                coordinates[i3 + 1] = c2[1][i2];
                coordinates[i3 + 2] = c2[2][i2];
                ++i2;
            }
            VisADLineStripArray array = new VisADLineStripArray();
            array.vertexCount = npoints;
            array.stripVertexCounts = new int[1];
            array.stripVertexCounts[0] = npoints;
            array.coordinates = coordinates;
            byte[] colors = new byte[3 * npoints];
            int i3 = 0;
            while (i3 < npoints) {
                int i32 = 3 * i3;
                colors[i32] = this.red;
                colors[i32 + 1] = this.green;
                colors[i32 + 2] = this.blue;
                ++i3;
            }
            array.colors = colors;
            array = (VisADLineStripArray)array.adjustSeam(this);
            DisplayImplJ3D display = (DisplayImplJ3D)this.getDisplay();
            GeometryArray geometry = display.makeGeometry(array);
            DataDisplayLink[] Links = this.getLinks();
            if (Links == null || Links.length == 0) {
                return;
            }
            DataDisplayLink link = Links[0];
            float[] default_values = link.getDefaultValues();
            GraphicsModeControl mode = (GraphicsModeControl)display.getGraphicsModeControl().clone();
            float pointSize = default_values[display.getDisplayScalarIndex(Display.PointSize)];
            float lineWidth = default_values[display.getDisplayScalarIndex(Display.LineWidth)];
            mode.setPointSize(pointSize, true);
            mode.setLineWidth(lineWidth, true);
            Appearance appearance = ShadowTypeJ3D.staticMakeAppearance(mode, null, null, geometry, false);
            if (this.group != null) {
                this.group.detach();
            }
            this.group = null;
            Shape3D shape = new Shape3D((Geometry)geometry, appearance);
            this.group = new BranchGroup();
            this.group.setCapability(12);
            this.group.setCapability(17);
            this.group.addChild((Node)shape);
            if (this.branch != null) {
                this.branch.addChild((Node)this.group);
            }
        }
        catch (VisADException e2) {
            System.out.println("drag_direct " + e2);
            e2.printStackTrace();
        }
    }

    public Object clone() {
        return new RubberBandBoxRendererJ3D(this.x, this.y, this.mouseModifiersMask, this.mouseModifiersValue);
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        RealType x = RealType.getRealType("x");
        RealType y = RealType.getRealType("y");
        RealTupleType xy = new RealTupleType(x, y);
        RealType c2 = RealType.getRealType("c");
        FunctionType ft = new FunctionType(xy, c2);
        DisplayImplJ3D display = new DisplayImplJ3D("display1");
        if (args.length == 0 || args[0].equals("z")) {
            display.addMap(new ScalarMap(x, Display.XAxis));
            display.addMap(new ScalarMap(y, Display.YAxis));
        } else if (args[0].equals("x")) {
            display.addMap(new ScalarMap(x, Display.YAxis));
            display.addMap(new ScalarMap(y, Display.ZAxis));
        } else if (args[0].equals("y")) {
            display.addMap(new ScalarMap(x, Display.XAxis));
            display.addMap(new ScalarMap(y, Display.ZAxis));
        } else if (args[0].equals("radius")) {
            display.addMap(new ScalarMap(x, Display.Longitude));
            display.addMap(new ScalarMap(y, Display.Latitude));
        } else if (args[0].equals("lat")) {
            display.addMap(new ScalarMap(x, Display.Longitude));
            display.addMap(new ScalarMap(y, Display.Radius));
        } else if (args[0].equals("lon")) {
            display.addMap(new ScalarMap(x, Display.Latitude));
            display.addMap(new ScalarMap(y, Display.Radius));
        } else {
            display.addMap(new ScalarMap(x, Display.Longitude));
            display.addMap(new ScalarMap(y, Display.Latitude));
        }
        display.addMap(new ScalarMap(c2, Display.RGB));
        Integer2DSet fset = new Integer2DSet((MathType)xy, 64, 64);
        FlatField field = new FlatField(ft, fset);
        float[][] values = new float[1][4096];
        int k = 0;
        int i = 0;
        while (i < 64) {
            int j = 0;
            while (j < 64) {
                values[0][k++] = (i - 32) * (j - 32);
                ++j;
            }
            ++i;
        }
        field.setSamples(values);
        DataReferenceImpl field_ref = new DataReferenceImpl("field");
        field_ref.setData(field);
        display.addReference(field_ref);
        Gridded2DSet dummy_set = new Gridded2DSet((MathType)xy, null, 1);
        final DataReferenceImpl ref = new DataReferenceImpl("set");
        ref.setData(dummy_set);
        int m = args.length > 1 ? 2 : 0;
        display.addReferences((DataRenderer)new RubberBandBoxRendererJ3D(x, y, m, m), ref);
        CellImpl cell = new CellImpl(){

            public void doAction() throws VisADException, RemoteException {
                Set set = (Set)ref.getData();
                float[][] samples = set.getSamples();
                if (samples != null) {
                    System.out.println("box (" + samples[0][0] + ", " + samples[1][0] + ") to (" + samples[0][1] + ", " + samples[1][1] + ")");
                }
            }
        };
        cell.addReference(ref);
        JFrame frame = new JFrame("test RubberBandBoxRendererJ3D");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e2) {
                System.exit(0);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentY(0.0f);
        panel.setAlignmentX(0.0f);
        frame.getContentPane().add(panel);
        panel.add(display.getComponent());
        frame.setSize(500, 500);
        frame.setVisible(true);
    }
}

