/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.rmi.RemoteException;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.DisplayImpl;
import visad.FlowControl;
import visad.MathType;
import visad.ShadowType;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADLineArray;
import visad.VisADTriangleArray;
import visad.bom.BarbManipulationRendererJ2D;
import visad.bom.BarbRenderer;
import visad.java2d.ShadowRealTupleTypeJ2D;

public class ShadowBarbRealTupleTypeJ2D
extends ShadowRealTupleTypeJ2D {
    private static final int NUM = 512;
    static /* synthetic */ Class class$visad$Flow1Control;
    static /* synthetic */ Class class$visad$Flow2Control;

    public ShadowBarbRealTupleTypeJ2D(MathType t2, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        super(t2, link, parent);
    }

    public VisADGeometryArray[] makeFlow(int which, float[][] flow_values, float flowScale, float[][] spatial_values, byte[][] color_values, boolean[][] range_select) throws VisADException {
        DataRenderer renderer = this.getLink().getRenderer();
        boolean direct = renderer.getIsDirectManipulation();
        if (direct && renderer instanceof BarbManipulationRendererJ2D) {
            return ShadowBarbRealTupleTypeJ2D.staticMakeFlow(this.getDisplay(), which, flow_values, flowScale, spatial_values, color_values, range_select, renderer, true);
        }
        return ShadowBarbRealTupleTypeJ2D.staticMakeFlow(this.getDisplay(), which, flow_values, flowScale, spatial_values, color_values, range_select, renderer, false);
    }

    public static VisADGeometryArray[] staticMakeFlow(DisplayImpl display, int which, float[][] flow_values, float flowScale, float[][] spatial_values, byte[][] color_values, boolean[][] range_select, DataRenderer renderer, boolean direct) throws VisADException {
        int i;
        if (flow_values[0] == null) {
            return null;
        }
        if (spatial_values[0] == null) {
            return null;
        }
        int len = spatial_values[0].length;
        int flen = flow_values[0].length;
        int rlen = 0;
        if (range_select[0] == null) {
            rlen = len;
        } else {
            int j = 0;
            while (j < range_select[0].length) {
                if (range_select[0][j]) {
                    ++rlen;
                }
                ++j;
            }
        }
        if (rlen == 0) {
            return null;
        }
        boolean[] south = new boolean[len];
        float[][] earth_locs = renderer.spatialToEarth(spatial_values);
        if (earth_locs != null) {
            int i2 = 0;
            while (i2 < len) {
                south[i2] = earth_locs[0][i2] < 0.0f;
                ++i2;
            }
        } else {
            FlowControl fcontrol = null;
            if (which == 0) {
                fcontrol = (FlowControl)display.getControl(class$visad$Flow1Control == null ? (class$visad$Flow1Control = ShadowBarbRealTupleTypeJ2D.class$("visad.Flow1Control")) : class$visad$Flow1Control);
            } else if (which == 1) {
                fcontrol = (FlowControl)display.getControl(class$visad$Flow2Control == null ? (class$visad$Flow2Control = ShadowBarbRealTupleTypeJ2D.class$("visad.Flow2Control")) : class$visad$Flow2Control);
            }
            if (fcontrol == null) {
                throw new VisADException("ShadowBarbRealTupleTypeJ2D: Unable to get FlowControl");
            }
            boolean isSouth = fcontrol.getBarbOrientation() == 1;
            int i3 = 0;
            while (i3 < len) {
                south[i3] = isSouth;
                ++i3;
            }
        }
        flow_values = ShadowType.adjustFlowToEarth(which, flow_values, spatial_values, 0.02f, renderer);
        float[] vx = new float[512];
        float[] vy = new float[512];
        float[] tx = new float[512];
        float[] ty = new float[512];
        byte[] vred = null;
        byte[] vgreen = null;
        byte[] vblue = null;
        byte[] tred = null;
        byte[] tgreen = null;
        byte[] tblue = null;
        if (color_values != null) {
            vred = new byte[512];
            vgreen = new byte[512];
            vblue = new byte[512];
            tred = new byte[512];
            tgreen = new byte[512];
            tblue = new byte[512];
        }
        int[] numv = new int[]{0};
        int[] numt = new int[]{0};
        float scale = flowScale;
        float pt_size = 0.25f * flowScale;
        float f0 = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        int j = 0;
        while (j < len) {
            if (range_select[0] == null || range_select[0][j]) {
                byte[] cblue;
                byte[] cgreen;
                byte[] cred;
                int l;
                float[] cy;
                float[] cx;
                if (flen == 1) {
                    f0 = flow_values[0][0];
                    f1 = flow_values[1][0];
                    f2 = flow_values[2][0];
                } else {
                    f0 = flow_values[0][j];
                    f1 = flow_values[1][j];
                    f2 = flow_values[2][j];
                }
                if (numv[0] + 256 > vx.length) {
                    cx = vx;
                    cy = vy;
                    l = 2 * vx.length;
                    vx = new float[l];
                    vy = new float[l];
                    System.arraycopy(cx, 0, vx, 0, cx.length);
                    System.arraycopy(cy, 0, vy, 0, cy.length);
                    if (color_values != null) {
                        cred = vred;
                        cgreen = vgreen;
                        cblue = vblue;
                        vred = new byte[l];
                        vgreen = new byte[l];
                        vblue = new byte[l];
                        System.arraycopy(cred, 0, vred, 0, cred.length);
                        System.arraycopy(cgreen, 0, vgreen, 0, cgreen.length);
                        System.arraycopy(cblue, 0, vblue, 0, cblue.length);
                    }
                }
                if (numt[0] + 256 > tx.length) {
                    cx = tx;
                    cy = ty;
                    l = 2 * tx.length;
                    tx = new float[l];
                    ty = new float[l];
                    System.arraycopy(cx, 0, tx, 0, cx.length);
                    System.arraycopy(cy, 0, ty, 0, cy.length);
                    if (color_values != null) {
                        cred = tred;
                        cgreen = tgreen;
                        cblue = tblue;
                        tred = new byte[l];
                        tgreen = new byte[l];
                        tblue = new byte[l];
                        System.arraycopy(cred, 0, tred, 0, cred.length);
                        System.arraycopy(cgreen, 0, tgreen, 0, cgreen.length);
                        System.arraycopy(cblue, 0, tblue, 0, cblue.length);
                    }
                }
                int oldnv = numv[0];
                int oldnt = numt[0];
                float[] mbarb = ShadowBarbRealTupleTypeJ2D.makeBarb(south[j], spatial_values[0][j], spatial_values[1][j], scale, pt_size, f0, f1, vx, vy, numv, tx, ty, numt, renderer);
                if (direct) {
                    ((BarbManipulationRendererJ2D)renderer).setVectorSpatialValues(mbarb, which);
                }
                int nv = numv[0];
                int nt = numt[0];
                if (color_values != null) {
                    if (color_values[0].length > 1) {
                        int i4 = oldnv;
                        while (i4 < nv) {
                            vred[i4] = color_values[0][j];
                            vgreen[i4] = color_values[1][j];
                            vblue[i4] = color_values[2][j];
                            ++i4;
                        }
                        i = oldnt;
                        while (i < nt) {
                            tred[i] = color_values[0][j];
                            tgreen[i] = color_values[1][j];
                            tblue[i] = color_values[2][j];
                            ++i;
                        }
                    } else {
                        int i5 = oldnv;
                        while (i5 < nv) {
                            vred[i5] = color_values[0][0];
                            vgreen[i5] = color_values[1][0];
                            vblue[i5] = color_values[2][0];
                            ++i5;
                        }
                        i = oldnt;
                        while (i < nt) {
                            tred[i] = color_values[0][0];
                            tgreen[i] = color_values[1][0];
                            tblue[i] = color_values[2][0];
                            ++i;
                        }
                    }
                }
            }
            ++j;
        }
        int nv = numv[0];
        int nt = numt[0];
        if (nv == 0) {
            return null;
        }
        VisADGeometryArray[] arrays = null;
        VisADLineArray array = new VisADLineArray();
        array.vertexCount = nv;
        float[] coordinates = new float[3 * nv];
        int m = 0;
        i = 0;
        while (i < nv) {
            coordinates[m++] = vx[i];
            coordinates[m++] = vy[i];
            coordinates[m++] = 0.0f;
            ++i;
        }
        array.coordinates = coordinates;
        byte[] colors = null;
        if (color_values != null) {
            colors = new byte[3 * nv];
            m = 0;
            int i6 = 0;
            while (i6 < nv) {
                colors[m++] = vred[i6];
                colors[m++] = vgreen[i6];
                colors[m++] = vblue[i6];
                ++i6;
            }
            array.colors = colors;
        }
        VisADTriangleArray tarray = null;
        if (nt > 0) {
            tarray = new VisADTriangleArray();
            tarray.vertexCount = nt;
            coordinates = new float[3 * nt];
            m = 0;
            int i7 = 0;
            while (i7 < nt) {
                coordinates[m++] = tx[i7];
                coordinates[m++] = ty[i7];
                coordinates[m++] = 0.0f;
                ++i7;
            }
            tarray.coordinates = coordinates;
            if (color_values != null) {
                colors = new byte[3 * nt];
                m = 0;
                int i8 = 0;
                while (i8 < nt) {
                    colors[m++] = tred[i8];
                    colors[m++] = tgreen[i8];
                    colors[m++] = tblue[i8];
                    ++i8;
                }
                tarray.colors = colors;
            }
            array = (VisADLineArray)array.adjustLongitudeBulk(renderer);
            tarray = (VisADTriangleArray)tarray.adjustLongitudeBulk(renderer);
            arrays = new VisADGeometryArray[]{array, tarray};
        } else {
            array = (VisADLineArray)array.adjustLongitudeBulk(renderer);
            arrays = new VisADGeometryArray[]{array};
        }
        return arrays;
    }

    static float[] makeBarb(boolean south, float x, float y, float scale, float pt_size, float f0, float f1, float[] vx, float[] vy, int[] numv, float[] tx, float[] ty, int[] numt, DataRenderer renderer) {
        float[] mbarb = new float[4];
        mbarb[0] = x;
        mbarb[1] = y;
        if (!(renderer instanceof BarbRenderer) || ((BarbRenderer)((Object)renderer)).getKnotsConvert()) {
            f0 = (float)((double)f0 * 1.9425354836481679);
            f1 = (float)((double)f1 * 1.9425354836481679);
        }
        float wnd_spd = (float)Math.sqrt(f0 * f0 + f1 * f1);
        int lenv = vx.length;
        int lent = tx.length;
        int nv = numv[0];
        int nt = numt[0];
        if ((double)wnd_spd >= 2.5) {
            float y2;
            float x2;
            float wsp25 = (float)Math.max((double)wnd_spd + 2.5, 5.0);
            float slant = 0.15f * scale;
            float barb = 0.4f * scale;
            float x0 = -f0 / wnd_spd;
            float y0 = -f1 / wnd_spd;
            float d2 = 3.0f * barb;
            float x1 = x + x0 * d2;
            float y1 = y + y0 * d2;
            int nbarb50 = (int)(wsp25 / 50.0f);
            int nbarb10 = (int)((wsp25 - (float)nbarb50 * 50.0f) / 10.0f);
            int nbarb5 = (int)((wsp25 - (float)nbarb50 * 50.0f - (float)nbarb10 * 10.0f) / 5.0f);
            if (nbarb5 == 1) {
                barb *= 0.4f;
                slant *= 0.4f;
                x1 = x + x0 * d2;
                y1 = y + y0 * d2;
                if (south) {
                    x2 = x + x0 * (d2 + slant) - y0 * barb;
                    y2 = y + y0 * (d2 + slant) + x0 * barb;
                } else {
                    x2 = x + x0 * (d2 + slant) + y0 * barb;
                    y2 = y + y0 * (d2 + slant) - x0 * barb;
                }
                vx[nv] = x1;
                vy[nv] = y1;
                vx[++nv] = x2;
                vy[nv] = y2;
                ++nv;
            }
            if (wsp25 >= 5.0f && wsp25 < 10.0f) {
                x1 = x + x0 * (d2 += 0.125f * scale);
                y1 = y + y0 * d2;
            }
            barb = 0.4f * scale;
            slant = 0.15f * scale;
            int j = 0;
            while (j < nbarb10) {
                x1 = x + x0 * (d2 += 0.125f * scale);
                y1 = y + y0 * d2;
                if (south) {
                    x2 = x + x0 * (d2 + slant) - y0 * barb;
                    y2 = y + y0 * (d2 + slant) + x0 * barb;
                } else {
                    x2 = x + x0 * (d2 + slant) + y0 * barb;
                    y2 = y + y0 * (d2 + slant) - x0 * barb;
                }
                vx[nv] = x1;
                vy[nv] = y1;
                vx[++nv] = x2;
                vy[nv] = y2;
                ++nv;
                ++j;
            }
            if (nbarb50 > 0) {
                x1 = x + x0 * (d2 += 0.125f * scale);
                y1 = y + y0 * d2;
            }
            int j2 = 0;
            while (j2 < nbarb50) {
                x1 = x + x0 * d2;
                y1 = y + y0 * d2;
                float x3 = x + x0 * (d2 += 0.3f * scale);
                float y3 = y + y0 * d2;
                if (south) {
                    x2 = x + x0 * (d2 + slant) - y0 * barb;
                    y2 = y + y0 * (d2 + slant) + x0 * barb;
                } else {
                    x2 = x + x0 * (d2 + slant) + y0 * barb;
                    y2 = y + y0 * (d2 + slant) - x0 * barb;
                }
                float[] xp = new float[]{x1, x2, x3};
                float[] yp = new float[]{y1, y2, y3};
                tx[nt] = x1;
                ty[nt] = y1;
                tx[++nt] = x2;
                ty[nt] = y2;
                tx[++nt] = x3;
                ty[nt] = y3;
                ++nt;
                x1 = x3;
                y1 = y3;
                ++j2;
            }
            vx[nv] = x;
            vy[nv] = y;
            vx[++nv] = x1;
            vy[nv] = y1;
            mbarb[2] = x1;
            mbarb[3] = y1;
        } else {
            float rad = 0.7f * pt_size;
            vx[nv] = x - rad;
            vy[nv] = y;
            vx[++nv] = x - 0.7f * rad;
            vy[nv] = y + 0.7f * rad;
            vx[++nv] = x - 0.7f * rad;
            vy[nv] = y + 0.7f * rad;
            vx[++nv] = x;
            vy[nv] = y + rad;
            vx[++nv] = x;
            vy[nv] = y + rad;
            vx[++nv] = x + 0.7f * rad;
            vy[nv] = y + 0.7f * rad;
            vx[++nv] = x + 0.7f * rad;
            vy[nv] = y + 0.7f * rad;
            vx[++nv] = x + rad;
            vy[nv] = y;
            vx[++nv] = x + rad;
            vy[nv] = y;
            vx[++nv] = x + 0.7f * rad;
            vy[nv] = y - 0.7f * rad;
            vx[++nv] = x + 0.7f * rad;
            vy[nv] = y - 0.7f * rad;
            vx[++nv] = x;
            vy[nv] = y - rad;
            vx[++nv] = x;
            vy[nv] = y - rad;
            vx[++nv] = x - 0.7f * rad;
            vy[nv] = y - 0.7f * rad;
            vx[++nv] = x - 0.7f * rad;
            vy[nv] = y - 0.7f * rad;
            vx[++nv] = x - rad;
            vy[nv] = y;
            ++nv;
            mbarb[2] = x;
            mbarb[3] = y;
        }
        numv[0] = ++nv;
        numt[0] = nt;
        return mbarb;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

