/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.media.j3d.BranchGroup;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.BadMappingException;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayException;
import visad.DisplayRealType;
import visad.Irregular2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarType;
import visad.SetType;
import visad.ShadowType;
import visad.VisADError;
import visad.VisADException;
import visad.bom.ShadowTextureFillSetTypeJ3D;
import visad.collab.CollabUtil;
import visad.java3d.DefaultRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.ShadowTypeJ3D;

public class TextureFillRendererJ3D
extends DefaultRendererJ3D {
    private static MathType set_type;
    private float scale = 10.0f;
    private int texture_width = 0;
    private int texture_height = 0;
    private int[] texture = null;
    private boolean smooth = false;

    public void setScale(float s) {
        this.scale = s;
    }

    public float getScale() {
        return this.scale;
    }

    public void setTexture(int w, int h, int[] t2) throws VisADException {
        int ww = 1;
        while (ww < w) {
            ww *= 2;
        }
        int hh = 1;
        while (hh < h) {
            hh *= 2;
        }
        if (ww != w || hh != h || t2 == null || t2.length != w * h) {
            throw new VisADException("bad params");
        }
        this.texture_width = w;
        this.texture_height = h;
        this.texture = t2;
    }

    public int getTextureWidth() {
        return this.texture_width;
    }

    public int getTextureHeight() {
        return this.texture_height;
    }

    public int[] getTexture() {
        return this.texture;
    }

    public void setSmooth(boolean s) {
        this.smooth = s;
    }

    public boolean getSmooth() {
        return this.smooth;
    }

    public static boolean isSetType(MathType type) {
        return set_type.equalsExceptName(type);
    }

    public static boolean isRendererUsable(MathType type, ScalarMap[] maps) throws VisADException {
        RealTupleType domain = null;
        RealType x = null;
        RealType y = null;
        RealType rx = null;
        RealType ry = null;
        if (!(type instanceof SetType)) {
            throw new VisADException("Not a SetType");
        }
        SetType set = (SetType)type;
        domain = set.getDomain();
        x = (RealType)domain.getComponent(0);
        y = (RealType)domain.getComponent(1);
        CoordinateSystem cs = domain.getCoordinateSystem();
        if (cs != null) {
            RealTupleType rxy = cs.getReference();
            rx = (RealType)rxy.getComponent(0);
            ry = (RealType)rxy.getComponent(1);
        }
        boolean bx = false;
        boolean by = false;
        boolean brx = false;
        boolean bry = false;
        Boolean latlon = null;
        DisplayRealType spatial = null;
        int i = 0;
        while (i < maps.length) {
            ScalarMap m = maps[i];
            ScalarType md = m.getScalar();
            DisplayRealType mr = m.getDisplayScalar();
            boolean ddx = md.equals(x);
            boolean ddy = md.equals(y);
            boolean ddrx = md.equals(rx);
            boolean ddry = md.equals(ry);
            if (ddx || ddy || ddrx || ddry) {
                boolean ll;
                RealType q;
                if (ddx && bx || ddy && by || ddrx && brx || ddry && bry) {
                    throw new VisADException("Duplicate spatial mappings");
                }
                if ((ddx || ddy) && (brx || bry) || (ddrx || ddry) && (bx || by)) {
                    throw new VisADException("reference and non-reference spatial mappings");
                }
                RealType realType = q = ddx ? x : null;
                if (ddy) {
                    q = y;
                }
                if (ddrx) {
                    q = rx;
                }
                if (ddry) {
                    q = ry;
                }
                if (mr.equals(Display.XAxis) || mr.equals(Display.YAxis) || mr.equals(Display.ZAxis)) {
                    ll = false;
                } else if (mr.equals(Display.Latitude) || mr.equals(Display.Longitude) || mr.equals(Display.Radius)) {
                    ll = true;
                } else {
                    throw new VisADException("Illegal domain mapping");
                }
                if (latlon == null) {
                    latlon = new Boolean(ll);
                    spatial = mr;
                } else {
                    if (latlon != ll) {
                        throw new VisADException("Multiple spatial coordinate systems");
                    }
                    if (spatial == mr) {
                        throw new VisADException("Multiple mappings to the same spatial DisplayRealType");
                    }
                }
                if (ddx) {
                    bx = true;
                } else if (ddy) {
                    by = true;
                } else if (ddrx) {
                    brx = true;
                } else if (ddry) {
                    bry = true;
                }
            } else if (ddx || ddy || ddrx || ddry) {
                throw new VisADException("Illegal mapping: " + m);
            }
            ++i;
        }
        if (!(bx && by || brx && bry)) {
            throw new VisADException("Insufficient mappings");
        }
        return true;
    }

    public ShadowType makeShadowSetType(SetType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return new ShadowTextureFillSetTypeJ3D(type, link, parent);
    }

    public BranchGroup doTransform() throws VisADException, RemoteException {
        Data data;
        DataDisplayLink[] Links;
        BranchGroup branch = this.getBranch();
        if (branch == null) {
            branch = new BranchGroup();
            branch.setCapability(17);
            branch.setCapability(14);
            branch.setCapability(12);
            branch.setCapability(13);
        }
        if ((Links = this.getLinks()) == null || Links.length == 0) {
            return null;
        }
        DataDisplayLink link = Links[0];
        ShadowTypeJ3D type = (ShadowTypeJ3D)link.getShadow();
        int valueArrayLength = this.getDisplay().getValueArrayLength();
        float[] valueArray = new float[valueArrayLength];
        int i = 0;
        while (i < valueArrayLength) {
            valueArray[i] = Float.NaN;
            ++i;
        }
        try {
            data = link.getData();
        }
        catch (RemoteException re) {
            if (CollabUtil.isDisconnectException(re)) {
                this.getDisplay().connectionFailed(this, link);
                this.removeLink(link);
                return null;
            }
            throw re;
        }
        if (data == null) {
            branch = null;
            this.addException(new DisplayException("Data is null: DefaultRendererJ3D.doTransform"));
        } else {
            MathType mtype = link.getType();
            if (!TextureFillRendererJ3D.isSetType(mtype)) {
                throw new BadMappingException("must be set");
            }
            link.start_time = System.currentTimeMillis();
            link.time_flag = false;
            try {
                type.doTransform(branch, data, valueArray, link.getDefaultValues(), this);
            }
            catch (RemoteException re) {
                if (CollabUtil.isDisconnectException(re)) {
                    this.getDisplay().connectionFailed(this, link);
                    this.removeLink(link);
                    return null;
                }
                throw re;
            }
        }
        link.clearData();
        return branch;
    }

    public Object clone() {
        return new TextureFillRendererJ3D();
    }

    public static void main(String[] args) throws VisADException, RemoteException, IOException {
        int width;
        DataReferenceImpl set_ref = new DataReferenceImpl("set");
        DisplayImplJ3D display = new DisplayImplJ3D("set display");
        RealType x = RealType.getRealType("x");
        RealType y = RealType.getRealType("y");
        RealTupleType xy = new RealTupleType(x, y);
        int points = 23;
        float[][] samples = new float[2][points];
        int i = 0;
        while (i < points) {
            samples[0][i] = (float)Math.random();
            samples[1][i] = (float)Math.random();
            ++i;
        }
        Irregular2DSet set = new Irregular2DSet((MathType)xy, samples);
        set_ref.setData(set);
        display.addMap(new ScalarMap(x, Display.XAxis));
        display.addMap(new ScalarMap(y, Display.YAxis));
        TextureFillRendererJ3D renderer = new TextureFillRendererJ3D();
        int height = width = 8;
        int half = width / 2;
        int halfm = half - 1;
        int halfp = half + 1;
        int[] texture = new int[width * height];
        int m = 0;
        int t2 = -1;
        int i2 = 0;
        while (i2 < width) {
            int j = 0;
            while (j < height) {
                texture[m] = i2 == half && halfm <= j && j <= halfp || j == half && halfm <= i2 && i2 <= halfp ? t2 : 0;
                ++m;
                ++j;
            }
            ++i2;
        }
        renderer.setTexture(width, height, texture);
        renderer.setScale(10.0f);
        renderer.setSmooth(args.length > 0);
        display.addReferences((DataRenderer)renderer, set_ref);
        JFrame frame = new JFrame("TextureFillRendererJ3D test");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e2) {
                System.exit(0);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentY(0.0f);
        panel.setAlignmentX(0.0f);
        frame.getContentPane().add(panel);
        panel.add(display.getComponent());
        frame.setSize(500, 500);
        frame.setVisible(true);
    }

    static {
        try {
            set_type = MathType.stringToType("Set(X, Y)");
        }
        catch (VisADException e2) {
            throw new VisADError(e2.getMessage());
        }
    }
}

