/*
 * Decompiled with CFR 0.152.
 */
package visad.browser;

public class Convert {
    private static final int RLE_ESCAPE = Integer.MIN_VALUE;
    public static final int PLACES = 3;

    public static byte[] intToBytes(int[] ints) {
        int len = ints.length;
        byte[] bytes = new byte[4 * len];
        int i = 0;
        while (i < len) {
            int q = ints[i];
            bytes[4 * i] = (byte)(q & 0xFF);
            bytes[4 * i + 1] = (byte)((q & 0xFF00) >> 8);
            bytes[4 * i + 2] = (byte)((q & 0xFF0000) >> 16);
            bytes[4 * i + 3] = (byte)((q & 0xFF000000) >> 24);
            ++i;
        }
        return bytes;
    }

    public static int[] bytesToInt(byte[] bytes) {
        int len = bytes.length / 4;
        int[] ints = new int[len];
        int i = 0;
        while (i < len) {
            int q3 = bytes[4 * i + 3] << 24;
            int q2 = bytes[4 * i + 2] << 16;
            int q1 = bytes[4 * i + 1] << 8;
            int q0 = bytes[4 * i];
            if (q2 < 0) {
                q2 += 0x1000000;
            }
            if (q1 < 0) {
                q1 += 65536;
            }
            if (q0 < 0) {
                q0 += 256;
            }
            ints[i] = q3 | q2 | q1 | q0;
            ++i;
        }
        return ints;
    }

    public static int[] encodeRLE(int[] array) {
        int len = array.length;
        int[] temp = new int[len];
        int p = 0;
        int i = 0;
        while (i < len) {
            int q = array[i];
            int count = 0;
            while (i < len && q == array[i]) {
                ++count;
                ++i;
            }
            if (count < 4) {
                int z = 0;
                while (z < count) {
                    temp[p++] = q;
                    ++z;
                }
                continue;
            }
            temp[p++] = Integer.MIN_VALUE;
            temp[p++] = q;
            temp[p++] = count;
        }
        int[] encoded = new int[p];
        System.arraycopy(temp, 0, encoded, 0, p);
        return encoded;
    }

    public static int[] decodeRLE(int[] array) {
        int count = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i] == Integer.MIN_VALUE) {
                count += array[i + 2];
                i += 3;
                continue;
            }
            ++count;
            ++i;
        }
        int[] decoded = new int[count];
        int p = 0;
        i = 0;
        while (i < array.length) {
            int q = array[i];
            if (q == Integer.MIN_VALUE) {
                int val = array[++i];
                int cnt = array[++i];
                int z = 0;
                while (z < cnt) {
                    decoded[p++] = val;
                    ++z;
                }
            } else {
                decoded[p++] = q;
            }
            ++i;
        }
        return decoded;
    }

    public static double getDouble(String s) {
        double d2 = Double.NaN;
        try {
            d2 = Double.valueOf(s);
        }
        catch (NumberFormatException exc) {}
        return d2;
    }

    public static float getFloat(String s) {
        float f;
        block2: {
            f = Float.NaN;
            if (s == null) break block2;
            try {
                f = Float.valueOf(s).floatValue();
            }
            catch (NumberFormatException exc) {}
        }
        return f;
    }

    public static boolean getBoolean(String s) {
        if (s == null) {
            return false;
        }
        char c2 = s.trim().charAt(0);
        return c2 == 'T' || c2 == 't';
    }

    public static int getInt(String s) {
        int i;
        block2: {
            i = 0;
            if (s == null) break block2;
            try {
                i = Integer.parseInt(s);
            }
            catch (NumberFormatException exc) {}
        }
        return i;
    }

    public static String shortString(double val) {
        boolean negative = val < 0.0;
        double orig_val = val;
        if ((val = Math.abs(val)) < 0.001) {
            int i = 1;
            while (i < 30) {
                val *= 10.0;
                orig_val *= 10.0;
                if (val >= 1.0) {
                    return Convert.shortString(orig_val) + "E-" + i;
                }
                ++i;
            }
        }
        int mult = 1;
        float round = 0.5f;
        int p = 3;
        while (p > 0) {
            mult *= 10;
            round /= 10.0f;
            --p;
        }
        long l = (long)((val + (double)round) * (double)mult);
        long preDot = l / (long)mult;
        int postDot = (int)(l % (long)mult);
        String num = preDot <= Integer.MAX_VALUE ? Integer.toString((int)preDot) : Long.toString(preDot);
        if (postDot == 0) {
            if (negative && preDot != 0L) {
                return "-" + num;
            }
            return num;
        }
        StringBuffer buf = new StringBuffer(num.length() + 5);
        if (negative) {
            buf.append('-');
        }
        buf.append(num);
        buf.append('.');
        num = Integer.toString(postDot);
        int nlen = num.length();
        int p2 = 3;
        while (p2 > nlen) {
            buf.append('0');
            --p2;
        }
        buf.append(num);
        return buf.toString();
    }
}

