/*
 * Decompiled with CFR 0.152.
 */
package visad.collab;

import visad.Control;
import visad.VisADException;
import visad.collab.MonitorEvent;

public class ControlMonitorEvent
extends MonitorEvent {
    private Control ctl;

    public ControlMonitorEvent(int type, Control ctl) throws VisADException {
        this(type, -1, ctl);
    }

    public ControlMonitorEvent(int type, int originator, Control ctl) throws VisADException {
        super(type, originator);
        if (type != 21 && type != 20) {
            throw new VisADException("Bad type for ControlMonitorEvent");
        }
        this.ctl = ctl;
    }

    public Control getControl() {
        return this.ctl;
    }

    public static String getControlKey(Control ctl) {
        return ctl.getClass().getName() + "#" + ctl.getInstanceNumber();
    }

    public String getKey() {
        return ControlMonitorEvent.getControlKey(this.ctl);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ControlMonitorEvent)) {
            return false;
        }
        ControlMonitorEvent evt = (ControlMonitorEvent)o;
        if (this.getType() != evt.getType()) {
            return false;
        }
        return this.ctl.equals(evt.ctl);
    }

    public Object clone() {
        ControlMonitorEvent evt;
        try {
            evt = new ControlMonitorEvent(this.getType(), this.getOriginator(), (Control)this.ctl.clone());
            evt.seqNum = this.seqNum;
        }
        catch (VisADException e2) {
            evt = null;
        }
        return evt;
    }

    public String toString() {
        int orig;
        StringBuffer buf = new StringBuffer("CMonEvt[");
        buf.append('#');
        buf.append(this.getSequenceNumber());
        buf.append(' ');
        if (this.getType() != 21) {
            buf.append(this.getTypeName());
        }
        if ((orig = this.getOriginator()) == -1) {
            buf.append(" Lcl");
        } else {
            buf.append("Rmt ");
            buf.append(orig);
        }
        buf.append(' ');
        buf.append(this.ctl);
        buf.append(']');
        return buf.toString();
    }
}

