/*
 * Decompiled with CFR 0.152.
 */
package visad.data.dods;

import dods.dap.BaseType;
import dods.dap.DAS;
import dods.dap.DSequence;
import dods.dap.NoSuchVariableException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SimpleSet;
import visad.Tuple;
import visad.TupleType;
import visad.Unit;
import visad.VisADError;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.FileAccessor;
import visad.data.FileFlatField;
import visad.data.dods.VariableAdapter;
import visad.data.dods.VariableAdapterFactory;

public class SequenceVariableAdapter
extends VariableAdapter {
    private FunctionType funcType;
    private VariableAdapter[] adapters;
    private SimpleSet[] repSets;

    private SequenceVariableAdapter(DSequence sequence, DAS das, VariableAdapterFactory factory) throws VisADException, RemoteException {
        int count = sequence.elementCount();
        ArrayList<SimpleSet> setList = new ArrayList<SimpleSet>();
        this.adapters = new VariableAdapter[count];
        int i = 0;
        while (i < count) {
            BaseType template;
            try {
                template = sequence.getVar(i);
            }
            catch (NoSuchVariableException e2) {
                throw new BadFormException(this.getClass().getName() + ".data(DSequence,...): " + "Couldn't get sequence-variable " + i);
            }
            this.adapters[i] = factory.variableAdapter(template, das);
            SimpleSet[] setArray = this.adapters[i].getRepresentationalSets(false);
            int j = 0;
            while (j < setArray.length) {
                setList.add(setArray[j]);
                ++j;
            }
            ++i;
        }
        this.funcType = new FunctionType(RealType.Generic, VariableAdapter.mathType(this.adapters));
        this.repSets = setList.toArray(new SimpleSet[0]);
    }

    public static SequenceVariableAdapter sequenceVariableAdapter(DSequence sequence, DAS das, VariableAdapterFactory factory) throws VisADException, RemoteException {
        return new SequenceVariableAdapter(sequence, das, factory);
    }

    public MathType getMathType() {
        return this.funcType;
    }

    public SimpleSet[] getRepresentationalSets(boolean copy) {
        return copy ? (SimpleSet[])this.repSets.clone() : this.repSets;
    }

    public DataImpl data(DSequence sequence, boolean copy) throws VisADException, RemoteException {
        FieldImpl field;
        Integer1DSet domain = new Integer1DSet(sequence.getRowCount());
        if (this.funcType.getFlat()) {
            field = new FileFlatField(new SequenceAccessor(domain, sequence), this.getCacheStrategy());
        } else {
            field = new FieldImpl(this.funcType, domain);
            this.setField(sequence, field, copy);
        }
        return field;
    }

    protected void setField(DSequence sequence, FieldImpl field, boolean copy) throws VisADException, RemoteException {
        int sampleCount = field.getLength();
        MathType rangeType = this.funcType.getRange();
        int i = 0;
        while (i < sampleCount) {
            int j;
            Data[] components;
            DataImpl data;
            Vector row = sequence.getRow(i);
            if (this.adapters.length == 1) {
                data = this.adapters[0].data((BaseType)row.get(0), copy);
            } else if (rangeType instanceof RealTupleType) {
                components = new Real[this.adapters.length];
                j = 0;
                while (j < components.length) {
                    components[j] = (Real)this.adapters[j].data((BaseType)row.get(j), copy);
                    ++j;
                }
                data = new RealTuple((RealTupleType)rangeType, (Real[])components, null);
            } else {
                components = new Data[this.adapters.length];
                j = 0;
                while (j < components.length) {
                    components[j] = this.adapters[j].data((BaseType)row.get(j), copy);
                    ++j;
                }
                data = new Tuple((TupleType)rangeType, components);
            }
            field.setSample(i, (Data)data, false);
            ++i;
        }
    }

    protected class SequenceAccessor
    extends FileAccessor {
        private final SampledSet domain;
        private final DSequence sequence;

        public SequenceAccessor(SampledSet domain, DSequence sequence) {
            this.domain = domain;
            this.sequence = sequence;
        }

        public FunctionType getFunctionType() {
            return SequenceVariableAdapter.this.funcType;
        }

        public FlatField getFlatField() throws VisADException, RemoteException {
            FlatField field = new FlatField(SequenceVariableAdapter.this.funcType, (Set)this.domain, (CoordinateSystem[])null, (Set[])SequenceVariableAdapter.this.repSets, (Unit[])null);
            SequenceVariableAdapter.this.setField(this.sequence, field, false);
            return field;
        }

        public void writeFlatField(double[][] values, FlatField template, int[] fileLocation) {
            throw new VisADError(this.getClass().getName() + ".writeFlatField(...): " + "Unimplemented method");
        }

        public double[][] readFlatField(FlatField template, int[] fileLocation) {
            throw new VisADError(this.getClass().getName() + ".readFlatField(...): " + "Unimplemented method");
        }

        public void writeFile(int[] fileLocation, Data range) {
            throw new VisADError(this.getClass().getName() + ".writeFile(...): " + "Unimplemented method");
        }
    }
}

