/*
 * Decompiled with CFR 0.152.
 */
package visad.data.dods;

import dods.dap.BaseType;
import dods.dap.DAS;
import dods.dap.DStructure;
import dods.dap.NoSuchVariableException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import visad.Data;
import visad.DataImpl;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.SimpleSet;
import visad.Tuple;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.dods.Adapter;
import visad.data.dods.VariableAdapter;
import visad.data.dods.VariableAdapterFactory;

public class StructureVariableAdapter
extends VariableAdapter {
    private final MathType mathType;
    private final VariableAdapter[] adapters;
    private final boolean isFlat;
    private final SimpleSet[] repSets;

    private StructureVariableAdapter(DStructure structure, DAS das, VariableAdapterFactory factory) throws BadFormException, VisADException, RemoteException {
        ArrayList<SimpleSet> setList = new ArrayList<SimpleSet>();
        this.adapters = new VariableAdapter[structure.elementCount()];
        int i = 0;
        while (i < this.adapters.length) {
            BaseType var;
            try {
                var = structure.getVar(i);
            }
            catch (NoSuchVariableException e2) {
                throw new BadFormException(this.getClass().getName() + ".data(...): " + "DStructure is missing variable " + i + ": " + e2);
            }
            this.adapters[i] = factory.variableAdapter(var, das);
            SimpleSet[] setArray = this.adapters[i].getRepresentationalSets(false);
            int j = 0;
            while (j < setArray.length) {
                setList.add(setArray[j]);
                ++j;
            }
            ++i;
        }
        this.mathType = VariableAdapter.mathType(this.adapters);
        this.isFlat = Adapter.isFlat(this.mathType);
        this.repSets = setList.toArray(new SimpleSet[0]);
    }

    public static StructureVariableAdapter structureVariableAdapter(DStructure structure, DAS das, VariableAdapterFactory factory) throws BadFormException, VisADException, RemoteException {
        return new StructureVariableAdapter(structure, das, factory);
    }

    public MathType getMathType() {
        return this.mathType;
    }

    public SimpleSet[] getRepresentationalSets(boolean copy) {
        return copy ? (SimpleSet[])this.repSets.clone() : this.repSets;
    }

    public DataImpl data(DStructure structure, boolean copy) throws BadFormException, VisADException, RemoteException {
        DataImpl data;
        try {
            if (this.adapters.length == 0) {
                data = null;
            } else if (this.adapters.length == 1) {
                data = this.adapters[0].data(structure.getVar(0), copy);
            } else if (this.isFlat) {
                Real[] components = new Real[this.adapters.length];
                int i = 0;
                while (i < this.adapters.length) {
                    components[i] = (Real)this.adapters[i].data(structure.getVar(i), copy);
                    ++i;
                }
                data = new RealTuple(components);
            } else {
                Data[] components = new DataImpl[this.adapters.length];
                int i = 0;
                while (i < this.adapters.length) {
                    components[i] = this.adapters[i].data(structure.getVar(i), copy);
                    ++i;
                }
                data = new Tuple(components);
            }
        }
        catch (NoSuchVariableException e2) {
            throw new BadFormException(this.getClass().getName() + ".data(...): " + "DStructure is missing variable: " + e2);
        }
        return data;
    }
}

