/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdfeos;

import visad.CoordinateSystem;
import visad.GridCoordinateSystem;
import visad.Gridded1DSet;
import visad.GriddedSet;
import visad.IntegerNDSet;
import visad.LinearNDSet;
import visad.MathType;
import visad.ProductSet;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SetException;
import visad.Unit;
import visad.VisADException;
import visad.data.hdfeos.Calibration;
import visad.data.hdfeos.DimensionSet;
import visad.data.hdfeos.EosStruct;
import visad.data.hdfeos.HdfeosException;
import visad.data.hdfeos.NamedDimension;
import visad.data.hdfeos.Variable;
import visad.data.hdfeos.VariableSet;

class HdfeosDomain {
    private EosStruct struct;
    static final int INTEGER = 0;
    static final int HYBRID = 1;
    static final int FACTORED = 2;
    static final int FACTORED_ARITH = 3;
    static final int UNFACTORED = 4;
    static final int LINEAR = 5;
    static final int SINGLE = 6;
    private int op;
    private NamedDimension[] domDims;
    private DimensionSet domDimSet = null;
    private Variable[] domVars;
    private int domainDim;
    private int manifoldDim;
    private int[] lengths = null;
    private int[] inv_lengths = null;
    private int[] num_type = null;
    private Calibration[] cal = null;
    private int n_samples;
    private float[][] samples;
    private String[] name_s = null;
    MathType mathtype = null;
    private CoordinateSystem coord_sys = null;
    private Unit[] units = null;
    private Set domainSet = null;
    private HdfeosDomain gridCoordSys = null;
    private boolean subRank;
    private int[] start = null;
    private int[] edge = null;
    private int[] stride = null;

    public HdfeosDomain(EosStruct struct, DimensionSet dimSet) throws VisADException {
        this(struct, dimSet.getElements(), null, null);
    }

    public HdfeosDomain(EosStruct struct, DimensionSet dimSet, CoordinateSystem coord_sys) throws VisADException {
        this(struct, dimSet.getElements(), coord_sys, null);
    }

    public HdfeosDomain(EosStruct struct, DimensionSet dimSet, CoordinateSystem coord_sys, Unit[] units) throws VisADException {
        this(struct, dimSet.getElements(), coord_sys, units);
    }

    public HdfeosDomain(EosStruct struct, NamedDimension dim) throws VisADException {
        NamedDimension[] dims = new NamedDimension[]{dim};
        this.initializeNoVars(struct, dims);
    }

    public HdfeosDomain(EosStruct struct, NamedDimension[] dims, CoordinateSystem coord_sys, Unit[] units) throws VisADException {
        this.coord_sys = coord_sys;
        this.units = units;
        this.initializeNoVars(struct, dims);
    }

    public HdfeosDomain(EosStruct struct, DimensionSet dimSet, HdfeosDomain gridCoordSys) throws VisADException {
        this.coord_sys = HdfeosDomain.getNullGridCoordinateSystem(gridCoordSys);
        this.gridCoordSys = gridCoordSys;
        this.initializeNoVars(struct, dimSet.getElements());
    }

    public static GridCoordinateSystem getNullGridCoordinateSystem(HdfeosDomain gridCoordSys) throws VisADException {
        RealTupleType reference = (RealTupleType)gridCoordSys.getType();
        int dim = reference.getDimension();
        int[] lens = new int[dim];
        int ii = 0;
        while (ii < dim) {
            lens[ii] = 2;
            ++ii;
        }
        IntegerNDSet set = new IntegerNDSet((MathType)reference, lens);
        GridCoordinateSystem c_sys = new GridCoordinateSystem(set);
        return c_sys;
    }

    private void initializeNoVars(EosStruct struct, NamedDimension[] dims) throws VisADException {
        this.struct = struct;
        this.domDims = dims;
        this.domainDim = dims.length;
        this.lengths = new int[this.domainDim];
        this.inv_lengths = new int[this.domainDim];
        this.manifoldDim = this.domainDim;
        this.name_s = new String[this.domainDim];
        this.domDimSet = new DimensionSet(dims);
        if (this.units == null) {
            this.units = new Unit[this.domainDim];
        }
        this.start = new int[this.manifoldDim];
        this.stride = new int[this.manifoldDim];
        this.edge = new int[this.manifoldDim];
        this.n_samples = 1;
        int ii = 0;
        while (ii < this.domainDim) {
            this.name_s[ii] = this.domDims[ii].getName();
            this.lengths[ii] = this.domDims[ii].getLength();
            this.n_samples *= this.lengths[ii];
            this.start[ii] = 0;
            this.edge[ii] = this.lengths[ii];
            this.stride[ii] = 1;
            ++ii;
        }
        int kk = 0;
        while (kk < this.domainDim) {
            this.inv_lengths[kk] = this.lengths[this.domainDim - 1 - kk];
            ++kk;
        }
        this.op = 5;
        this.subRank = false;
        this.mathtype = this.makeType(null);
    }

    public HdfeosDomain(EosStruct struct, Variable[] vars, NamedDimension[] dims) throws VisADException {
        this.initialize(struct, vars, dims);
    }

    public HdfeosDomain(EosStruct struct, VariableSet v_set, DimensionSet d_set) throws VisADException {
        this.domDimSet = d_set;
        this.initialize(struct, v_set.getElements(), d_set.getElements());
    }

    public HdfeosDomain(EosStruct struct, Variable var) throws VisADException {
        Variable[] vars = new Variable[1];
        NamedDimension[] dims = new NamedDimension[1];
        vars[0] = var;
        dims[0] = var.getDim(0);
        this.initialize(struct, vars, dims);
    }

    private void initialize(EosStruct struct, Variable[] vars, NamedDimension[] dims) throws VisADException {
        this.struct = struct;
        this.domVars = vars;
        int n_vars = vars.length;
        this.num_type = new int[n_vars];
        this.cal = new Calibration[n_vars];
        this.domDims = dims;
        int n_dims = dims.length;
        boolean all_1D = false;
        boolean one_1D = false;
        boolean all_eq = true;
        this.domainDim = vars.length;
        this.manifoldDim = dims.length;
        if (this.domDimSet == null) {
            this.domDimSet = new DimensionSet(dims);
        }
        this.name_s = new String[this.domainDim];
        if (this.units == null) {
            this.units = new Unit[this.domainDim];
        }
        if (this.domainDim == 1) {
            this.op = 6;
            this.subRank = false;
            this.start = new int[1];
            this.edge = new int[1];
            this.stride = new int[1];
            this.name_s[0] = this.domVars[0].getName();
            this.num_type[0] = this.domVars[0].getNumberType();
            this.cal[0] = this.domVars[0].getCalibration();
        } else {
            int v_rank = 1;
            int v_rank0 = this.domVars[0].getRank();
            int ii = 0;
            while (ii < n_vars) {
                v_rank = this.domVars[ii].getRank();
                if (n_dims != 1) {
                    all_1D = false;
                    if (v_rank != v_rank0) {
                        all_eq = false;
                    }
                } else {
                    one_1D = true;
                }
                this.name_s[ii] = this.domVars[ii].getName();
                this.num_type[ii] = this.domVars[ii].getNumberType();
                this.cal[ii] = this.domVars[ii].getCalibration();
                ++ii;
            }
            if (all_1D) {
                this.op = 2;
                this.subRank = false;
                this.start = new int[1];
                this.edge = new int[1];
                this.stride = new int[1];
            } else if (all_eq) {
                if (v_rank > this.manifoldDim) {
                    this.subRank = true;
                } else if (v_rank == this.manifoldDim) {
                    this.subRank = false;
                } else {
                    throw new HdfeosException("variables rank cannot be greater than manifoldDim");
                }
                this.op = 4;
                this.start = new int[v_rank];
                this.stride = new int[v_rank];
                this.edge = new int[v_rank];
            } else {
                throw new HdfeosException("undefined domain case");
            }
        }
        this.lengths = new int[this.manifoldDim];
        this.inv_lengths = new int[this.manifoldDim];
        this.n_samples = 1;
        int ii = 0;
        while (ii < this.manifoldDim) {
            this.lengths[ii] = this.domDims[ii].getLength();
            this.n_samples *= this.lengths[ii];
            ++ii;
        }
        int kk = 0;
        while (kk < this.manifoldDim) {
            this.inv_lengths[kk] = this.lengths[this.manifoldDim - 1 - kk];
            ++kk;
        }
        this.samples = new float[this.domainDim][this.n_samples];
        this.mathtype = this.makeType(null);
    }

    public DimensionSet getDimSet() {
        return this.domDimSet;
    }

    MathType makeType(CoordinateSystem coord_sys) throws VisADException {
        RealType[] r_types = new RealType[this.domainDim];
        int ii = 0;
        while (ii < this.domainDim) {
            int inv_ii = this.domainDim - 1 - ii;
            r_types[ii] = RealType.getRealType(this.name_s[inv_ii], this.units[inv_ii], null);
            ++ii;
        }
        if (r_types.length == 1) {
            return r_types[0];
        }
        if (coord_sys == null) {
            return new RealTupleType(r_types, this.coord_sys, null);
        }
        return new RealTupleType(r_types, coord_sys, null);
    }

    public MathType getType() throws VisADException {
        return this.mathtype;
    }

    public Set getData() throws VisADException {
        if (!this.subRank) {
            return this.getData(null);
        }
        throw new HdfeosException("getData(int[] indexes) must be used");
    }

    public Set getData(int[] indexes) throws VisADException {
        int cnt = 0;
        if (indexes == null) {
            if (this.subRank) {
                throw new HdfeosException("indexes cannot be null");
            }
            if (this.domainSet != null) {
                return this.domainSet;
            }
        } else {
            if (!this.subRank) {
                throw new HdfeosException("getData() must be used");
            }
            int ii = 0;
            while (ii < indexes.length) {
                this.start[cnt] = indexes[ii];
                this.edge[cnt] = 1;
                ++cnt;
                ++ii;
            }
        }
        SampledSet set = null;
        switch (this.op) {
            case 4: {
                int kk = 0;
                while (kk < this.domainDim) {
                    int ii = 0;
                    while (ii < this.manifoldDim) {
                        this.start[cnt + ii] = 0;
                        this.edge[cnt + ii] = this.lengths[ii];
                        this.stride[cnt + ii] = 1;
                        ++ii;
                    }
                    this.struct.readData(this.name_s[kk], this.start, this.stride, this.edge, this.num_type[kk], this.cal[kk], this.samples[kk]);
                    ++kk;
                }
                set = GriddedSet.create(this.mathtype, this.samples, this.inv_lengths);
                break;
            }
            case 6: {
                this.struct.readData(this.name_s[0], this.start, this.stride, this.edge, this.num_type[0], this.cal[0], this.samples[0]);
                set = new Gridded1DSet(this.mathtype, this.samples, this.lengths[0]);
                break;
            }
            case 5: {
                GriddedSet geo_domain;
                if (this.gridCoordSys == null) {
                    set = new IntegerNDSet(this.mathtype, this.lengths, null, null, null);
                    break;
                }
                try {
                    geo_domain = (GriddedSet)this.gridCoordSys.getData(indexes);
                }
                catch (SetException e2) {
                    System.out.println(this.gridCoordSys.getType().toString() + " " + e2.getMessage());
                    set = new IntegerNDSet(this.mathtype, this.lengths, null, null, null);
                    break;
                }
                int[] lens = geo_domain.getLengths();
                double[] firsts = new double[this.domainDim];
                double[] lasts = new double[this.domainDim];
                int ii = 0;
                while (ii < this.domainDim) {
                    firsts[ii] = 0.0;
                    lasts[ii] = lens[ii];
                    ++ii;
                }
                GridCoordinateSystem c_sys = new GridCoordinateSystem(geo_domain);
                set = new LinearNDSet(this.mathtype, firsts, lasts, this.lengths, c_sys, null, null);
                break;
            }
            case 2: {
                SampledSet[] sets = new SampledSet[this.domainDim];
                int kk = 0;
                while (kk < this.domainDim) {
                    this.start[0] = 0;
                    this.edge[0] = this.lengths[kk];
                    this.stride[0] = 1;
                    this.struct.readData(this.name_s[kk], this.start, this.stride, this.edge, this.num_type[kk], this.cal[kk], this.samples[kk]);
                    sets[kk] = new Gridded1DSet(this.mathtype, this.samples, this.lengths[kk]);
                    ++kk;
                }
                set = new ProductSet(this.mathtype, sets);
            }
        }
        if (!this.subRank) {
            this.domainSet = set;
        }
        return set;
    }

    public EosStruct getStruct() {
        return this.struct;
    }
}

