/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;

public class FileDialogPanel
extends Panel {
    private String pathname;

    public FileDialogPanel(String filter, String initialPathname) {
        super(new GridBagLayout());
        this.pathname = initialPathname;
        Component folderComponent = this.newFolderComponent();
        Component filterComponent = this.newFilterComponent(filter);
        Component filesListComponent = this.newFilesListComponent();
        Component foldersListComponent = this.newFoldersListComponent();
        Component fileComponent = this.newFileComponent(initialPathname);
        Component buttonsComponent = this.newButtonsComponent();
        this.addComponent(folderComponent, 0, 0, 2);
        this.addComponent(filterComponent, 0, 1, 2);
        this.addComponent(filesListComponent, 1, 1, 1);
        this.addComponent(foldersListComponent, 0, 2, 1);
        this.addComponent(fileComponent, 0, 3, 2);
        this.addComponent(buttonsComponent, 0, 4, 2);
        this.validate();
        this.setSize(this.getPreferredSize());
    }

    protected void addComponent(Component component, int gridx, int gridy, int fill) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.fill = fill;
        ((GridBagLayout)this.getLayout()).setConstraints(component, gbc);
        this.add(component);
    }

    protected Component newFolderComponent() {
        return this.newTextComponent("Enter path or folder name:", System.getProperty("user.dir"));
    }

    protected Component newFilterComponent(String pattern) {
        return this.newTextComponent("Filter", pattern);
    }

    protected Component newFilesListComponent() {
        return this.newListComponent("Files", new String[]{"file1", "file2"});
    }

    protected Component newFoldersListComponent() {
        return this.newListComponent("Folders", new String[]{"folder1", "folder2"});
    }

    protected Component newFileComponent(String initialPathname) {
        return this.newTextComponent("Enter file name:", initialPathname);
    }

    protected Component newButtonsComponent() {
        Panel panel = new Panel(new GridBagLayout());
        this.addButton(panel, new Button("Update"));
        this.addButton(panel, new Button("Reset"));
        return panel;
    }

    protected void addButton(Panel panel, Button button) {
        GridBagConstraints gbc = new GridBagConstraints();
        ((GridBagLayout)panel.getLayout()).setConstraints(button, gbc);
        panel.add(button);
    }

    protected Component newListComponent(String title, String[] items) {
        List list = new List(items.length);
        int i = 0;
        while (i < items.length) {
            list.add(items[i]);
            ++i;
        }
        return this.newLabeledComponent(title, list);
    }

    protected Component newTextComponent(String title, String initialText) {
        return this.newLabeledComponent(title, new TextField(initialText, 20));
    }

    protected Component newLabeledComponent(String title, Component component) {
        BorderLayout lm = new BorderLayout();
        Panel panel = new Panel(lm);
        Label label = new Label(title, 0);
        lm.addLayoutComponent(label, "North");
        panel.add(label);
        lm.addLayoutComponent(component, "South");
        panel.add(component);
        return panel;
    }

    public String getFile() {
        return this.pathname;
    }

    public void setFile(String pathname) {
        this.pathname = pathname;
    }

    public static void main(String[] args) {
        Frame frame = new Frame("FileDialogPanel Test");
        FileDialogPanel fileDialog = new FileDialogPanel("*.*", "dummy.ext");
        frame.add(fileDialog);
        frame.show();
    }
}

