/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf;

import visad.RealType;
import visad.SimpleSet;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;
import visad.data.units.ParseException;
import visad.data.units.Parser;

public class Quantity
extends RealType {
    protected final String unitSpec;

    public Quantity(String name, String unitSpec, SimpleSet set) throws VisADException, ParseException {
        super(name, Parser.parse(unitSpec), set, 0, false);
        this.unitSpec = unitSpec;
    }

    public Quantity(String name, String unitSpec) throws VisADException, ParseException {
        this(name, unitSpec, null);
    }

    Quantity(RealType realType) throws VisADException {
        super(realType.getName(), realType.getDefaultUnit(), true);
        Unit unit = realType.getDefaultUnit();
        this.unitSpec = unit == null ? null : unit.toString();
    }

    public String getDefaultUnitString() {
        return this.unitSpec;
    }

    public static Quantity getQuantity(String name, String unitSpec, SimpleSet set) throws ParseException {
        try {
            return new Quantity(name, unitSpec, set);
        }
        catch (TypeException e2) {
            return Quantity.getQuantityByName(name);
        }
        catch (VisADException e3) {
            return null;
        }
    }

    public static Quantity getQuantity(String name, String unitSpec) throws ParseException {
        return Quantity.getQuantity(name, unitSpec, null);
    }

    public static Quantity getQuantityByName(String name) {
        RealType quant = RealType.getRealTypeByName(name);
        if (!(quant instanceof Quantity)) {
            try {
                return new Quantity(quant);
            }
            catch (VisADException ve) {
                return null;
            }
        }
        return (Quantity)quant;
    }
}

