/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf;

import java.io.Serializable;
import java.text.CollationKey;
import java.text.Collator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import visad.DerivedUnit;
import visad.PromiscuousUnit;
import visad.QuantityDimension;
import visad.RealType;
import visad.TypeException;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;
import visad.data.netcdf.Quantity;
import visad.data.netcdf.QuantityDB;
import visad.data.netcdf.UnsupportedOperationException;
import visad.data.units.ParseException;
import visad.data.units.Parser;

public class QuantityDBImpl
extends QuantityDB
implements Serializable {
    private final SortedSet quantitySet = new TreeSet();
    private final TreeMap nameMap = new TreeMap();
    private final TreeMap unitMap = new TreeMap();
    private static final String minName = "";
    private static final String maxName = "zzz";
    private static final Unit minUnit = new DerivedUnit();
    private static final Unit maxUnit = new DerivedUnit();
    private QuantityDB nextDB;

    public QuantityDBImpl(QuantityDB nextDB) {
        this.nextDB = nextDB;
    }

    public QuantityDB add(String[] definitions, String[] aliases) throws ParseException, TypeException, VisADException {
        int i = 0;
        while (i < definitions.length) {
            this.add(definitions[i], definitions[i + 1]);
            i += 2;
        }
        int i2 = 0;
        while (i2 < aliases.length) {
            this.add(aliases[i2], this.get(aliases[i2 + 1]));
            i2 += 2;
        }
        return this;
    }

    public synchronized void add(String name, Quantity quantity) throws VisADException {
        if (name == null || quantity == null) {
            throw new VisADException("add(): null argument");
        }
        Unit unit = quantity.getDefaultUnit();
        this.quantitySet.add(quantity);
        this.nameMap.put(new NameKey(name), quantity);
        this.unitMap.put(new UnitKey(unit, quantity.getName()), quantity);
    }

    public QuantityDB add(Quantity[] quantities) throws VisADException {
        int i = 0;
        while (i < quantities.length) {
            Quantity quantity = quantities[i];
            this.add(quantity);
            ++i;
        }
        return this;
    }

    protected synchronized void add(String name, String unitSpec) throws ParseException, TypeException, VisADException {
        block3: {
            try {
                this.add(name, new Quantity(name, unitSpec));
            }
            catch (VisADException e2) {
                if (!(e2 instanceof TypeException)) {
                    throw e2;
                }
                RealType realType = RealType.getRealTypeByName(name);
                if (realType != null && Unit.canConvert(realType.getDefaultUnit(), Parser.parse(unitSpec))) break block3;
                throw (TypeException)e2;
            }
        }
    }

    public java.util.Iterator quantityIterator() {
        return new QuantityIterator();
    }

    public java.util.Iterator nameIterator() {
        return new NameIterator();
    }

    public synchronized Quantity get(String name) {
        Quantity quantity = (Quantity)this.nameMap.get(new NameKey(name));
        return quantity != null ? quantity : (this.nextDB == null ? null : this.nextDB.get(name));
    }

    public synchronized Quantity[] get(Unit unit) {
        Quantity[] myQuantities = this.unitMap.subMap(new UnitKey(unit, minName), new UnitKey(unit, maxName)).values().toArray(new Quantity[0]);
        Quantity[] nextQuantities = this.nextDB == null ? new Quantity[]{} : this.nextDB.get(unit);
        Quantity[] quantities = new Quantity[myQuantities.length + nextQuantities.length];
        System.arraycopy(myQuantities, 0, quantities, 0, myQuantities.length);
        System.arraycopy(nextQuantities, 0, quantities, myQuantities.length, nextQuantities.length);
        myQuantities = null;
        nextQuantities = null;
        return quantities;
    }

    protected static final class UnitKey
    extends NameKey {
        protected final Unit unit;

        protected UnitKey(Unit unit, String name) {
            super(name);
            this.unit = unit;
        }

        public int compareTo(Object obj) throws ClassCastException {
            UnitKey that = (UnitKey)obj;
            int i = this.compare(this.unit, that.unit);
            return i != 0 ? i : super.compareTo(that);
        }

        private int compare(Unit a2, Unit b2) throws ClassCastException {
            int comparison;
            if (a2 instanceof PromiscuousUnit || b2 instanceof PromiscuousUnit) {
                comparison = 0;
            } else if (a2 == null || b2 == null) {
                comparison = a2 == null && b2 == null ? 0 : (a2 == null ? -1 : 1);
            } else {
                try {
                    comparison = a2 == b2 ? 0 : (a2 == minUnit || b2 == maxUnit ? -1 : (a2 == maxUnit || b2 == minUnit ? 1 : new QuantityDimension(a2).compareTo(new QuantityDimension(b2))));
                }
                catch (UnitException e2) {
                    throw new ClassCastException(e2.getMessage());
                }
            }
            return comparison;
        }
    }

    protected static class NameKey
    implements Serializable,
    Comparable {
        private final String name;
        private static final Collator collator = Collator.getInstance();
        private final CollationKey nameCookie;

        protected NameKey(String name) {
            this.name = name;
            this.nameCookie = collator.getCollationKey(name);
        }

        public int compareTo(Object obj) throws ClassCastException {
            return this.nameCookie.compareTo(((NameKey)obj).nameCookie);
        }

        public String getName() {
            return this.name;
        }

        static {
            collator.setStrength(0);
        }
    }

    protected class NameIterator
    extends Iterator {
        protected NameIterator() {
            this.iterator = QuantityDBImpl.this.nameMap.keySet().iterator();
        }

        protected Object nextObject() {
            return ((NameKey)this.iterator.next()).getName();
        }

        protected java.util.Iterator nextIterator() {
            return QuantityDBImpl.this.nextDB.nameIterator();
        }
    }

    protected class QuantityIterator
    extends Iterator {
        protected QuantityIterator() {
            this.iterator = QuantityDBImpl.this.quantitySet.iterator();
        }

        protected Object nextObject() {
            return this.iterator.next();
        }

        protected java.util.Iterator nextIterator() {
            return QuantityDBImpl.this.nextDB.quantityIterator();
        }
    }

    protected abstract class Iterator
    implements java.util.Iterator {
        protected java.util.Iterator iterator;
        private boolean canSwitch;

        protected Iterator() {
            this.canSwitch = QuantityDBImpl.this.nextDB != null;
        }

        public boolean hasNext() {
            boolean have = this.iterator.hasNext();
            if (!have && this.doSwitch()) {
                have = this.hasNext();
            }
            return have;
        }

        protected abstract Object nextObject();

        public Object next() {
            Object object;
            try {
                object = this.nextObject();
            }
            catch (NoSuchElementException e2) {
                if (!this.doSwitch()) {
                    throw e2;
                }
                object = this.next();
            }
            return object;
        }

        protected abstract java.util.Iterator nextIterator();

        protected boolean doSwitch() {
            boolean goodSwitch;
            if (!this.canSwitch) {
                goodSwitch = false;
            } else {
                this.iterator = this.nextIterator();
                this.canSwitch = false;
                goodSwitch = true;
            }
            return goodSwitch;
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("remove(): Can't remove elements from quantity database");
        }
    }
}

