/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf.in;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import ucar.netcdf.Dimension;
import ucar.netcdf.Netcdf;
import ucar.netcdf.Variable;
import ucar.netcdf.VariableIterator;
import visad.CoordinateSystem;
import visad.Gridded1DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.IntegerNDSet;
import visad.Linear1DSet;
import visad.LinearLatLonSet;
import visad.LinearNDSet;
import visad.LinearSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.TextType;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;
import visad.data.netcdf.QuantityDB;
import visad.data.netcdf.in.View;
import visad.data.netcdf.in.VirtualData;
import visad.data.netcdf.in.VirtualDataIterator;
import visad.data.netcdf.in.VirtualField;
import visad.data.netcdf.in.VirtualReal;
import visad.data.netcdf.in.VirtualScalar;
import visad.data.netcdf.in.VirtualText;
import visad.data.netcdf.in.VirtualTuple;

public class DefaultView
extends View {
    private final DimsToSet dimsToSet = new DimsToSet();

    public DefaultView(Netcdf netcdf, QuantityDB quantityDB) {
        this(netcdf, quantityDB, false);
    }

    public DefaultView(Netcdf netcdf, QuantityDB quantityDB, boolean charToText) {
        super(netcdf, quantityDB, charToText);
    }

    protected boolean isIgnorable(Variable var) {
        return this.isCoordinateVariable(var);
    }

    protected View.Domain getDomain(Variable var) throws TypeException, IOException {
        return new DefaultDomain(var);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SampledSet getDomainSet(Dimension[] dims) throws IOException, VisADException {
        GriddedSet set;
        if (dims.length == 0) {
            return this.getDomainSet(dims[0]);
        }
        DimsToSet dimsToSet = this.dimsToSet;
        synchronized (dimsToSet) {
            set = this.dimsToSet.get(dims);
            if (set == null) {
                Gridded1DSet[] sets = new Gridded1DSet[dims.length];
                int j = dims.length;
                int i = 0;
                while (i < dims.length) {
                    sets[--j] = this.getDomainSet(dims[i]);
                    ++i;
                }
                boolean allInteger1DSets = true;
                int i2 = 0;
                while (allInteger1DSets && i2 < sets.length) {
                    allInteger1DSets = sets[i2] instanceof Integer1DSet;
                    ++i2;
                }
                MathType type = this.getDomainType(dims);
                if (allInteger1DSets) {
                    set = DefaultView.getIntegerSet(sets, type);
                } else {
                    boolean allLinear1DSets = true;
                    int i3 = 0;
                    while (allLinear1DSets && i3 < sets.length) {
                        allLinear1DSets = sets[i3] instanceof Linear1DSet;
                        ++i3;
                    }
                    set = allLinear1DSets ? (GriddedSet)((Object)this.getLinearSet(sets, type)) : DefaultView.getGriddedSet(sets, type);
                }
                this.dimsToSet.put(dims, set);
            }
        }
        return set;
    }

    private static GriddedSet getIntegerSet(Gridded1DSet[] sets, MathType type) throws VisADException {
        int rank = sets.length;
        int[] lengths = new int[rank];
        int idim = 0;
        while (idim < rank) {
            lengths[idim] = ((Integer1DSet)sets[idim]).getLength(0);
            ++idim;
        }
        return IntegerNDSet.create(type, lengths, null, null, null);
    }

    private LinearSet getLinearSet(Gridded1DSet[] sets, MathType type) throws VisADException {
        RealType[] types;
        LinearSet set = null;
        int rank = sets.length;
        double[] firsts = new double[rank];
        double[] lasts = new double[rank];
        int[] lengths = new int[rank];
        Unit[] units = new Unit[rank];
        int idim = 0;
        while (idim < rank) {
            Linear1DSet linear1DSet = (Linear1DSet)sets[idim];
            firsts[idim] = linear1DSet.getFirst();
            lengths[idim] = linear1DSet.getLength(0);
            lasts[idim] = linear1DSet.getLast();
            units[idim] = linear1DSet.getSetUnits()[0];
            ++idim;
        }
        if (rank == 2 && (this.isLongitude((types = ((RealTupleType)type).getRealComponents())[0]) && this.isLatitude(types[1]) || this.isLongitude(types[1]) && this.isLatitude(types[0]))) {
            set = new LinearLatLonSet(type, firsts[0], lasts[0], lengths[0], firsts[1], lasts[1], lengths[1], null, units, null);
        }
        if (set == null) {
            set = LinearNDSet.create(type, firsts, lasts, lengths, (CoordinateSystem)null, units, null);
        }
        return set;
    }

    private static GriddedSet getGriddedSet(Gridded1DSet[] sets, MathType type) throws VisADException, IOException {
        int rank = sets.length;
        int[] lengths = new int[rank];
        float[][] values = new float[rank][];
        int ntotal = 1;
        int idim = 0;
        while (idim < rank) {
            lengths[idim] = sets[idim].getLength(0);
            ntotal *= lengths[idim];
            ++idim;
        }
        int step = 1;
        int laststep = 1;
        int idim2 = 0;
        while (idim2 < rank) {
            float[] vals = sets[idim2].getSamples(false)[0];
            values[idim2] = new float[ntotal];
            step *= lengths[idim2];
            int i = 0;
            while (i < lengths[idim2]) {
                int istep = i * laststep;
                int j = 0;
                while (j < ntotal) {
                    int k = 0;
                    while (k < laststep) {
                        values[idim2][istep + j + k] = vals[i];
                        ++k;
                    }
                    j += step;
                }
                ++i;
            }
            laststep = step;
            ++idim2;
        }
        Unit[] units = new Unit[rank];
        int idim3 = 0;
        while (idim3 < rank) {
            units[idim3] = sets[idim3].getSetUnits()[0];
            ++idim3;
        }
        return GriddedSet.create(type, values, lengths, null, units, null);
    }

    protected MathType getDomainType(Dimension[] dims) throws VisADException {
        MathType type;
        int rank = dims.length;
        if (rank == 0) {
            type = null;
        } else if (rank == 1) {
            type = this.getRealType(dims[0]);
        } else {
            RealType[] types = new RealType[dims.length];
            int j = dims.length;
            int i = 0;
            while (i < dims.length) {
                types[--j] = this.getRealType(dims[i]);
                ++i;
            }
            type = new RealTupleType(types);
        }
        return type;
    }

    private static class DimsToSet {
        private Map map = Collections.synchronizedMap(new WeakHashMap());

        DimsToSet() {
        }

        void put(Dimension[] dims, GriddedSet set) {
            if (dims.length == 1) {
                this.map.put(dims[0], set);
            } else {
                this.map.put(new DimArray(dims), set);
            }
        }

        GriddedSet get(Dimension[] dims) {
            return dims.length == 1 ? (GriddedSet)this.map.get(dims[0]) : (GriddedSet)this.map.get(new DimArray(dims));
        }

        private static class DimArray {
            private Dimension[] dims;
            private volatile int hashCode;

            DimArray(Dimension[] dims) {
                this.dims = (Dimension[])dims.clone();
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof DimArray)) {
                    return false;
                }
                return Arrays.equals(this.dims, ((DimArray)obj).dims);
            }

            public int hashCode() {
                int hash = this.hashCode;
                if (hash == 0) {
                    hash = 1;
                    int i = 0;
                    while (i < this.dims.length) {
                        hash = hash * 31 + this.dims[i].hashCode();
                        ++i;
                    }
                    this.hashCode = hash;
                }
                return hash;
            }
        }
    }

    private final class DefaultDomain
    extends View.Domain {
        private final Dimension[] dims;
        private volatile int hashCode;
        private volatile SampledSet domainSet;

        DefaultDomain(Variable var) throws TypeException {
            super(DefaultView.this, var);
            this.dims = DefaultView.this.getDimensions(var);
        }

        protected VirtualField getVirtualField(VirtualTuple range) throws VisADException, IOException {
            VirtualField field;
            int rank = this.dims.length;
            if (rank == 2 && range.getType() instanceof TextType) {
                field = VirtualField.newVirtualField(DefaultView.this.getDomainSet(this.dims[0]), range);
            } else if (rank == 1 || !DefaultView.this.isTime(this.dims[0])) {
                field = VirtualField.newVirtualField(DefaultView.this.getDomainSet(this.dims), range);
            } else {
                Dimension[] innerDims = new Dimension[rank - 1];
                System.arraycopy(this.dims, 1, innerDims, 0, innerDims.length);
                field = VirtualField.newVirtualField(DefaultView.this.getDomainSet(this.dims[0]), new VirtualTuple(VirtualField.newVirtualField(DefaultView.this.getDomainSet(innerDims), range)));
            }
            return field;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof DefaultDomain)) {
                return false;
            }
            return Arrays.equals(this.dims, ((DefaultDomain)obj).dims);
        }

        public int hashCode() {
            int hash = this.hashCode;
            if (hash == 0) {
                hash = 1;
                int i = 0;
                while (i < this.dims.length) {
                    hash = hash * 31 + this.dims[i].hashCode();
                    ++i;
                }
                this.hashCode = hash;
            }
            return hash;
        }
    }

    final class DefaultDataIterator
    extends VirtualDataIterator {
        private final VariableIterator varIter;

        DefaultDataIterator() {
            super(DefaultView.this);
            this.varIter = DefaultView.this.getNetcdf().iterator();
        }

        protected VirtualData getData() throws TypeException, VisADException, IOException {
            while (this.varIter.hasNext()) {
                Variable var = this.varIter.next();
                if (!DefaultView.this.isNumeric(var) && (!DefaultView.this.isCharToText() || var.getRank() > 2) || DefaultView.this.isIgnorable(var)) continue;
                VirtualScalar scalar = DefaultView.this.isNumeric(var) ? new VirtualReal(DefaultView.this.getRealType(var), var, DefaultView.this.getRangeSet(var), DefaultView.this.getUnitFromAttribute(var), DefaultView.this.getVetter(var)) : new VirtualText(DefaultView.this.getTextType(var), var);
                return var.getRank() == 0 || !DefaultView.this.isNumeric(var) && var.getRank() == 1 ? scalar : DefaultView.this.getDomain(var).getVirtualField(new VirtualTuple(scalar));
            }
            return null;
        }
    }
}

