/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad;

import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.Delaunay;
import visad.DoubleSet;
import visad.ErrorEstimate;
import visad.FieldImpl;
import visad.FlatField;
import visad.FloatSet;
import visad.FunctionType;
import visad.Gridded1DDoubleSet;
import visad.Gridded1DSet;
import visad.Gridded2DDoubleSet;
import visad.Gridded2DSet;
import visad.Gridded3DDoubleSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Integer2DSet;
import visad.Integer3DSet;
import visad.IntegerNDSet;
import visad.Irregular1DSet;
import visad.Irregular2DSet;
import visad.Irregular3DSet;
import visad.IrregularSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearLatLonSet;
import visad.LinearNDSet;
import visad.List1DSet;
import visad.ProductSet;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SetType;
import visad.SimpleSet;
import visad.SingletonSet;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.UnimplementedException;
import visad.UnionSet;
import visad.Unit;
import visad.VisADException;
import visad.data.BaseDataProcessor;
import visad.data.visad.object.BinaryFieldImpl;
import visad.data.visad.object.BinaryFlatField;
import visad.data.visad.object.BinaryGriddedDoubleSet;
import visad.data.visad.object.BinaryGriddedSet;
import visad.data.visad.object.BinaryIntegerSet;
import visad.data.visad.object.BinaryIrregularSet;
import visad.data.visad.object.BinaryLinearSet;
import visad.data.visad.object.BinaryList1DSet;
import visad.data.visad.object.BinaryProductSet;
import visad.data.visad.object.BinaryReal;
import visad.data.visad.object.BinaryRealTuple;
import visad.data.visad.object.BinarySimpleSet;
import visad.data.visad.object.BinarySingletonSet;
import visad.data.visad.object.BinarySize;
import visad.data.visad.object.BinaryText;
import visad.data.visad.object.BinaryTuple;
import visad.data.visad.object.BinaryUnionSet;
import visad.data.visad.object.BinaryUnknown;

public class BinarySizer
extends BaseDataProcessor {
    private BinarySize size = new BinarySize();

    public final int getSize() {
        return this.size.get();
    }

    public void processDoubleSet(SetType type, CoordinateSystem cs, Unit[] units, DoubleSet set, Object token) throws VisADException {
        int bytes = BinarySimpleSet.computeBytes(cs, units);
        this.size.add(bytes);
    }

    public void processFieldImpl(FunctionType type, Set set, FieldImpl fld, Object token) throws VisADException {
        int bytes = BinaryFieldImpl.computeBytes(fld);
        this.size.add(bytes);
    }

    public void processFlatField(FunctionType type, Set domainSet, CoordinateSystem cs, CoordinateSystem[] rangeCS, Set[] rangeSets, Unit[] units, FlatField fld, Object token) throws VisADException {
        int bytes = BinaryFlatField.computeBytes(domainSet, cs, rangeCS, rangeSets, units, fld);
        this.size.add(bytes);
    }

    public void processFloatSet(SetType type, CoordinateSystem cs, Unit[] units, FloatSet set, Object token) throws VisADException {
        int bytes = BinarySimpleSet.computeBytes(cs, units);
        this.size.add(bytes);
    }

    public void processGridded1DDoubleSet(SetType type, double[][] samples, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Gridded1DDoubleSet set, Object token) throws VisADException {
        int bytes = BinaryGriddedDoubleSet.computeBytes(samples, lengths, cs, units, errors);
        this.size.add(bytes);
    }

    public void processGridded2DDoubleSet(SetType type, double[][] samples, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Gridded2DDoubleSet set, Object token) throws VisADException {
        int bytes = BinaryGriddedDoubleSet.computeBytes(samples, lengths, cs, units, errors);
        this.size.add(bytes);
    }

    public void processGridded3DDoubleSet(SetType type, double[][] samples, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Gridded3DDoubleSet set, Object token) throws VisADException {
        int bytes = BinaryGriddedDoubleSet.computeBytes(samples, lengths, cs, units, errors);
        this.size.add(bytes);
    }

    public void processGridded1DSet(SetType type, float[][] samples, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Gridded1DSet set, Object token) throws VisADException {
        int bytes = BinaryGriddedSet.computeBytes(samples, lengths, cs, units, errors);
        this.size.add(bytes);
    }

    public void processGridded2DSet(SetType type, float[][] samples, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Gridded2DSet set, Object token) throws VisADException {
        int bytes = BinaryGriddedSet.computeBytes(samples, lengths, cs, units, errors);
        this.size.add(bytes);
    }

    public void processGridded3DSet(SetType type, float[][] samples, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Gridded3DSet set, Object token) throws VisADException {
        int bytes = BinaryGriddedSet.computeBytes(samples, lengths, cs, units, errors);
        this.size.add(bytes);
    }

    public void processGriddedSet(SetType type, float[][] samples, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, GriddedSet set, Object token) throws VisADException {
        int bytes = BinaryGriddedSet.computeBytes(samples, lengths, cs, units, errors);
        this.size.add(bytes);
    }

    public void processInteger1DSet(SetType type, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Integer1DSet set, Object token) throws VisADException {
        int bytes = BinaryIntegerSet.computeBytes(true, lengths, null, cs, units, errors);
        this.size.add(bytes);
    }

    public void processInteger2DSet(SetType type, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Integer2DSet set, Object token) throws VisADException {
        Integer1DSet[] comps = BinaryIntegerSet.getComponents(set);
        boolean matchedTypes = BinaryIntegerSet.hasMatchedTypes(type, comps);
        int bytes = BinaryIntegerSet.computeBytes(matchedTypes, lengths, comps, cs, units, errors);
        this.size.add(bytes);
    }

    public void processInteger3DSet(SetType type, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Integer3DSet set, Object token) throws VisADException {
        Integer1DSet[] comps = BinaryIntegerSet.getComponents(set);
        boolean matchedTypes = BinaryIntegerSet.hasMatchedTypes(type, comps);
        int bytes = BinaryIntegerSet.computeBytes(matchedTypes, lengths, comps, cs, units, errors);
        this.size.add(bytes);
    }

    public void processIntegerNDSet(SetType type, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, IntegerNDSet set, Object token) throws VisADException {
        Integer1DSet[] comps = BinaryIntegerSet.getComponents(set);
        boolean matchedTypes = BinaryIntegerSet.hasMatchedTypes(type, comps);
        int bytes = BinaryIntegerSet.computeBytes(matchedTypes, lengths, comps, cs, units, errors);
        this.size.add(bytes);
    }

    public void processIrregular1DSet(SetType type, float[][] samples, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Irregular1DSet set, Object token) throws VisADException {
        int bytes = BinaryIrregularSet.computeBytes(samples, cs, units, errors, null);
        this.size.add(bytes);
    }

    public void processIrregular2DSet(SetType type, float[][] samples, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Delaunay delaunay, Irregular2DSet set, Object token) throws VisADException {
        int bytes = BinaryIrregularSet.computeBytes(samples, cs, units, errors, delaunay);
        this.size.add(bytes);
    }

    public void processIrregular3DSet(SetType type, float[][] samples, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Delaunay delaunay, Irregular3DSet set, Object token) throws VisADException {
        int bytes = BinaryIrregularSet.computeBytes(samples, cs, units, errors, delaunay);
        this.size.add(bytes);
    }

    public void processIrregularSet(SetType type, float[][] samples, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Delaunay delaunay, IrregularSet set, Object token) throws VisADException {
        int bytes = BinaryIrregularSet.computeBytes(samples, cs, units, errors, delaunay);
        this.size.add(bytes);
    }

    public void processLinear1DSet(SetType type, double[] firsts, double[] lasts, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Linear1DSet set, Object token) throws VisADException {
        int bytes = BinaryLinearSet.computeBytes(true, firsts, lasts, lengths, null, cs, units, errors);
        this.size.add(bytes);
    }

    public void processLinear2DSet(SetType type, double[] firsts, double[] lasts, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Linear2DSet set, Object token) throws VisADException {
        Linear1DSet[] comps = new Linear1DSet[2];
        int i = 0;
        while (i < comps.length) {
            comps[i] = set.getLinear1DComponent(i);
            ++i;
        }
        boolean matchedTypes = BinaryLinearSet.hasMatchedTypes(type, comps);
        int bytes = BinaryLinearSet.computeBytes(matchedTypes, firsts, lasts, lengths, comps, cs, units, errors);
        this.size.add(bytes);
    }

    public void processLinear3DSet(SetType type, double[] firsts, double[] lasts, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, Linear3DSet set, Object token) throws VisADException {
        Linear1DSet[] comps = new Linear1DSet[3];
        int i = 0;
        while (i < comps.length) {
            comps[i] = set.getLinear1DComponent(i);
            ++i;
        }
        boolean matchedTypes = BinaryLinearSet.hasMatchedTypes(type, comps);
        int bytes = BinaryLinearSet.computeBytes(matchedTypes, firsts, lasts, lengths, comps, cs, units, errors);
        this.size.add(bytes);
    }

    public void processLinearLatLonSet(SetType type, double[] firsts, double[] lasts, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, LinearLatLonSet set, Object token) throws VisADException {
        Linear1DSet[] comps = new Linear1DSet[2];
        int i = 0;
        while (i < comps.length) {
            comps[i] = set.getLinear1DComponent(i);
            ++i;
        }
        boolean matchedTypes = BinaryLinearSet.hasMatchedTypes(type, comps);
        int bytes = BinaryLinearSet.computeBytes(matchedTypes, firsts, lasts, lengths, comps, cs, units, errors);
        this.size.add(bytes);
    }

    public void processLinearNDSet(SetType type, double[] firsts, double[] lasts, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, LinearNDSet set, Object token) throws VisADException {
        Linear1DSet[] comps = new Linear1DSet[set.getDimension()];
        int i = 0;
        while (i < comps.length) {
            comps[i] = set.getLinear1DComponent(i);
            ++i;
        }
        boolean matchedTypes = BinaryLinearSet.hasMatchedTypes(type, comps);
        int bytes = BinaryLinearSet.computeBytes(matchedTypes, firsts, lasts, lengths, comps, cs, units, errors);
        this.size.add(bytes);
    }

    public void processList1DSet(SetType type, float[] list, CoordinateSystem cs, Unit[] units, List1DSet set, Object token) throws VisADException {
        int bytes = BinaryList1DSet.computeBytes(list, cs, units);
        this.size.add(bytes);
    }

    public void processProductSet(SetType type, SampledSet[] sets, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, ProductSet set, Object token) throws VisADException {
        int bytes = BinaryProductSet.computeBytes(sets, cs, units, errors);
        this.size.add(bytes);
    }

    public void processReal(RealType type, double value, Unit unit, ErrorEstimate error, Real real, Object token) throws VisADException {
        int bytes = BinaryReal.computeBytes(unit, error);
        this.size.add(bytes);
    }

    public void processRealTuple(RealTupleType type, Real[] components, CoordinateSystem cs, RealTuple rt, Object token) throws VisADException {
        boolean trivialTuple = BinaryRealTuple.isTrivialTuple(type, components);
        int bytes = BinaryRealTuple.computeBytes(components, cs, trivialTuple);
        this.size.add(bytes);
    }

    public void processSampledSet(SetType st, int manifold_dimension, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, SampledSet set, Object token) throws VisADException {
        throw new UnimplementedException();
    }

    public void processSimpleSet(SetType st, int manifold_dimension, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, SimpleSet set, Object token) throws VisADException {
        int bytes = BinarySimpleSet.computeBytes(cs, units);
        this.size.add(bytes);
    }

    public void processSingletonSet(RealTuple sample, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, SingletonSet set, Object token) throws VisADException {
        RealTupleType sampleType = (RealTupleType)sample.getType();
        Real[] sampleReals = BinarySingletonSet.getSampleReals(sample);
        int bytes = BinarySingletonSet.computeBytes(sampleType, sampleReals, cs, units, errors);
        this.size.add(bytes);
    }

    public void processText(TextType type, String value, boolean missing, Text text, Object token) throws VisADException {
        int bytes = BinaryText.computeBytes(value);
        this.size.add(bytes);
    }

    public void processTuple(TupleType type, Data[] components, Tuple t2, Object token) throws VisADException {
        int bytes = BinaryTuple.computeBytes(components);
        this.size.add(bytes);
    }

    public void processUnionSet(SetType type, SampledSet[] sets, UnionSet set, Object token) throws VisADException {
        int bytes = BinaryUnionSet.computeBytes(sets);
        this.size.add(bytes);
    }

    public void processUnknownData(DataImpl data, Object token) throws VisADException {
        int bytes = BinaryUnknown.computeBytes(data);
        this.size.add(bytes);
    }

    public final void reset() {
        this.size.reset();
    }

    public final void setSize(int newSize) {
        this.size.set(newSize);
    }
}

