/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryObject;

public class BinaryIntegerMatrix
implements BinaryObject {
    private static final boolean fasterButUglier = true;

    static final int computeBytes(int[][] matrix) {
        if (matrix == null) {
            return 4;
        }
        int len = 4;
        int i = 0;
        while (i < matrix.length) {
            len += 4 + matrix[i].length * 4;
            ++i;
        }
        return len;
    }

    static final int[][] read(DataInput file) throws IOException {
        int len = file.readInt();
        if (len < 0) {
            return null;
        }
        int[][] matrix = new int[len][];
        int i = 0;
        while (i < len) {
            int len2 = file.readInt();
            matrix[i] = new int[len2];
            int j = 0;
            while (j < len2) {
                matrix[i][j] = file.readInt();
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    static final void write(DataOutput file, int[][] matrix) throws IOException {
        if (matrix == null) {
            file.writeInt(-1);
        } else {
            byte[] buf = new byte[4 + matrix.length * (4 + 4 * matrix[0].length)];
            int bufIdx = 0;
            int b2 = 3;
            int l = matrix.length;
            while (b2 >= 0) {
                buf[bufIdx + b2] = (byte)(l & 0xFF);
                l >>= 8;
                --b2;
            }
            bufIdx += 4;
            int i = 0;
            while (i < matrix.length) {
                int len = matrix[i].length;
                int b3 = 3;
                int l2 = len;
                while (b3 >= 0) {
                    buf[bufIdx + b3] = (byte)(l2 & 0xFF);
                    l2 >>= 8;
                    --b3;
                }
                bufIdx += 4;
                int j = 0;
                while (j < len) {
                    int x = matrix[i][j];
                    int b4 = 3;
                    while (b4 >= 0) {
                        buf[bufIdx + b4] = (byte)(x & 0xFF);
                        x >>= 8;
                        --b4;
                    }
                    bufIdx += 4;
                    ++j;
                }
                ++i;
            }
            file.write(buf);
        }
    }

    public static final void write(BinaryWriter writer, int[][] matrix, Object token) throws IOException {
        DataOutput file = writer.getOutput();
        BinaryIntegerMatrix.write(file, matrix);
    }
}

