/*
 * Decompiled with CFR 0.152.
 */
package visad.java2d;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.lang.reflect.Constructor;
import visad.DisplayImpl;
import visad.MouseBehavior;
import visad.MouseHelper;
import visad.VisADError;
import visad.VisADRay;
import visad.java2d.DisplayRendererJ2D;
import visad.java2d.VisADCanvasJ2D;

public class MouseBehaviorJ2D
implements MouseBehavior {
    DisplayRendererJ2D display_renderer;
    DisplayImpl display;
    private MouseHelper helper = null;
    static final double EPS = 1.0E-6;
    static /* synthetic */ Class class$visad$MouseHelper;
    static /* synthetic */ Class class$visad$DisplayRenderer;
    static /* synthetic */ Class class$visad$MouseBehavior;

    public MouseBehaviorJ2D(DisplayRendererJ2D r) {
        this(r, class$visad$MouseHelper == null ? (class$visad$MouseHelper = MouseBehaviorJ2D.class$("visad.MouseHelper")) : class$visad$MouseHelper);
    }

    public MouseBehaviorJ2D(DisplayRendererJ2D r, Class mhClass) {
        try {
            Class[] param = new Class[]{class$visad$DisplayRenderer == null ? (class$visad$DisplayRenderer = MouseBehaviorJ2D.class$("visad.DisplayRenderer")) : class$visad$DisplayRenderer, class$visad$MouseBehavior == null ? (class$visad$MouseBehavior = MouseBehaviorJ2D.class$("visad.MouseBehavior")) : class$visad$MouseBehavior};
            Constructor mhConstructor = mhClass.getConstructor(param);
            this.helper = (MouseHelper)mhConstructor.newInstance(r, this);
        }
        catch (Exception e2) {
            throw new VisADError("cannot construct " + mhClass);
        }
        this.display_renderer = r;
        this.display = this.display_renderer.getDisplay();
    }

    public MouseHelper getMouseHelper() {
        return this.helper;
    }

    public VisADRay findRay(int screen_x, int screen_y) {
        VisADCanvasJ2D canvas = this.display_renderer.getCanvas();
        AffineTransform trans = canvas.getTransform();
        if (trans == null) {
            return null;
        }
        double[] coords = new double[]{screen_x, screen_y};
        double[] newcoords = new double[2];
        try {
            trans.inverseTransform(coords, 0, newcoords, 0, 1);
        }
        catch (NoninvertibleTransformException e2) {
            throw new VisADError("MouseBehaviorJ2D.findRay: non-invertable transform");
        }
        VisADRay ray = new VisADRay();
        ray.position[0] = newcoords[0];
        ray.position[1] = newcoords[1];
        ray.position[2] = 0.0;
        ray.vector[0] = 0.0;
        ray.vector[1] = 0.0;
        ray.vector[2] = -1.0;
        return ray;
    }

    public VisADRay cursorRay(double[] cursor) {
        VisADRay ray = new VisADRay();
        ray.position[0] = cursor[0];
        ray.position[1] = cursor[1];
        ray.position[2] = 0.0;
        ray.vector[0] = 0.0;
        ray.vector[1] = 0.0;
        ray.vector[2] = -1.0;
        return ray;
    }

    public int[] getScreenCoords(double[] position) {
        VisADCanvasJ2D canvas = this.display_renderer.getCanvas();
        AffineTransform trans = canvas.getTransform();
        if (trans == null) {
            return null;
        }
        double[] newcoords = new double[2];
        trans.transform(position, 0, newcoords, 0, 1);
        int[] coords = new int[2];
        int i = 0;
        while (i < 2) {
            coords[i] = (int)newcoords[i];
            ++i;
        }
        return coords;
    }

    public double[] make_translate(double transx, double transy, double transz) {
        return this.make_matrix(0.0, 0.0, 0.0, 1.0, transx, -transy, transz);
    }

    public double[] make_translate(double transx, double transy) {
        return this.make_translate(transx, transy, 0.0);
    }

    public double[] multiply_matrix(double[] a2, double[] b2) {
        AffineTransform ta = new AffineTransform(a2);
        AffineTransform tb = new AffineTransform(b2);
        ta.concatenate(tb);
        double[] c2 = new double[6];
        ta.getMatrix(c2);
        return c2;
    }

    public double[] make_matrix(double rotx, double roty, double rotz, double scale, double transx, double transy, double transz) {
        double t2;
        double deg2rad = 0.017453316741046887;
        double[] matrix = new double[6];
        double[][] mat = new double[4][4];
        double sx = Math.sin(rotx * deg2rad);
        double cx = Math.cos(rotx * deg2rad);
        double sy = Math.sin(roty * deg2rad);
        double cy = Math.cos(roty * deg2rad);
        double sz = Math.sin(rotz * deg2rad);
        double cz = Math.cos(rotz * deg2rad);
        mat[0][0] = 1.0;
        mat[0][1] = 0.0;
        mat[0][2] = 0.0;
        mat[0][3] = 0.0;
        mat[1][0] = 0.0;
        mat[1][1] = 1.0;
        mat[1][2] = 0.0;
        mat[1][3] = 0.0;
        mat[2][0] = 0.0;
        mat[2][1] = 0.0;
        mat[2][2] = 1.0;
        mat[2][3] = 0.0;
        mat[3][0] = 0.0;
        mat[3][1] = 0.0;
        mat[3][2] = 0.0;
        mat[3][3] = 1.0;
        int i = 0;
        while (i < 4) {
            t2 = mat[i][0];
            mat[i][0] = t2 * cz - mat[i][1] * sz;
            mat[i][1] = t2 * sz + mat[i][1] * cz;
            ++i;
        }
        i = 0;
        while (i < 4) {
            t2 = mat[i][1];
            mat[i][1] = t2 * cx - mat[i][2] * sx;
            mat[i][2] = t2 * sx + mat[i][2] * cx;
            ++i;
        }
        i = 0;
        while (i < 4) {
            t2 = mat[i][0];
            mat[i][0] = mat[i][2] * sy + t2 * cy;
            mat[i][2] = mat[i][2] * cy - t2 * sy;
            ++i;
        }
        i = 0;
        while (i < 3) {
            double[] dArray = mat[i];
            dArray[0] = dArray[0] * scale;
            double[] dArray2 = mat[i];
            dArray2[1] = dArray2[1] * scale;
            double[] dArray3 = mat[i];
            dArray3[2] = dArray3[2] * scale;
            ++i;
        }
        mat[0][3] = transx;
        mat[1][3] = transy;
        mat[2][3] = transz;
        matrix[0] = mat[0][0];
        matrix[1] = mat[1][0];
        matrix[2] = mat[0][1];
        matrix[3] = mat[1][1];
        matrix[4] = mat[0][3];
        matrix[5] = mat[1][3];
        return matrix;
    }

    public void instance_unmake_matrix(double[] rot, double[] scale, double[] trans, double[] matrix) {
        double cz;
        double sz;
        double cy;
        double sy;
        double cx;
        double cxb;
        double[][] mat = new double[4][4];
        double[][] nat = new double[4][4];
        if (rot == null || rot.length != 3) {
            return;
        }
        if (scale == null || scale.length != 1) {
            return;
        }
        if (trans == null || trans.length != 3) {
            return;
        }
        if (matrix == null || matrix.length != 6) {
            return;
        }
        mat[0][0] = 1.0;
        mat[0][1] = 0.0;
        mat[0][2] = 0.0;
        mat[0][3] = 0.0;
        mat[1][0] = 0.0;
        mat[1][1] = 1.0;
        mat[1][2] = 0.0;
        mat[1][3] = 0.0;
        mat[2][0] = 0.0;
        mat[2][1] = 0.0;
        mat[2][2] = 1.0;
        mat[2][3] = 0.0;
        mat[3][0] = 0.0;
        mat[3][1] = 0.0;
        mat[3][2] = 0.0;
        mat[3][3] = 1.0;
        mat[0][0] = matrix[0];
        mat[1][0] = matrix[1];
        mat[0][1] = matrix[2];
        mat[1][1] = matrix[3];
        mat[0][3] = matrix[4];
        mat[1][3] = matrix[5];
        trans[0] = mat[0][3];
        trans[1] = mat[1][3];
        trans[2] = mat[2][3];
        double scalez = 0.0;
        double scaley = 0.0;
        double scalex = 0.0;
        int i = 0;
        while (i < 3) {
            scalex += mat[0][i] * mat[0][i];
            scaley += mat[1][i] * mat[1][i];
            scalez += mat[2][i] * mat[2][i];
            ++i;
        }
        if (Math.abs(scalex - scaley) > 1.0E-6 || Math.abs(scalex - scalez) > 1.0E-6) {
            // empty if block
        }
        scale[0] = Math.sqrt((scalex + scaley + scalez) / 3.0);
        double scaleinv = Math.abs(scale[0]) > 1.0E-6 ? 1.0 / scale[0] : 1000000.0;
        i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                nat[j][i] = scaleinv * mat[j][i];
                ++j;
            }
            ++i;
        }
        double sx = -nat[2][1];
        double cxa = Math.sqrt(nat[2][0] * nat[2][0] + nat[2][2] * nat[2][2]);
        if (Math.abs(cxa - (cxb = Math.sqrt(nat[0][1] * nat[0][1] + nat[1][1] * nat[1][1]))) > 1.0E-6) {
            // empty if block
        }
        if (Math.abs(cx = (cxa + cxb) / 2.0) > 1.0E-6) {
            double cxinv = 1.0 / cx;
            sy = nat[2][0] * cxinv;
            cy = nat[2][2] * cxinv;
            sz = nat[0][1] * cxinv;
            cz = nat[1][1] * cxinv;
        } else {
            sy = 0.0;
            cy = 1.0;
            sz = nat[0][2];
            cz = nat[1][2];
        }
        rot[0] = 57.2957 * Math.atan2(sx, cx);
        rot[1] = 57.2957 * Math.atan2(sy, cy);
        rot[2] = 57.2957 * Math.atan2(sz, cz);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

