/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.rmi.RemoteException;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import visad.Data;
import visad.DataDisplayLink;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.VisADException;
import visad.collab.CollabUtil;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.RendererJ3D;
import visad.java3d.ShadowTypeJ3D;

public class DefaultRendererJ3D
extends RendererJ3D {
    DataDisplayLink link = null;

    public void setLinks(DataDisplayLink[] links, DisplayImpl d2) throws VisADException {
        if (links == null || links.length != 1) {
            throw new DisplayException("DefaultRendererJ3D.setLinks: must be exactly one DataDisplayLink");
        }
        super.setLinks(links, d2);
        this.link = links[0];
    }

    public BranchGroup doTransform() throws VisADException, RemoteException {
        Data data;
        if (this.link == null) {
            return null;
        }
        BranchGroup branch = new BranchGroup();
        branch.setCapability(17);
        branch.setCapability(12);
        ShadowTypeJ3D type = (ShadowTypeJ3D)this.link.getShadow();
        int valueArrayLength = this.getDisplay().getValueArrayLength();
        float[] valueArray = new float[valueArrayLength];
        int i = 0;
        while (i < valueArrayLength) {
            valueArray[i] = Float.NaN;
            ++i;
        }
        try {
            data = this.link.getData();
        }
        catch (RemoteException re) {
            if (CollabUtil.isDisconnectException(re)) {
                this.getDisplay().connectionFailed(this, this.link);
                this.removeLink(this.link);
                return null;
            }
            throw re;
        }
        if (data == null) {
            branch = null;
            this.addException(new DisplayException("Data is null: DefaultRendererJ3D.doTransform"));
        } else {
            boolean post_process;
            this.link.start_time = System.currentTimeMillis();
            this.link.time_flag = false;
            type.preProcess();
            try {
                post_process = type.doTransform(branch, data, valueArray, this.link.getDefaultValues(), this);
            }
            catch (RemoteException re) {
                if (CollabUtil.isDisconnectException(re)) {
                    this.getDisplay().connectionFailed(this, this.link);
                    this.removeLink(this.link);
                    return null;
                }
                throw re;
            }
            if (post_process) {
                type.postProcess(branch);
            }
        }
        this.link.clearData();
        return branch;
    }

    public void addSwitch(DisplayRendererJ3D displayRenderer, BranchGroup branch) {
        displayRenderer.addSceneGraphComponent((Group)branch);
    }

    public DataDisplayLink getLink() {
        return this.link;
    }

    public void clearScene() {
        this.link = null;
        super.clearScene();
    }

    public Object clone() throws CloneNotSupportedException {
        return new DefaultRendererJ3D();
    }
}

