/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import javax.media.j3d.BranchGroup;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.UniverseBuilderJ3D;
import visad.java3d.VisADCanvasJ3D;

public class DisplayPanelJ3D
extends JPanel {
    private DisplayImplJ3D display;
    private DisplayRendererJ3D renderer;
    private UniverseBuilderJ3D universe;

    public DisplayPanelJ3D(DisplayImplJ3D d2) {
        this(d2, null, null);
    }

    public DisplayPanelJ3D(DisplayImplJ3D d2, GraphicsConfiguration config, VisADCanvasJ3D c2) {
        this.display = d2;
        this.renderer = (DisplayRendererJ3D)this.display.getDisplayRenderer();
        this.setLayout(new BoxLayout(this, 0));
        VisADCanvasJ3D canvas = c2 != null ? c2 : new VisADCanvasJ3D(this.renderer, config);
        canvas.setComponent(this);
        this.add((Component)((Object)canvas));
        this.universe = new UniverseBuilderJ3D(canvas);
        BranchGroup scene = this.renderer.createSceneGraph(this.universe.view, this.universe.vpTrans, canvas);
        this.universe.addBranchGraph(scene);
        this.setPreferredSize(new Dimension(256, 256));
        this.setMinimumSize(new Dimension(0, 0));
    }

    public void destroy() {
        this.display = null;
        this.renderer = null;
        if (this.universe != null) {
            this.universe.destroy();
            this.universe = null;
        }
    }
}

