/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.awt.AWTEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOr;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import visad.DisplayImpl;
import visad.MouseBehavior;
import visad.MouseHelper;
import visad.VisADError;
import visad.VisADRay;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.VisADCanvasJ3D;

public class MouseBehaviorJ3D
extends Behavior
implements MouseBehavior {
    private WakeupOr wakeup;
    DisplayRendererJ3D display_renderer;
    DisplayImpl display;
    MouseHelper helper = null;
    private Method getPixelLocationFromImagePlateMethod = null;
    static final double EPS = 1.0E-6;
    static /* synthetic */ Class class$visad$MouseHelper;
    static /* synthetic */ Class class$visad$DisplayRenderer;
    static /* synthetic */ Class class$visad$MouseBehavior;
    static /* synthetic */ Class class$javax$vecmath$Point3d;
    static /* synthetic */ Class class$javax$vecmath$Point2d;

    public MouseBehaviorJ3D() {
    }

    public MouseBehaviorJ3D(DisplayRendererJ3D r) {
        this(r, class$visad$MouseHelper == null ? (class$visad$MouseHelper = MouseBehaviorJ3D.class$("visad.MouseHelper")) : class$visad$MouseHelper);
    }

    public MouseBehaviorJ3D(DisplayRendererJ3D r, Class mhClass) {
        try {
            Class[] param = new Class[]{class$visad$DisplayRenderer == null ? (class$visad$DisplayRenderer = MouseBehaviorJ3D.class$("visad.DisplayRenderer")) : class$visad$DisplayRenderer, class$visad$MouseBehavior == null ? (class$visad$MouseBehavior = MouseBehaviorJ3D.class$("visad.MouseBehavior")) : class$visad$MouseBehavior};
            Constructor mhConstructor = mhClass.getConstructor(param);
            this.helper = (MouseHelper)mhConstructor.newInstance(r, this);
        }
        catch (Exception e2) {
            throw new VisADError("cannot construct " + mhClass);
        }
        this.display_renderer = r;
        this.display = this.display_renderer.getDisplay();
        WakeupCriterion[] conditions = new WakeupCriterion[]{new WakeupOnAWTEvent(506), new WakeupOnAWTEvent(504), new WakeupOnAWTEvent(505), new WakeupOnAWTEvent(501), new WakeupOnAWTEvent(502), new WakeupOnAWTEvent(503)};
        this.wakeup = new WakeupOr(conditions);
    }

    public void destroy() {
        this.helper = null;
        this.display = null;
        this.display_renderer = null;
    }

    public MouseHelper getMouseHelper() {
        return this.helper;
    }

    public void initialize() {
        this.setWakeup();
    }

    public void processStimulus(Enumeration criteria) {
        while (criteria.hasMoreElements()) {
            WakeupCriterion wakeup = (WakeupCriterion)criteria.nextElement();
            if (!(wakeup instanceof WakeupOnAWTEvent)) {
                System.out.println("MouseBehaviorJ3D.processStimulus: non-WakeupOnAWTEvent");
                continue;
            }
            AWTEvent[] events = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
            int i = 0;
            while (i < events.length) {
                this.helper.processEvent(events[i]);
                ++i;
            }
        }
        this.setWakeup();
    }

    public VisADRay findRay(int screen_x, int screen_y) {
        View view = this.display_renderer.getView();
        VisADCanvasJ3D canvas = this.display_renderer.getCanvas();
        Point3d position = new Point3d();
        canvas.getPixelLocationInImagePlate(screen_x, screen_y, position);
        Point3d eye_position = new Point3d();
        canvas.getCenterEyeInImagePlate(eye_position);
        Transform3D t2 = new Transform3D();
        canvas.getImagePlateToVworld(t2);
        t2.transform(position);
        t2.transform(eye_position);
        if (this.display.getGraphicsModeControl().getProjectionPolicy() == 0) {
            eye_position = new Point3d(position.x, position.y, position.z + 1.0);
        }
        TransformGroup trans = this.display_renderer.getTrans();
        Transform3D tt = new Transform3D();
        trans.getTransform(tt);
        tt.invert();
        tt.transform(position);
        tt.transform(eye_position);
        Vector3d vector = new Vector3d(position.x - eye_position.x, position.y - eye_position.y, position.z - eye_position.z);
        vector.normalize();
        VisADRay ray = new VisADRay();
        ray.position[0] = position.x;
        ray.position[1] = position.y;
        ray.position[2] = position.z;
        ray.vector[0] = vector.x;
        ray.vector[1] = vector.y;
        ray.vector[2] = vector.z;
        return ray;
    }

    public VisADRay cursorRay(double[] cursor) {
        View view = this.display_renderer.getView();
        VisADCanvasJ3D canvas = this.display_renderer.getCanvas();
        Point3d position = new Point3d(cursor[0], cursor[1], cursor[2]);
        Point3d eye_position = new Point3d();
        canvas.getCenterEyeInImagePlate(eye_position);
        Transform3D t2 = new Transform3D();
        canvas.getImagePlateToVworld(t2);
        t2.transform(eye_position);
        TransformGroup trans = this.display_renderer.getTrans();
        Transform3D tt = new Transform3D();
        trans.getTransform(tt);
        tt.transform(position);
        if (this.display.getGraphicsModeControl().getProjectionPolicy() == 0) {
            eye_position = new Point3d(position.x, position.y, position.z + 1.0);
        }
        tt.invert();
        tt.transform(position);
        tt.transform(eye_position);
        Vector3d vector = new Vector3d(position.x - eye_position.x, position.y - eye_position.y, position.z - eye_position.z);
        vector.normalize();
        VisADRay ray = new VisADRay();
        ray.position[0] = eye_position.x;
        ray.position[1] = eye_position.y;
        ray.position[2] = eye_position.z;
        ray.vector[0] = vector.x;
        ray.vector[1] = vector.y;
        ray.vector[2] = vector.z;
        return ray;
    }

    public int[] getScreenCoords(double[] position) {
        if (this.getPixelLocationFromImagePlateMethod == null) {
            try {
                Class<?> canvas3DClass = Class.forName("javax.media.j3d.Canvas3D");
                Class[] param = new Class[]{class$javax$vecmath$Point3d == null ? (class$javax$vecmath$Point3d = MouseBehaviorJ3D.class$("javax.vecmath.Point3d")) : class$javax$vecmath$Point3d, class$javax$vecmath$Point2d == null ? (class$javax$vecmath$Point2d = MouseBehaviorJ3D.class$("javax.vecmath.Point2d")) : class$javax$vecmath$Point2d};
                this.getPixelLocationFromImagePlateMethod = canvas3DClass.getMethod("getPixelLocationFromImagePlate", param);
                if (this.getPixelLocationFromImagePlateMethod == null) {
                    return null;
                }
            }
            catch (Exception e2) {
                return null;
            }
        }
        VisADCanvasJ3D canvas = this.display_renderer.getCanvas();
        Transform3D t2 = new Transform3D();
        canvas.getImagePlateToVworld(t2);
        TransformGroup trans = this.display_renderer.getTrans();
        Transform3D tt = new Transform3D();
        trans.getTransform(tt);
        Point3d pos = new Point3d(position);
        tt.transform(pos);
        t2.invert();
        t2.transform(pos);
        Point2d coords = new Point2d();
        try {
            this.getPixelLocationFromImagePlateMethod.invoke((Object)canvas, pos, coords);
        }
        catch (Exception e3) {
            return null;
        }
        return new int[]{(int)coords.x, (int)coords.y};
    }

    void setWakeup() {
        this.wakeupOn((WakeupCondition)this.wakeup);
    }

    public double[] make_translate(double transx, double transy, double transz) {
        return this.make_matrix(0.0, 0.0, 0.0, 1.0, transx, transy, transz);
    }

    public double[] make_translate(double transx, double transy) {
        return this.make_translate(transx, transy, 0.0);
    }

    public double[] multiply_matrix(double[] a2, double[] b2) {
        return MouseBehaviorJ3D.static_multiply_matrix(a2, b2);
    }

    public static double[] static_multiply_matrix(double[] a2, double[] b2) {
        Transform3D ta = new Transform3D(a2);
        Transform3D tb = new Transform3D(b2);
        ta.mul(tb);
        double[] c2 = new double[16];
        ta.get(c2);
        return c2;
    }

    public double[] make_matrix(double rotx, double roty, double rotz, double scale, double transx, double transy, double transz) {
        return MouseBehaviorJ3D.static_make_matrix(rotx, roty, rotz, scale, transx, transy, transz);
    }

    public static double[] static_make_matrix(double rotx, double roty, double rotz, double scale, double transx, double transy, double transz) {
        double t2;
        double deg2rad = 0.017453316741046887;
        double[] matrix = new double[16];
        double[][] mat = new double[4][4];
        double sx = Math.sin(rotx * deg2rad);
        double cx = Math.cos(rotx * deg2rad);
        double sy = Math.sin(roty * deg2rad);
        double cy = Math.cos(roty * deg2rad);
        double sz = Math.sin(rotz * deg2rad);
        double cz = Math.cos(rotz * deg2rad);
        mat[0][0] = 1.0;
        mat[0][1] = 0.0;
        mat[0][2] = 0.0;
        mat[0][3] = 0.0;
        mat[1][0] = 0.0;
        mat[1][1] = 1.0;
        mat[1][2] = 0.0;
        mat[1][3] = 0.0;
        mat[2][0] = 0.0;
        mat[2][1] = 0.0;
        mat[2][2] = 1.0;
        mat[2][3] = 0.0;
        mat[3][0] = 0.0;
        mat[3][1] = 0.0;
        mat[3][2] = 0.0;
        mat[3][3] = 1.0;
        int i = 0;
        while (i < 4) {
            t2 = mat[i][0];
            mat[i][0] = t2 * cz - mat[i][1] * sz;
            mat[i][1] = t2 * sz + mat[i][1] * cz;
            ++i;
        }
        i = 0;
        while (i < 4) {
            t2 = mat[i][1];
            mat[i][1] = t2 * cx - mat[i][2] * sx;
            mat[i][2] = t2 * sx + mat[i][2] * cx;
            ++i;
        }
        i = 0;
        while (i < 4) {
            t2 = mat[i][0];
            mat[i][0] = mat[i][2] * sy + t2 * cy;
            mat[i][2] = mat[i][2] * cy - t2 * sy;
            ++i;
        }
        i = 0;
        while (i < 3) {
            double[] dArray = mat[i];
            dArray[0] = dArray[0] * scale;
            double[] dArray2 = mat[i];
            dArray2[1] = dArray2[1] * scale;
            double[] dArray3 = mat[i];
            dArray3[2] = dArray3[2] * scale;
            ++i;
        }
        mat[0][3] = transx;
        mat[1][3] = transy;
        mat[2][3] = transz;
        int k = 0;
        i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                matrix[k] = mat[i][j];
                ++k;
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public void instance_unmake_matrix(double[] rot, double[] scale, double[] trans, double[] matrix) {
        MouseBehaviorJ3D.unmake_matrix(rot, scale, trans, matrix);
    }

    public static void unmake_matrix(double[] rot, double[] scale, double[] trans, double[] matrix) {
        double cz;
        double sz;
        double cy;
        double sy;
        double cx;
        double cxb;
        int j;
        double[][] mat = new double[4][4];
        double[][] nat = new double[4][4];
        if (rot == null || rot.length != 3) {
            return;
        }
        if (scale == null || scale.length != 1) {
            return;
        }
        if (trans == null || trans.length != 3) {
            return;
        }
        if (matrix == null || matrix.length != 16) {
            return;
        }
        int k = 0;
        int i = 0;
        while (i < 4) {
            j = 0;
            while (j < 4) {
                mat[i][j] = matrix[k];
                ++k;
                ++j;
            }
            ++i;
        }
        trans[0] = mat[0][3];
        trans[1] = mat[1][3];
        trans[2] = mat[2][3];
        double scalez = 0.0;
        double scaley = 0.0;
        double scalex = 0.0;
        i = 0;
        while (i < 3) {
            scalex += mat[0][i] * mat[0][i];
            scaley += mat[1][i] * mat[1][i];
            scalez += mat[2][i] * mat[2][i];
            ++i;
        }
        if (Math.abs(scalex - scaley) > 1.0E-6 || Math.abs(scalex - scalez) > 1.0E-6) {
            // empty if block
        }
        scale[0] = Math.sqrt((scalex + scaley + scalez) / 3.0);
        double scaleinv = Math.abs(scale[0]) > 1.0E-6 ? 1.0 / scale[0] : 1000000.0;
        i = 0;
        while (i < 3) {
            j = 0;
            while (j < 3) {
                nat[j][i] = scaleinv * mat[j][i];
                ++j;
            }
            ++i;
        }
        double sx = -nat[2][1];
        double cxa = Math.sqrt(nat[2][0] * nat[2][0] + nat[2][2] * nat[2][2]);
        if (Math.abs(cxa - (cxb = Math.sqrt(nat[0][1] * nat[0][1] + nat[1][1] * nat[1][1]))) > 1.0E-6) {
            // empty if block
        }
        if (Math.abs(cx = (cxa + cxb) / 2.0) > 1.0E-6) {
            double cxinv = 1.0 / cx;
            sy = nat[2][0] * cxinv;
            cy = nat[2][2] * cxinv;
            sz = nat[0][1] * cxinv;
            cz = nat[1][1] * cxinv;
        } else {
            sy = 0.0;
            cy = 1.0;
            sz = nat[0][2];
            cz = nat[1][2];
        }
        rot[0] = 57.2957 * Math.atan2(sx, cx);
        rot[1] = 57.2957 * Math.atan2(sy, cy);
        rot[2] = 57.2957 * Math.atan2(sz, cz);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

