/*
 * Decompiled with CFR 0.152.
 */
package visad.matrix;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import visad.Data;
import visad.FunctionType;
import visad.RealTupleType;
import visad.RealType;
import visad.Tuple;
import visad.VisADException;
import visad.matrix.JamaMatrix;

public class JamaQRDecomposition
extends Tuple {
    private static final RealType QRQ_row = RealType.getRealType("QR_Q_row");
    private static final RealType QRQ_column = RealType.getRealType("QR_Q_column");
    private static final RealType QRQ_value = RealType.getRealType("QR_Q_value");
    private static final FunctionType QRQType = JamaQRDecomposition.constructQFunction();
    private static final RealType QRR_row = RealType.getRealType("QR_R_row");
    private static final RealType QRR_column = RealType.getRealType("QR_R_column");
    private static final RealType QRR_value = RealType.getRealType("QR_R_value");
    private static final FunctionType QRRType = JamaQRDecomposition.constructRFunction();
    private static final RealType QRH_row = RealType.getRealType("QR_H_row");
    private static final RealType QRH_column = RealType.getRealType("QR_H_column");
    private static final RealType QRH_value = RealType.getRealType("QR_H_value");
    private static final FunctionType QRHType = JamaQRDecomposition.constructHFunction();
    private static final Class[] classes = JamaQRDecomposition.constructClasses();
    private static final Class classMatrix = classes[0];
    private static final Class classCholeskyDecomposition = classes[1];
    private static final Class classEigenvalueDecomposition = classes[2];
    private static final Class classLUDecomposition = classes[3];
    private static final Class classQRDecomposition = classes[4];
    private static final Class classSingularValueDecomposition = classes[5];
    private Object qrd = ((JamaMatrix)this.getComponent(0)).getStash();
    private static final Method[] methods = JamaQRDecomposition.constructMethods();
    private static final Method getH = methods[0];
    private static final Method getQ = methods[1];
    private static final Method getR = methods[2];
    private static final Method isFullRank = methods[3];
    private static final Method solve = methods[4];
    private static final Constructor matrixQRDecomposition = JamaQRDecomposition.constructConstructor();

    private static FunctionType constructQFunction() {
        try {
            RealTupleType tuple = new RealTupleType(QRQ_row, QRQ_column);
            FunctionType function = new FunctionType(tuple, QRQ_value);
            return function;
        }
        catch (VisADException exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private static FunctionType constructRFunction() {
        try {
            RealTupleType tuple = new RealTupleType(QRR_row, QRR_column);
            FunctionType function = new FunctionType(tuple, QRR_value);
            return function;
        }
        catch (VisADException exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private static FunctionType constructHFunction() {
        try {
            RealTupleType tuple = new RealTupleType(QRH_row, QRH_column);
            FunctionType function = new FunctionType(tuple, QRH_value);
            return function;
        }
        catch (VisADException exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private static Class[] constructClasses() {
        Class[] cs = new Class[6];
        try {
            cs[0] = Class.forName("Jama.Matrix");
            cs[1] = Class.forName("Jama.CholeskyDecomposition");
            cs[2] = Class.forName("Jama.EigenvalueDecomposition");
            cs[3] = Class.forName("Jama.LUDecomposition");
            cs[4] = Class.forName("Jama.QRDecomposition");
            cs[5] = Class.forName("Jama.SingularValueDecomposition");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        return cs;
    }

    private static Method[] constructMethods() {
        Method[] ms = new Method[5];
        try {
            Class[] param = new Class[]{};
            ms[0] = classQRDecomposition.getMethod("getH", param);
            ms[1] = classQRDecomposition.getMethod("getQ", param);
            ms[2] = classQRDecomposition.getMethod("getR", param);
            ms[3] = classQRDecomposition.getMethod("isFullRank", param);
            param = new Class[]{classMatrix};
            ms[4] = classQRDecomposition.getMethod("solve", param);
        }
        catch (NoSuchMethodException e2) {
            e2.printStackTrace();
        }
        return ms;
    }

    private static Constructor constructConstructor() {
        try {
            Class[] param = new Class[]{classMatrix};
            return classQRDecomposition.getConstructor(param);
        }
        catch (NoSuchMethodException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public JamaQRDecomposition(JamaMatrix matrix) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        this(matrixQRDecomposition.newInstance(matrix.getMatrix()), false);
    }

    JamaQRDecomposition(Object qr, boolean copy) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        super(JamaQRDecomposition.makeDatums(qr), copy);
    }

    private static Data[] makeDatums(Object qr) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        Object q = getQ.invoke(qr, new Object[0]);
        JamaMatrix jq = new JamaMatrix(q, QRQType, null, null, null, null, null);
        jq.setStash(qr);
        Object r = getR.invoke(qr, new Object[0]);
        JamaMatrix jr = new JamaMatrix(r, QRQType, null, null, null, null, null);
        return new Data[]{jq, jr};
    }

    public Object getQRDecomposition() {
        return this.qrd;
    }

    public JamaMatrix getQ() throws VisADException, RemoteException {
        if (classQRDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        return (JamaMatrix)this.getComponent(0);
    }

    public JamaMatrix getR() throws VisADException, RemoteException {
        if (classQRDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        return (JamaMatrix)this.getComponent(1);
    }

    public JamaMatrix getH() throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classQRDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object m = getH.invoke(this.qrd, new Object[0]);
        return new JamaMatrix(m, QRHType, null, null, null, null, null);
    }

    public boolean isFullRank() throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classQRDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        boolean fr = (Boolean)isFullRank.invoke(this.qrd, new Object[0]);
        return fr;
    }

    public JamaMatrix solve(JamaMatrix B) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classQRDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object m = solve.invoke(this.qrd, B.getMatrix());
        return new JamaMatrix(m);
    }
}

